/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.sms;

import cn.org.gddsn.convert.CStringToJava;
import cn.org.gddsn.security.Bytes;
import cn.org.gddsn.security.MD5;
import cn.org.gddsn.sms.SendSMSByGW;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public class CQSMSGW
implements SendSMSByGW {
    static Logger logger = Logger.getLogger(CQSMSGW.class);
    private String gateway = "218.201.44.67";
    private int port = 9998;
    private String eid = "13996446667";
    private String uid = "master";
    private String password = "703";

    public static void main(String[] args) throws Exception {
        CQSMSGW t = new CQSMSGW();
        t.send(new String[]{"13600050073", "13600050073"}, "\u6d4b\u8bd5");
    }

    public int send(String[] phones, String msg) {
        Socket socket = null;
        try {
            try {
                int seq = 0;
                socket = new Socket(this.gateway, this.port);
                socket.setSoTimeout(60000);
                MGW_CONNECT_REQ req = MGW_CONNECT_REQ.build(this.eid, this.uid, this.password, seq);
                socket.getOutputStream().write(req.toBytes());
                byte[] buf_h = new byte[13];
                socket.getInputStream().read(buf_h);
                MGW_Header header = MGW_Header.build(buf_h);
                byte[] body = new byte[header.length - 13];
                socket.getInputStream().read(body);
                MGW_RSP rsp = MGW_RSP.build(header, body);
                System.out.println(rsp.code);
                System.out.println(rsp.getStringCode());
                MGW_GET_NAME_REQ get_name_req = MGW_GET_NAME_REQ.build(this.eid, this.uid, ++seq);
                socket.getOutputStream().write(get_name_req.toBytes());
                buf_h = new byte[13];
                socket.getInputStream().read(buf_h);
                header = MGW_Header.build(buf_h);
                body = new byte[header.length - 13];
                socket.getInputStream().read(body);
                rsp = MGW_RSP.build(header, body);
                System.out.println(rsp.code);
                CStringToJava.tailToZero(rsp.rsp, rsp.rsp.length);
                System.out.println(rsp.getStringCode());
                String userName = rsp.getStringCode().trim();
                MGW_SEND_REQ send_req = MGW_SEND_REQ.build(this.eid, this.uid, phones, userName, msg, ++seq);
                socket.getOutputStream().write(send_req.toBytes());
                buf_h = new byte[13];
                socket.getInputStream().read(buf_h);
                header = MGW_Header.build(buf_h);
                body = new byte[header.length - 13];
                socket.getInputStream().read(body);
                rsp = MGW_RSP.build(header, body);
                System.out.println(rsp.code);
                System.out.println(rsp.getStringCode());
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage(), ex);
                if (socket != null) {
                    try {
                        socket.getInputStream().close();
                        socket.getOutputStream().close();
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return 0;
            }
        }
        finally {
            if (socket != null) {
                try {
                    socket.getInputStream().close();
                    socket.getOutputStream().close();
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return phones.length;
    }

    public String getEid() {
        return this.eid;
    }

    public void setEid(String eid) {
        this.eid = eid;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String server) {
        this.gateway = server;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public static class MGW_CONNECT_REQ {
        public MGW_Header header;
        public byte[] user = new byte[32];
        public byte[] pwd_md5 = new byte[32];
        public int version = 9;

        public byte[] toBytes() {
            ByteBuffer bb = ByteBuffer.allocate(this.header.length);
            bb.put(this.header.toBytes());
            bb.put(this.user);
            bb.put(this.pwd_md5);
            bb.putInt(this.version);
            return bb.array();
        }

        public static MGW_CONNECT_REQ build(String eid, String uid, String pwd, int seq) {
            MGW_CONNECT_REQ req = new MGW_CONNECT_REQ();
            req.header = MGW_Header.build(81, 1, seq);
            String user = String.valueOf(eid) + uid;
            System.arraycopy(user.getBytes(), 0, req.user, 0, user.length());
            MD5 md5 = new MD5();
            String r = Bytes.toLowString(md5.digest(pwd.getBytes()));
            System.arraycopy(r.getBytes(), 0, req.pwd_md5, 0, r.length());
            return req;
        }
    }

    public static class MGW_CONNECT_RSP {
        public MGW_Header header;
        public byte code;
        public byte[] rsp;

        public static MGW_CONNECT_RSP build(MGW_Header header, byte[] body) {
            MGW_CONNECT_RSP conn_resp = new MGW_CONNECT_RSP();
            conn_resp.header = header;
            ByteBuffer bb = ByteBuffer.wrap(body);
            conn_resp.code = bb.get();
            conn_resp.rsp = new byte[header.length - 13 - 1];
            bb.get(conn_resp.rsp);
            return conn_resp;
        }
    }

    public static class MGW_GET_NAME_REQ {
        public MGW_Header header;
        public byte[] user = new byte[32];

        public byte[] toBytes() {
            ByteBuffer bb = ByteBuffer.allocate(this.header.length);
            bb.put(this.header.toBytes());
            bb.put(this.user);
            return bb.array();
        }

        public static MGW_GET_NAME_REQ build(String eid, String uid, int seq) {
            MGW_GET_NAME_REQ req = new MGW_GET_NAME_REQ();
            req.header = MGW_Header.build(45, 3, seq);
            String user = String.valueOf(eid) + uid;
            System.arraycopy(user.getBytes(), 0, req.user, 0, user.length());
            return req;
        }
    }

    public static class MGW_GET_NAME_RSP {
        public MGW_Header header;
        public byte code;
        public byte[] rsp;

        public static MGW_GET_NAME_RSP build(MGW_Header header, byte[] body) {
            MGW_GET_NAME_RSP rsp = new MGW_GET_NAME_RSP();
            rsp.header = header;
            ByteBuffer bb = ByteBuffer.wrap(body);
            rsp.code = bb.get();
            rsp.rsp = new byte[header.length - 13 - 1];
            bb.get(rsp.rsp);
            return rsp;
        }

        public String getName() {
            String n = null;
            try {
                n = new String(this.rsp, "GB2312");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return n;
        }
    }

    public static class MGW_Header {
        public static final int HEADER_LENGTH = 13;
        public static final int TYPE_CONNECT_REQ = 1;
        public static final int TYPE_CONNECT_RESP = 32769;
        public static final int TYPE_GET_NAME_REQ = 3;
        public static final int TYPE_GET_NAME_RESP = 32771;
        public static final int TYPE_SEND_REQ = 7;
        public static final int TYPE_SEND_RESP = 32775;
        public int length;
        public int type;
        public int seq;
        public byte unused;

        public byte[] toBytes() {
            ByteBuffer bb = ByteBuffer.allocate(13);
            bb.putInt(this.length);
            bb.putInt(this.type);
            bb.putInt(this.seq);
            bb.put(this.unused);
            return bb.array();
        }

        public static MGW_Header build(int length, int type, int seq) {
            MGW_Header header = new MGW_Header();
            header.length = length;
            header.type = type;
            header.seq = seq;
            header.unused = 0;
            return header;
        }

        public static MGW_Header build(byte[] buf) {
            MGW_Header header = new MGW_Header();
            ByteBuffer bb = ByteBuffer.wrap(buf);
            header.length = bb.getInt();
            header.type = bb.getInt();
            header.seq = bb.getInt();
            header.unused = bb.get();
            return header;
        }
    }

    public static class MGW_RSP {
        public MGW_Header header;
        public byte code;
        public byte[] rsp;

        public static MGW_RSP build(MGW_Header header, byte[] body) {
            MGW_RSP rsp = new MGW_RSP();
            rsp.header = header;
            ByteBuffer bb = ByteBuffer.wrap(body);
            rsp.code = bb.get();
            rsp.rsp = new byte[header.length - 13 - 1];
            bb.get(rsp.rsp);
            return rsp;
        }

        public String getStringCode() {
            String n = null;
            try {
                n = new String(this.rsp, "GB2312");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return n;
        }
    }

    public static class MGW_SEND_REQ {
        public MGW_Header header;
        public byte[] user = new byte[32];
        public byte[] unknown1 = new byte[68];
        public byte[] unknown2 = new byte[18];
        public String[] phones;
        public byte[] userName;
        public byte[] msg;

        public byte[] toBytes() {
            ByteBuffer bb = ByteBuffer.allocate(this.header.length);
            bb.put(this.header.toBytes());
            bb.put(this.user);
            bb.put(this.unknown1);
            this.unknown2[0] = 1;
            this.unknown2[1] = 1;
            this.unknown2[2] = 1;
            bb.put(this.unknown2);
            bb.putInt(this.phones.length);
            int i = 0;
            while (i < this.phones.length) {
                byte[] buf = new byte[15];
                System.arraycopy(this.phones[i].getBytes(), 0, buf, 0, this.phones[i].length());
                bb.put(buf);
                ++i;
            }
            bb.put((byte)40);
            bb.put(this.userName);
            bb.put((byte)41);
            bb.put(this.msg);
            return bb.array();
        }

        public static MGW_SEND_REQ build(String eid, String uid, String[] phones, String userName, String msg, int seq) {
            MGW_SEND_REQ req = new MGW_SEND_REQ();
            String user = String.valueOf(eid) + uid;
            System.arraycopy(user.getBytes(), 0, req.user, 0, user.length());
            req.phones = phones;
            try {
                req.userName = userName.getBytes("GB2312");
                req.msg = msg.getBytes("GB2312");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            int len = 135 + phones.length * 15 + 2 + req.userName.length + req.msg.length;
            req.header = MGW_Header.build(len, 7, seq);
            return req;
        }
    }
}

