/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.sms;

import cn.org.gddsn.sms.Base64Code;
import com.creawor.meip2.client.MeipException;
import com.creawor.meip2.client.MeipInfoProxyAxis;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;

public class MeipHttpConnection
implements MeipInfoProxyAxis {
    private String _host;
    private int _port;
    private String _appname;
    private boolean _needEncrypt;

    public MeipHttpConnection(String host, int port, String appname) {
        this._host = host;
        this._appname = appname;
        this._port = port;
        this._needEncrypt = true;
    }

    public static String encode(String s) {
        if (s != null) {
            try {
                byte[] abyte0 = s.getBytes("GB2312");
                abyte0 = Base64Code.encode(abyte0);
                s = new String(abyte0);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return s;
        }
        return null;
    }

    public String send(String sessionid, String content, String receivers, String reserve) throws RemoteException, MeipException {
        ByteArrayOutputStream byteOut = null;
        ObjectOutputStream out = null;
        byte[] buf = null;
        String rtn = null;
        try {
            try {
                byteOut = new ByteArrayOutputStream();
                out = new ObjectOutputStream(byteOut);
                out.writeInt(2001);
                out.writeObject(sessionid);
                if (this._needEncrypt) {
                    out.writeObject(MeipHttpConnection.encode(content));
                } else {
                    out.writeObject(content);
                }
                out.writeObject(receivers);
                out.writeObject(reserve);
                out.flush();
                buf = byteOut.toByteArray();
                out.close();
                out = null;
                byteOut.close();
                byteOut = null;
                rtn = (String)this.writeToServer(buf);
            }
            catch (Exception e) {
                throw new MeipException(e.getMessage());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            out = null;
            try {
                if (byteOut != null) {
                    byteOut.close();
                }
            }
            catch (Exception exception) {}
            byteOut = null;
        }
        return rtn;
    }

    public String[] receive(String sessionid, String prefix) throws RemoteException, MeipException {
        String[] msgs = null;
        ByteArrayOutputStream byteOut = null;
        ObjectOutputStream out = null;
        byte[] buf = null;
        try {
            try {
                byteOut = new ByteArrayOutputStream();
                out = new ObjectOutputStream(byteOut);
                out.writeInt(2002);
                out.writeObject(sessionid);
                out.writeObject(prefix);
                out.flush();
                buf = byteOut.toByteArray();
                out.close();
                out = null;
                byteOut.close();
                byteOut = null;
                msgs = (String[])this.writeToServer(buf);
            }
            catch (Exception e) {
                throw new MeipException(e.getMessage());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            out = null;
            try {
                if (byteOut != null) {
                    byteOut.close();
                }
            }
            catch (Exception exception) {}
            byteOut = null;
        }
        return msgs;
    }

    public String[] receiverSendFailed(String sessionID, String remark) throws RemoteException, MeipException {
        String[] msgs = null;
        ByteArrayOutputStream byteOut = null;
        ObjectOutputStream out = null;
        byte[] buf = null;
        try {
            try {
                byteOut = new ByteArrayOutputStream();
                out = new ObjectOutputStream(byteOut);
                out.writeInt(2013);
                out.writeObject(sessionID);
                out.writeObject(remark);
                out.flush();
                buf = byteOut.toByteArray();
                out.close();
                out = null;
                byteOut.close();
                byteOut = null;
                msgs = (String[])this.writeToServer(buf);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MeipException(e.getMessage());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            out = null;
            try {
                if (byteOut != null) {
                    byteOut.close();
                }
            }
            catch (Exception exception) {}
            byteOut = null;
        }
        return msgs;
    }

    public int forceLogout(String eid, String uid, String pwd) throws RemoteException, MeipException {
        ByteArrayOutputStream byteOut = null;
        ObjectOutputStream out = null;
        byte[] buf = null;
        int rtn = 0;
        try {
            try {
                byteOut = new ByteArrayOutputStream();
                out = new ObjectOutputStream(byteOut);
                out.writeInt(2008);
                if (this._needEncrypt) {
                    out.writeObject(MeipHttpConnection.encode(eid));
                    out.writeObject(MeipHttpConnection.encode(uid));
                    out.writeObject(MeipHttpConnection.encode(pwd));
                } else {
                    out.writeObject(eid);
                    out.writeObject(uid);
                    out.writeObject(pwd);
                }
                out.flush();
                buf = byteOut.toByteArray();
                out.close();
                out = null;
                byteOut.close();
                byteOut = null;
                String retString = (String)this.writeToServer(buf);
                rtn = Integer.parseInt(retString);
            }
            catch (Exception e) {
                throw new MeipException(e.getMessage());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            out = null;
            try {
                if (byteOut != null) {
                    byteOut.close();
                }
            }
            catch (Exception exception) {}
            byteOut = null;
        }
        return rtn;
    }

    public String login(String eid, String uid, String pwd) throws RemoteException, MeipException {
        String sessionid = null;
        ByteArrayOutputStream byteOut = null;
        ObjectOutputStream out = null;
        byte[] buf = null;
        try {
            try {
                byteOut = new ByteArrayOutputStream();
                out = new ObjectOutputStream(byteOut);
                out.writeInt(2000);
                if (this._needEncrypt) {
                    out.writeObject(MeipHttpConnection.encode(eid));
                    out.writeObject(MeipHttpConnection.encode(uid));
                    out.writeObject(MeipHttpConnection.encode(pwd));
                } else {
                    out.writeObject(eid);
                    out.writeObject(uid);
                    out.writeObject(pwd);
                }
                out.writeObject(null);
                out.flush();
                buf = byteOut.toByteArray();
                out.close();
                out = null;
                byteOut.close();
                byteOut = null;
                sessionid = (String)this.writeToServer(buf);
            }
            catch (Exception e) {
                throw new MeipException(e.getMessage());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            out = null;
            try {
                if (byteOut != null) {
                    byteOut.close();
                }
            }
            catch (Exception exception) {}
            byteOut = null;
        }
        return sessionid;
    }

    public int logout(String sessionid) throws RemoteException, MeipException {
        int rtn = 0;
        ByteArrayOutputStream byteOut = null;
        ObjectOutputStream out = null;
        byte[] buf = null;
        try {
            try {
                byteOut = new ByteArrayOutputStream();
                out = new ObjectOutputStream(byteOut);
                out.writeInt(2007);
                out.writeObject(sessionid);
                out.flush();
                buf = byteOut.toByteArray();
                out.close();
                out = null;
                byteOut.close();
                byteOut = null;
                String retString = (String)this.writeToServer(buf);
                rtn = Integer.parseInt(retString);
            }
            catch (Exception e) {
                throw new MeipException(e.getMessage());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            out = null;
            try {
                if (byteOut != null) {
                    byteOut.close();
                }
            }
            catch (Exception exception) {}
            byteOut = null;
        }
        return rtn;
    }

    private Object writeToServer(byte[] buffer) throws Exception {
        Object obj;
        if (buffer == null || buffer.length <= 0) {
            return null;
        }
        URLConnection conn = null;
        DataOutputStream objOut = null;
        ObjectInputStream in = null;
        try {
            try {
                conn = this.GetURLConnection(buffer.length);
                objOut = new DataOutputStream(conn.getOutputStream());
                objOut.write(buffer);
                objOut.flush();
                objOut.close();
                objOut = null;
                in = new ObjectInputStream(conn.getInputStream());
                Exception excp = (Exception)in.readObject();
                if (excp != null) {
                    excp.printStackTrace();
                    throw excp;
                }
                obj = in.readObject();
            }
            catch (ConnectException e) {
                if (e.getMessage().equalsIgnoreCase("Connection refused: connect")) {
                    throw new MeipException(Integer.toString(801));
                }
                throw e;
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            in = null;
            try {
                if (objOut != null) {
                    objOut.close();
                }
            }
            catch (Exception exception) {}
            objOut = null;
        }
        return obj;
    }

    private URL GetURL() throws MalformedURLException {
        if (this._host == null || this._host.trim().length() == 0) {
            throw new MalformedURLException("[MeipHttpConnection] Host Empty!");
        }
        String url = null;
        if (url == null || url.trim().length() == 0) {
            url = "http://" + this._host + ":" + this._port + "/" + this._appname + "/com.creawor.meip2.http.Meip2InfoProxyServlet";
        }
        return new URL(url);
    }

    private URLConnection GetURLConnection() throws IOException, MalformedURLException {
        URL url = this.GetURL();
        if (url == null) {
            throw new MalformedURLException("[MeipHttpConnection] Get URL ERROR\uff01");
        }
        URLConnection conn = url.openConnection();
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestProperty("Content-type", "application/octet-stream");
        return conn;
    }

    private URLConnection GetURLConnection(int content_length) throws IOException, MalformedURLException {
        URLConnection conn = this.GetURLConnection();
        conn.setRequestProperty("Content-length", "" + content_length);
        return conn;
    }
}

