/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.sms;

import cn.org.gddsn.sms.SendSMS;
import org.apache.log4j.Logger;
import org.smslib.COutgoingMessage;
import org.smslib.CService;

public class SendMessage
implements SendSMS {
    static Logger logger = Logger.getLogger(SendMessage.class);
    private String device = "/dev/cuaU0";
    private int baudRate = 9600;
    private String manufacturer = "Waveform";
    private String model = "";
    private String simPin = "0000";
    private String simPin2 = "0000";
    private String smscNumber = "";
    private String[] phoneNumber;

    public int send(String[] phones, String msg) {
        this.setPhoneNumber(phones);
        this.send(msg);
        return phones.length;
    }

    public void send(String message) {
        CService srv = new CService(this.device, this.baudRate, this.manufacturer, this.model);
        logger.info("Send  SMS.");
        logger.info("  Using SMSLib for Java v2.1.2");
        srv.setSimPin(this.simPin);
        srv.setSimPin2(this.simPin2);
        srv.setSmscNumber(this.smscNumber);
        try {
            srv.connect();
            logger.info("Mobile Device Information: ");
            logger.info("  Manufacturer  : " + srv.getDeviceInfo().getManufacturer());
            logger.info("  Model         : " + srv.getDeviceInfo().getModel());
            logger.info("  Serial No     : " + srv.getDeviceInfo().getSerialNo());
            logger.info("  IMSI          : " + srv.getDeviceInfo().getImsi());
            logger.info("  S/W Version   : " + srv.getDeviceInfo().getSwVersion());
            logger.info("  Battery Level : " + srv.getDeviceInfo().getBatteryLevel() + "%");
            logger.info("  Signal Level  : " + srv.getDeviceInfo().getSignalLevel() + "%");
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
        int i = 0;
        while (i < this.phoneNumber.length) {
            COutgoingMessage msg = new COutgoingMessage(this.phoneNumber[i], message);
            msg.setMessageEncoding(3);
            msg.setStatusReport(true);
            msg.setValidityPeriod(8);
            try {
                srv.sendMessage(msg);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), e);
            }
            ++i;
        }
        try {
            srv.disconnect();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        String[] phs = new String[]{"13600060073"};
        SendMessage sm = new SendMessage();
        sm.setPhoneNumber(phs);
        sm.send("\ufffd\u0439\ufffd\u0328\ufffd\ufffd\ufffd\ufffd\ufffd\u0137\ufffd!\ufffd\ufffd\u03e2\ufffd\u0439\ufffd\u0328\ufffd\ufffd\ufffd\ufffd\ufffd\u0137\ufffd!\ufffd\ufffd\u03e2\ufffd\u0439\ufffd\u0328\ufffd\ufffd\ufffd\ufffd\ufffd\u0137\ufffd!\ufffd\ufffd\u03e2\ufffd\u0439\ufffd\u0328\ufffd\ufffd\ufffd\ufffd\ufffd\u0137\ufffd!\ufffd\ufffd\u03e2\ufffd\u0439\ufffd\u0328\ufffd\ufffd\ufffd\ufffd\ufffd\u0137\ufffd!\ufffd\ufffd\u03e2\ufffd\u0439\ufffd\u0328\ufffd\ufffd\ufffd\ufffd\ufffd\u0137\ufffd!\ufffd\ufffd\u03e2\ufffd\u0439\ufffd\u0328\ufffd\ufffd\ufffd\ufffd\ufffd\u0137\ufffd!\ufffd\ufffd\u03e2\ufffd\u0439\ufffd\u0328\ufffd\ufffd\ufffd\ufffd\ufffd\u0137\ufffd!\ufffd\ufffd\u03e2\ufffd\u0439\ufffd\u0328\ufffd\ufffd\ufffd\ufffd\ufffd\u0137\ufffd!\ufffd\ufffd\u03e2\ufffd\u0439\ufffd\u0328\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        System.exit(0);
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String[] getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String[] phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getSimPin() {
        return this.simPin;
    }

    public void setSimPin(String simPin) {
        this.simPin = simPin;
    }

    public String getSimPin2() {
        return this.simPin2;
    }

    public void setSimPin2(String simPin2) {
        this.simPin2 = simPin2;
    }

    public String getSmscNumber() {
        return this.smscNumber;
    }

    public void setSmscNumber(String smscNumber) {
        this.smscNumber = smscNumber;
    }
}

