/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.test;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;

public class FixHeader {
    static Logger logger;
    static int loc_TSN;
    static int loc_TRL;
    static int loc_SI;
    static int offset_comp;
    static int offset_channel;
    static int offset_factor;
    static int offset_rsp;
    float[] factor = new float[]{600.0f, 600.0f, 600.0f, 1629.4f, 600.0f, 869.0f, 600.0f, 608.5f, 600.0f, 1042.0f, 1000.0f, 1042.0f, 733.0f, 733.2f, 752.2f, 389.0f};
    float[] freq = new float[]{0.05f, 0.1f, 0.125f, 0.25f, 0.33333334f, 0.5f, 0.6666667f, 1.0f, 1.5f, 2.0f, 3.0f, 4.0f, 8.0f, 10.0f, 20.0f};
    float[] amp = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.test.FixHeader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        loc_TSN = 120;
        loc_TRL = 272;
        loc_SI = 276;
        offset_comp = 44;
        offset_channel = 72;
        offset_factor = 16;
        offset_rsp = 4;
    }

    public void fixit(String fn) throws IOException {
        RandomAccessFile ra = new RandomAccessFile(fn, "rw");
        ra.skipBytes(loc_TSN);
        int TSN = this.readInt(ra);
        logger.info("TSN: " + TSN);
        ra.seek(0L);
        ra.skipBytes(loc_SI);
        int chan = 0;
        int i = 0;
        while (i < TSN) {
            ra.skipBytes(offset_comp);
            int comp = this.readInt(ra);
            logger.info("comp: " + comp);
            ra.skipBytes(offset_channel);
            int j = 0;
            while (j < comp) {
                ra.skipBytes(offset_factor);
                this.writeFloat(ra, this.factor[chan++]);
                ra.skipBytes(4);
                ra.skipBytes(4);
                this.writeInt(ra, this.freq.length);
                int k = 0;
                while (k < this.freq.length) {
                    this.writeFloat(ra, this.freq[k]);
                    this.writeFloat(ra, this.amp[k]);
                    ra.skipBytes(4);
                    ++k;
                }
                ra.skipBytes(12280 - this.freq.length * 3 * 4);
                ++j;
            }
            ++i;
        }
        ra.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt(RandomAccessFile ra) throws IOException {
        int byte4;
        int byte3;
        int byte2;
        int byte1;
        FixHeader fixHeader = this;
        synchronized (fixHeader) {
            byte1 = ra.read();
            byte2 = ra.read();
            byte3 = ra.read();
            byte4 = ra.read();
        }
        if (byte4 == -1 || byte3 == -1 || byte2 == -1 || byte1 == -1) {
            throw new EOFException();
        }
        return (byte4 << 24) + (byte3 << 16) + (byte2 << 8) + byte1;
    }

    public void writeInt(RandomAccessFile ra, int i) throws IOException {
        ra.write(i & 0xFF);
        ra.write(i >>> 8 & 0xFF);
        ra.write(i >>> 16 & 0xFF);
        ra.write(i >>> 24 & 0xFF);
    }

    public void writeFloat(RandomAccessFile ra, float f) throws IOException {
        this.writeInt(ra, Float.floatToIntBits(f));
    }

    public static void main(String[] args) throws IOException {
        FixHeader fixHeader = new FixHeader();
        if (args.length != 2) {
            System.out.println("Usage:\tjava -jar FixHeader.jar src_dir fn_patten");
            System.exit(-1);
        }
        File dir = new File(args[0]);
        String[] fns = dir.list();
        int n = 0;
        while (n < fns.length) {
            if (fns[n].startsWith(args[1])) {
                System.out.println("fix " + fns[n] + "... ");
                fixHeader.fixit(fns[n]);
            }
            ++n;
        }
    }
}

