/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.util;

import cn.org.gddsn.util.Log4jConfig;
import java.io.IOException;
import java.io.OutputStream;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;

public class ComPortAlarm
implements Runnable {
    static Logger logger;
    static byte cancelAlarm;
    static int BAUD;
    static byte[] sound_msg;
    private String comPort = "/dev/cuad0";
    private int soundType = 13;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.util.ComPortAlarm");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        cancelAlarm = (byte)8;
        BAUD = 4800;
        sound_msg = new byte[]{7, 7, 7, 7, 7, 49};
    }

    public void run() {
        try {
            this.doSoundAlarm(false);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public void stopSoundAlarm() {
        try {
            this.doSoundAlarm(true);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    void doSoundAlarm(boolean cancel) throws Exception {
        SerialPort sPort;
        CommPortIdentifier portId;
        try {
            portId = CommPortIdentifier.getPortIdentifier((String)this.comPort);
        }
        catch (NoSuchPortException e) {
            logger.warn(e.getMessage(), e);
            throw new Exception(e.getMessage());
        }
        try {
            sPort = (SerialPort)portId.open("ComPortAlarm", 3000);
        }
        catch (PortInUseException e) {
            logger.warn(e.getMessage(), e);
            throw new Exception(e.getMessage());
        }
        try {
            sPort.setSerialPortParams(BAUD, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            OutputStream os = sPort.getOutputStream();
            os.write(cancelAlarm);
            os.flush();
            if (!cancel) {
                os.write(sound_msg);
                os.flush();
            }
            os.close();
            sPort.close();
        }
        catch (IOException e) {
            sPort.close();
            logger.warn(e.getMessage(), e);
        }
    }

    public String getComPort() {
        return this.comPort;
    }

    public int getSoundType() {
        return this.soundType;
    }

    public void setComPort(String comPort) {
        this.comPort = comPort;
    }

    public void setSoundType(int soundType) {
        this.soundType = soundType;
        if (soundType > 0 && soundType < 16) {
            ComPortAlarm.sound_msg[5] = (byte)(soundType + 48);
        }
    }

    public static void main(String[] args) {
        Log4jConfig.loadForMain("ComPortAlarm.properties");
        FileSystemResource res = new FileSystemResource("ComPortAlarm.xml");
        XmlBeanFactory factory = new XmlBeanFactory(res);
        ComPortAlarm comPortAlarm = (ComPortAlarm)factory.getBean("comPortAlarm");
        new Thread(comPortAlarm).start();
    }
}

