/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropsUtil {
    static Logger logger;
    private Properties props;
    private File propsFile;
    private Properties defaultProps;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.util.PropsUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public PropsUtil() {
    }

    public PropsUtil(File file) {
        this.propsFile = file;
        this.props = new Properties();
        this.defaultProps = new Properties();
        try {
            FileInputStream fis = new FileInputStream(file);
            this.loadProps(fis);
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
            logger.warn("current Dir: " + System.getProperty("user.dir"));
            logger.warn("Error while loading properties \"" + file + "\"!");
        }
    }

    public PropsUtil(String file) {
        this(new File(file));
    }

    public void saveCurrentProperties(String file) {
        try {
            FileOutputStream out = new FileOutputStream(this.propsFile);
            this.props.store(out, file);
            if (out != null) {
                out.close();
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    public void loadProps(InputStream in) throws IOException {
        this.props.load(new BufferedInputStream(in));
        in.close();
    }

    public final String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public final String getProperty(String name, String def) {
        return this.props.getProperty(name, def);
    }

    public final String getProperty(String name, Object[] args) {
        if (name == null) {
            return null;
        }
        if (args == null) {
            return this.props.getProperty(name, name);
        }
        return MessageFormat.format(this.props.getProperty(name, name), args);
    }

    public final boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public final boolean getBooleanProperty(String name, boolean def) {
        String value = this.getProperty(name);
        if (value == null) {
            return def;
        }
        if (value.equals("true") || value.equals("yes") || value.equals("on")) {
            return true;
        }
        if (value.equals("false") || value.equals("no") || value.equals("off")) {
            return false;
        }
        return def;
    }

    public final void setProperty(String name, String value) {
        if (value == null || value.length() == 0) {
            String prop = (String)((Hashtable)this.defaultProps).get(name);
            if (prop == null || prop.length() == 0) {
                ((Hashtable)this.props).remove(name);
            } else {
                ((Hashtable)this.props).put(name, "");
            }
        } else if (!value.equals(this.getProperty(name))) {
            ((Hashtable)this.props).put(name, value);
        }
    }

    public final void setTemporaryProperty(String name, String value) {
        ((Hashtable)this.props).remove(name);
        ((Hashtable)this.defaultProps).put(name, value);
    }

    public final void setBooleanProperty(String name, boolean value) {
        this.setProperty(name, value ? "true" : "false");
    }

    public final void unsetProperty(String name) {
        if (((Hashtable)this.defaultProps).get(name) != null) {
            ((Hashtable)this.props).put(name, "");
        } else {
            ((Hashtable)this.props).remove(name);
        }
    }

    public final void resetProperty(String name) {
        ((Hashtable)this.props).remove(name);
    }
}

