/*
 * Decompiled with CFR 0.152.
 */
package com.creawor.meip2;

import com.creawor.meip.util.system.Daemon;
import com.creawor.meip2.beans.SessionBean;
import com.creawor.meip2.client.MeipClientException;
import com.creawor.meip2.client.MeipConnectionFactory;
import com.creawor.meip2.client.MeipException;
import com.creawor.meip2.client.MeipInfoProxyAxis;
import com.creawor.meip2.client.MeipUserHandle;
import com.creawor.meip2.db.DatabaseManager;
import com.creawor.meip2.main.Main;
import com.creawor.meip2.thread.AutoRerunMonitorThread;
import com.creawor.meip2.thread.DownloadMonitorThread;
import com.creawor.meip2.thread.FetchSendFailedMsgThread;
import com.creawor.meip2.thread.QueryInfoThread;
import com.creawor.meip2.thread.QuerySmsStatusThread;
import com.creawor.meip2.thread.ReceiveSmsThread;
import com.creawor.meip2.thread.SendMsgThread;
import com.creawor.meip2.thread.SmMoveThread;
import com.creawor.meip2.thread.SystemInMonitorThread;
import com.creawor.meip2.thread.TZCheckingThread;
import com.creawor.meip2.thread.URLCheckingThread;
import com.haibo.app.server.AppServerManager;
import com.haibo.app.server.IAppServer;
import com.haibo.exception.MeipExceptionEcode;
import com.haibo.log.TraceFactory;
import com.haibo.thread.ThreadBase;
import com.haibo.util.common.SessionDealUtil;
import java.rmi.RemoteException;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Server
implements Runnable,
Daemon {
    private static int sm_sent_count = 0;
    private static int sm_receive_count = 0;
    public static boolean bExitNow = false;
    private static String sessionId = "session";
    private static String eid;
    private static String connection_method;
    private static final String PN = "[SERVER]";
    public static boolean isSingleMode;
    private static ReceiveSmsThread rst;
    private static QuerySmsStatusThread qsst;
    private static QueryInfoThread qit;
    private static TZCheckingThread tzct;
    private static URLCheckingThread rulct;
    private static SmMoveThread smovet;
    private static SendMsgThread smt;
    private static SystemInMonitorThread simt;
    private static DownloadMonitorThread download;
    private static AutoRerunMonitorThread autorerun;
    private static FetchSendFailedMsgThread fsfmt;
    private static boolean isRerun;
    private static SessionBean sb;
    private static Map sessionMap;
    private static List beanList;
    private static String newLineTab;
    private static long lastLogin;
    private static boolean changeUser;
    public static int errorCode;

    static {
        connection_method = null;
        isSingleMode = true;
        rst = new ReceiveSmsThread();
        qsst = new QuerySmsStatusThread();
        qit = new QueryInfoThread();
        tzct = new TZCheckingThread();
        rulct = new URLCheckingThread();
        smovet = new SmMoveThread();
        smt = new SendMsgThread();
        simt = new SystemInMonitorThread();
        download = new DownloadMonitorThread();
        autorerun = new AutoRerunMonitorThread();
        fsfmt = new FetchSendFailedMsgThread();
        isRerun = false;
        sb = null;
        sessionMap = new HashMap();
        beanList = null;
        newLineTab = "/";
        lastLogin = 0L;
        changeUser = false;
        errorCode = 0;
    }

    public void run() {
        this.init();
        try {
            Thread.sleep(Main.getCfg().readInt("MAIN_THREAD_CYC", 5) * 60000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void init() {
        newLineTab = Main.getCfg().readString("newline_tag", "/");
        String mode = Main.getCfg().readString("IsSingleUser", "yes");
        isSingleMode = mode.equalsIgnoreCase("yes");
        if (Server.login() == null) {
            Server.logout();
            System.exit(-1);
        }
        Server.setEid(Main.getCfg().readString("client.1.EnterpriseID"));
        boolean initDataBase = false;
        while (true) {
            try {
                DriverManager.setLoginTimeout(300);
                DatabaseManager.init();
                initDataBase = true;
            }
            catch (Exception e) {
                TraceFactory.getTrace().trace("[SERVER]\u52a0\u8f7d\u6570\u636e\u5e93\u9a71\u52a8\u7a0b\u5e8f\uff1a" + e.toString(), 8);
                TraceFactory.getTrace().trace(e, 1);
                continue;
            }
            break;
        }
        if (!initDataBase) {
            TraceFactory.getTrace().trace("[SERVER]\u52a0\u8f7d\u6570\u636e\u5e93\u9a71\u52a8\u5931\u8d25\uff01\uff01\uff01", 1);
            System.exit(-3);
        }
        this.startThread(true);
    }

    public void startThread(boolean b) {
        try {
            if (b) {
                IAppServer iapp = AppServerManager.getHandle();
                iapp.setAppClassName(Main.getCfg().readString("DEFAULT_CUSTOM_SERVER_HANDLER"));
                iapp.startup();
                TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u77ed\u4fe1\u53d1\u9001\u7ebf\u7a0b ...", 2);
                smt.start();
                if (isSingleMode && Main.getCfg().readBoolean("RECEIVE_SMS_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u77ed\u4fe1\u63a5\u6536\u7ebf\u7a0b ...", 2);
                    rst.start();
                }
                if (Main.getCfg().readBoolean("QUERY_SMSTATUS_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u77ed\u4fe1\u53d1\u9001\u72b6\u6001\u67e5\u8be2\u7ebf\u7a0b ...", 2);
                    qsst.start();
                }
                if (Main.getCfg().readBoolean("QUERY_SMS_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u4fe1\u606f\u67e5\u8be2\u7ebf\u7a0b ...", 2);
                    qit.start();
                }
                if (Main.getCfg().readBoolean("GB_CHECKING_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u901a\u77e5\u68c0\u67e5\u7ebf\u7a0b ...", 2);
                    tzct.start();
                }
                if (Main.getCfg().readBoolean("DOWNLOAD_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u81ea\u52a8\u4e0b\u8f7d\u7ebf\u7a0b ...", 2);
                    download.start();
                    autorerun.start();
                }
                if (Main.getCfg().readBoolean("URL_CHECKING_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u9875\u9762\u76d1\u89c6\u7ebf\u7a0b ...");
                    rulct.start();
                }
                if (Main.getCfg().readBoolean("MOVE_SMSENT_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u6570\u636e\u8fc1\u79fb\u7ebf\u7a0b ...");
                    smovet.start();
                }
                if (Main.getCfg().readBoolean("RECEIVE_SENDFAILDSMS_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u83b7\u53d6\u53d1\u9001\u5931\u8d25\u77ed\u4fe1\u7ebf\u7a0b ...");
                    fsfmt.start();
                }
                TraceFactory.getTrace().trace("-> \u4e3b\u670d\u52a1\u542f\u52a8\u6210\u529f\uff01", 2);
                iapp.started();
            } else {
                smt.resume();
                if (Main.getCfg().readBoolean("RECEIVE_SMS_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u77ed\u4fe1\u63a5\u6536\u7ebf\u7a0b ...", 2);
                    if (rst.isAlive()) {
                        rst.resume();
                    } else {
                        rst.start();
                    }
                }
                if (Main.getCfg().readBoolean("QUERY_SMSTATUS_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u77ed\u4fe1\u53d1\u9001\u72b6\u6001\u67e5\u8be2\u7ebf\u7a0b ...", 2);
                    if (qsst.isAlive()) {
                        qsst.resume();
                    }
                }
                if (Main.getCfg().readBoolean("QUERY_SMS_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u4fe1\u606f\u67e5\u8be2\u7ebf\u7a0b ...", 2);
                    if (qit.isAlive()) {
                        qit.resume();
                    } else {
                        qit.start();
                    }
                }
                if (Main.getCfg().readBoolean("GB_CHECKING_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u901a\u77e5\u68c0\u67e5\u7ebf\u7a0b ...", 2);
                    if (tzct.isAlive()) {
                        tzct.resume();
                    } else {
                        tzct.start();
                    }
                }
                if (Main.getCfg().readBoolean("DOWNLOAD_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u81ea\u52a8\u4e0b\u8f7d\u7ebf\u7a0b ...", 2);
                    if (download.isAlive()) {
                        download.resume();
                        autorerun.resume();
                    } else {
                        download.start();
                        autorerun.start();
                    }
                }
                if (Main.getCfg().readBoolean("URL_CHECKING_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u9875\u9762\u76d1\u89c6\u7ebf\u7a0b ...");
                    if (rulct.isAlive()) {
                        rulct.resume();
                    } else {
                        rulct.start();
                    }
                }
                if (Main.getCfg().readBoolean("MOVE_SMSENT_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u6570\u636e\u8fc1\u79fb\u7ebf\u7a0b ...");
                    if (smovet.isAlive()) {
                        smovet.resume();
                    } else {
                        smovet.start();
                    }
                }
                if (Main.getCfg().readBoolean("RECEIVE_SENDFAILDSMS_ENABLE")) {
                    TraceFactory.getTrace().trace("-> \u6b63\u5728\u542f\u52a8\u83b7\u53d6\u53d1\u9001\u5931\u8d25\u77ed\u4fe1\u7ebf\u7a0b ...");
                    if (fsfmt.isAlive()) {
                        fsfmt.resume();
                    } else {
                        fsfmt.start();
                    }
                }
            }
        }
        catch (NoClassDefFoundError e) {
            TraceFactory.getTrace().trace("[SERVER] startThread error" + e, 8);
            System.exit(-1);
        }
        catch (Exception e) {
            TraceFactory.getTrace().trace("[SERVER] startThread error" + e, 8);
            System.exit(-1);
        }
    }

    public void stopThread(boolean b) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InterruptedException {
        if (b) {
            AppServerManager.getHandle().stop();
            Thread[] ts = new Thread[20];
            int tc = Thread.enumerate(ts);
            int i = 0;
            while (i < tc) {
                if (ts[i] instanceof ThreadBase) {
                    ((ThreadBase)ts[i]).stop(1);
                }
                ++i;
            }
            int sc = 0;
            int i2 = 0;
            int activeThread = 0;
            while (sc < 30) {
                ++sc;
                activeThread = 0;
                Thread.sleep(200L);
                i2 = 0;
                while (i2 < tc) {
                    if (ts[i2] instanceof ThreadBase && ts[i2].isAlive()) {
                        ++activeThread;
                    }
                    ++i2;
                }
                if (activeThread <= 1) break;
            }
            ts = null;
        } else {
            rst.suspend();
            qsst.suspend();
            qit.suspend();
            tzct.suspend();
            download.suspend();
            autorerun.suspend();
            rulct.suspend();
            smovet.suspend();
            smt.suspend();
            fsfmt.suspend();
        }
    }

    public static void logout() {
        MeipInfoProxyAxis meipConn = null;
        try {
            meipConn = MeipConnectionFactory.getConnection(Main.getCfg().readString("COMMUNICATION_METHOD"));
        }
        catch (MeipClientException e) {
            TraceFactory.getTrace().trace("[SERVER]<E> " + e, 8);
        }
        if (meipConn != null) {
            String sessionId = null;
            List sessionIdList = Server.getAllSessionId();
            if (sessionIdList != null && !sessionIdList.isEmpty()) {
                int i = 0;
                while (i < sessionIdList.size()) {
                    sessionId = (String)sessionIdList.get(i);
                    if (sessionId != null) {
                        System.out.println("sessionId=" + sessionId);
                        sb = (SessionBean)sessionMap.get(sessionId);
                        try {
                            meipConn.logout(sessionId);
                            sessionMap.remove(sessionId);
                            TraceFactory.getTrace().trace("[SERVER]<E> \u6b63\u5e38\u9000\u51fa......\u6210\u529f", 2);
                        }
                        catch (MeipException e) {
                            TraceFactory.getTrace().trace("\u5ba2\u6237\u7aef\u6ce8\u9500\u5931\u8d25\uff0c\u8fdb\u884c\u5f3a\u884c\u9000\u51fa......", 2);
                            try {
                                if (sb != null) {
                                    meipConn.forceLogout(sb.getEid(), sb.getUid(), sb.getPassword());
                                }
                            }
                            catch (MeipException _e) {
                                TraceFactory.getTrace().trace("[SERVER]<E> \u5f3a\u884c\u9000\u51fa......\u5931\u8d25:" + _e, 8);
                            }
                            catch (RemoteException _e) {
                                TraceFactory.getTrace().trace("[SERVER]<E>  RemoteException :" + _e, 8);
                            }
                            sessionMap.remove(sessionId);
                            TraceFactory.getTrace().trace("[SERVER]<E> \u5f3a\u884c\u9000\u51fa......\u6210\u529f", 2);
                        }
                        catch (RemoteException e) {
                            TraceFactory.getTrace().trace("[SERVER]<E>  RemoteException :" + e, 8);
                        }
                        try {
                            if (sb != null && !sb.isRemenberPass()) {
                                SessionDealUtil.delete();
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                sessionIdList.clear();
                Object var2_3 = null;
            }
        }
    }

    public static String login() {
        String sId = null;
        String string = sessionId;
        synchronized (string) {
            if (changeUser || System.currentTimeMillis() - lastLogin > 60000L) {
                Server.logout();
                sId = Server.loginToServer();
                if (sId != null && sId.trim().length() > 0) {
                    lastLogin = System.currentTimeMillis();
                    changeUser = false;
                }
            } else {
                sId = sessionId;
            }
        }
        return sId;
    }

    public static void setSessionBean(String eid, String userId, String password) {
        if (sb == null) {
            sb = new SessionBean();
        }
        sb.setUid(userId);
        sb.setEid(eid);
        sb.setPassword(password);
        sb.setRemenberPass(false);
    }

    public static void setChangeUser() {
        changeUser = true;
    }

    private static void readConfig() {
        if (beanList == null) {
            beanList = new ArrayList();
        } else {
            beanList.clear();
        }
        boolean rememberPass = false;
        String eid = null;
        String uid = null;
        String pass = null;
        String from = null;
        String lerver = null;
        String to = null;
        String en = "";
        String un = "";
        String pn = "";
        String fn = "";
        String tn = "";
        String ln = "";
        int i = 0;
        while (i < 101) {
            en = "client." + i + ".EnterpriseID";
            un = "client." + i + ".UserID";
            pn = "client." + i + ".Password";
            fn = "client." + i + ".FILE_FROM_DIRECTORY";
            tn = "client." + i + ".FILE_TO_BACKUP_DIRECTORY";
            ln = "client." + i + ".BACKUP_DIRECTORY_LEVEL";
            eid = Main.getCfg().readString(en);
            uid = Main.getCfg().readString(un);
            pass = Main.getCfg().readString(pn);
            from = Main.getCfg().readString(fn);
            to = Main.getCfg().readString(tn);
            lerver = Main.getCfg().readString(ln);
            if (!(eid == null || "".equals(eid.trim()) || uid == null || "".equals(uid.trim()) || pass == null || "".equals(pass.trim()))) {
                sb = new SessionBean();
                sb.setUid(uid);
                sb.setEid(eid);
                sb.setPassword(pass);
                if (to == null || to.trim().equals("")) {
                    to = String.valueOf(eid) + "_" + uid;
                }
                if (from == null || from.trim().equals("")) {
                    from = String.valueOf(eid) + "_" + uid;
                }
                sb.setFileFrom(from);
                sb.setFileTo(to);
                sb.setRemenberPass(rememberPass);
                if (lerver == null) {
                    lerver = "month";
                }
                sb.setFileLever(lerver);
                beanList.add(sb);
            }
            ++i;
        }
    }

    private static String loginToServer() {
        Object fis = null;
        Object prop = null;
        Object ip = null;
        Object eid = null;
        Object uid = null;
        Object password = null;
        boolean rememberPass = false;
        Object excp = null;
        if (beanList == null) {
            Server.readConfig();
        }
        if (connection_method == null) {
            connection_method = Main.getCfg().readString("COMMUNICATION_METHOD");
        }
        String rtnId = null;
        int uNum = 0;
        if (beanList != null && !beanList.isEmpty()) {
            int i = 0;
            while (i < beanList.size()) {
                sb = (SessionBean)beanList.get(i);
                if (sb != null) {
                    rtnId = Server.getLoginId(sb);
                    if (rtnId == null) {
                        beanList.remove(sb);
                        --i;
                    } else {
                        ++uNum;
                        sessionMap.put(rtnId, sb);
                    }
                }
                ++i;
            }
        }
        if (uNum == 0) {
            return null;
        }
        return String.valueOf(uNum);
    }

    public static String getLoginId(SessionBean sb) {
        if (sb == null) {
            return null;
        }
        int loginCount = 0;
        while (loginCount < 3) {
            block11: {
                ++loginCount;
                Object line = null;
                String method = "RMI";
                if (sb != null) {
                    try {
                        sessionId = MeipUserHandle.getSessionId(sb.getEid(), sb.getUid(), sb.getPassword(), connection_method);
                    }
                    catch (MeipException _e) {
                        sessionId = "";
                        if (errorCode == 502) {
                            TraceFactory.getTrace().trace("\u767b\u5f55\u5931\u8d25\uff01EID:" + sb.getEid() + "UserID:" + sb.getUid(), 4);
                            break;
                        }
                        errorCode = MeipExceptionEcode.getErrorCode((String)_e.getMessage());
                        if (errorCode != 801) break block11;
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                }
            }
            if (sb != null && sessionId != null && sessionId.trim().length() > 0) {
                TraceFactory.getTrace().trace("\u767b\u5f55\u6210\u529f\uff01UserID:" + sb.getUid(), 2);
                return sessionId;
            }
            TraceFactory.getTrace().trace("\u7528\u6237\uff1a" + sb.getUid() + " \u767b\u5f55\u5931\u8d25\uff0c\u7b49\u5f85\u91cd\u8bd5\u4e2d...", 2);
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TraceFactory.getTrace().trace("\u7528\u6237\uff1a" + sb.getUid() + " \u767b\u5f553\u6b21\u5931\u8d25\uff01", 2);
        return null;
    }

    public static List getAllSessionId() {
        ArrayList list = new ArrayList();
        if (sessionMap != null && !sessionMap.isEmpty()) {
            Iterator it = sessionMap.keySet().iterator();
            while (it.hasNext()) {
                list.add(it.next());
            }
        }
        return list;
    }

    public static List[] getSendMsgDir() {
        List[] list = new List[]{new ArrayList(), new ArrayList(), new ArrayList()};
        String key = "";
        SessionBean sb = null;
        if (sessionMap != null && !sessionMap.isEmpty()) {
            Iterator it = sessionMap.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                sb = (SessionBean)sessionMap.get(key);
                if (sb == null) continue;
                list[0].add(sb.getFileFrom());
                list[1].add(sb.getFileTo());
                list[2].add(sb.getFileLever());
            }
        }
        return list;
    }

    public static int GetSmReceCount() {
        return sm_receive_count;
    }

    public static int GetSmSentCount() {
        return sm_sent_count;
    }

    public static int IncSmReceCount() {
        return ++sm_receive_count;
    }

    public static synchronized int IncSmSentCount() {
        return ++sm_sent_count;
    }

    public static void main(String[] args) {
    }

    public static void ResetSmReceCount(int count) {
        sm_receive_count = count;
    }

    public static synchronized void ResetSmSentCount(int count) {
        sm_sent_count = count;
    }

    public static String getEid() {
        return eid;
    }

    public static String getSessionId() {
        if (sessionId != null) {
            String string = sessionId;
            synchronized (string) {
                return sessionId;
            }
        }
        return null;
    }

    public static void setEid(String Eid) {
        eid = Eid;
    }

    public static void setSessionId(String seid) {
        String string = sessionId;
        synchronized (string) {
            sessionId = seid;
        }
    }

    public void onTerminal() {
        try {
            this.stopThread(true);
            Server.logout();
            DatabaseManager.onTerminal();
            if (sessionMap != null) {
                sessionMap.clear();
            }
            if (beanList != null) {
                beanList.clear();
                beanList = null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (isRerun) {
            try {
                Runtime rt = Runtime.getRuntime();
                rt.exec("cmd /c start runs.bat ");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setRerun(boolean isRerun) {
        Server.isRerun = isRerun;
    }

    public static SessionBean getSessionBean() {
        return sb;
    }

    public static List getAllSessionBean() {
        return beanList;
    }

    public static String getSessionIdByUid(String eid, String uid, String password) {
        if (eid == null || uid == null) {
            return null;
        }
        String key = "";
        SessionBean sb = null;
        if (sessionMap != null && !sessionMap.isEmpty()) {
            Iterator it = sessionMap.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                sb = (SessionBean)sessionMap.get(key);
                if (sb == null || !sb.getEid().equals(eid) || !sb.getUid().equals(uid) || !sb.getPassword().equals(password)) continue;
                return key;
            }
        }
        return null;
    }

    public static String getAllUidString() {
        String sUid = "";
        SessionBean sb = null;
        if (beanList != null && !beanList.isEmpty()) {
            int i = 0;
            while (i < beanList.size()) {
                sb = (SessionBean)beanList.get(i);
                if (sb != null) {
                    sUid = String.valueOf(sUid) + "'" + sb.getUid() + "',";
                }
                ++i;
            }
        }
        if (sUid.trim().length() > 0) {
            sUid = sUid.substring(0, sUid.length() - 1);
        }
        return sUid;
    }

    public static String getNewLineTab() {
        return newLineTab;
    }

    public static String replaceAllString(String content, String from, String to) {
        if (content == null) {
            return null;
        }
        String s = null;
        s = content.replaceAll(from, to);
        return s;
    }
}

