/*
 * Decompiled with CFR 0.152.
 */
package com.creawor.meip2.db;

import com.creawor.meip.util.db.pool.ConnectionFactory;
import com.creawor.meip.util.db.pool.ConnectionParam;
import com.creawor.meip.util.log.TraceFactory;
import com.creawor.meip2.db.ConnMaintainThread;
import com.creawor.meip2.main.Main;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.sql.DataSource;

public class DatabaseManager {
    public static String dbCheckSql = "select typeid from etype where typeid=5";
    public static String dbType = "";
    private static final String POOL_NAME = "Meip2C_DB";
    private static ConnectionParam _param = new ConnectionParam();
    private static boolean ready = false;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static final void init() throws Exception {
        dbCheckSql = Main.getCfg().readString("check_sql", "select * from dfsdl");
        dbType = Main.getCfg().readString("DBType", "Access");
        _param = DatabaseManager.getConnectionParam();
        try {
            System.out.println("[DBM] database ds binding ...");
            ConnectionFactory.bind((String)POOL_NAME, (ConnectionParam)_param);
        }
        catch (SQLException esql) {
            System.out.println("SQL E: " + esql);
            System.out.println("SQL Code: " + esql.getErrorCode());
            throw esql;
        }
        ready = true;
        try {
            new ConnMaintainThread().start();
        }
        catch (Exception e) {
            TraceFactory.getTrace().trace("[DataManager] Create Conn Auto Manage Exception.", 8);
            TraceFactory.getTrace().trace(e, 8);
        }
    }

    public static void pureInit() throws Exception {
        if (!ready) {
            _param = DatabaseManager.getConnectionParam();
            ConnectionFactory.bind((String)POOL_NAME, (ConnectionParam)_param);
            ready = true;
        }
    }

    public static void refreshConfig() {
        _param = DatabaseManager.getConnectionParam();
    }

    private static ConnectionParam getConnectionParam() {
        ConnectionParam param = new ConnectionParam();
        param.setDriver(Main.getCfg().readString("JDBC_DRIVER", ""));
        param.setUrl(Main.getCfg().readString("JDBC_URL", ""));
        param.setUser(Main.getCfg().readString("JDBC_USERNAME", ""));
        param.setPassword(Main.getCfg().readString("JDBC_PASSWORD", ""));
        param.setWaitTime((long)Main.getCfg().readInt("JDBC_WAIT_TIME", 80000));
        param.setTimeoutValue((long)Main.getCfg().readInt("JDBC_TIME_OUT", 60000));
        param.setMinConnection(Main.getCfg().readInt("JDBC_MIN_CONNECTION", 1));
        param.setMaxConnection(Main.getCfg().readInt("JDBC_MAX_CONNECTION", 5));
        param.setLockWaitTime(Main.getCfg().readInt("JDBC_LOCK_WAIT", 30));
        param.setCoding(Main.getCfg().readString("LOCALDB_CHARACTER_ENCODE", "false").trim().equalsIgnoreCase("true"));
        param.setDbType(Main.getCfg().readString("DBType", "Access"));
        return param;
    }

    public static final synchronized Connection getConnection() throws Exception {
        DatabaseManager.pureInit();
        if (!ready) {
            throw new SQLException("Connection Pool unavailabled.");
        }
        DataSource ds = ConnectionFactory.lookup((String)POOL_NAME);
        return ds.getConnection();
    }

    public static final void uninit() throws Exception {
        ConnectionFactory.unbind((String)POOL_NAME);
        ready = false;
    }

    public static void onTerminal() {
        try {
            System.out.println("[DM] ---------------------------");
            System.out.println("[DM] Stopping connections ... ");
            DatabaseManager.uninit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isReady() {
        return ready;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void createExecuteTables(Connection conn) throws SQLException, IOException {
        block18: {
            scriptName = "execut.sql";
            raf = null;
            ps = null;
            try {
                try {
                    filename = "c:/meip2/scripts/" + scriptName;
                    raf = new RandomAccessFile(filename, "r");
                    while ((line = raf.readLine()) != null) {
                        if ((line = line.trim()).length() != 0 && !line.startsWith("#") && !line.startsWith("-")) {
                            line = line.trim();
                            TraceFactory.getTrace().trace("\n[excute]execute SQL: " + line, 2);
                            ps = conn.prepareStatement(line);
                            try {
                                ps.executeUpdate();
                            }
                            catch (Exception exp) {
                                System.out.println("ee:" + exp);
                            }
                        }
                        if (line != null) continue;
                    }
                }
                catch (FileNotFoundException line) {
                }
                catch (Exception e) {
                    System.out.println("e:" + e);
                }
            }
            catch (Throwable var8_9) {
                var7_10 = null;
                if (ps != null) {
                    try {
                        ps.close();
                        ps = null;
                    }
                    catch (Exception var9_12) {
                        // empty catch block
                    }
                }
                if (raf == null) throw var8_9;
                try {
                    raf.close();
                    throw var8_9;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw var8_9;
            }
            {
                var7_11 = null;
                if (ps == null) break block18;
            }
            ** try [egrp 3[TRYBLOCK] [5 : 229->240)] { 
lbl48:
            // 1 sources

            ps.close();
            ps = null;
            break block18;
lbl51:
            // 1 sources

            catch (Exception var9_13) {
                // empty catch block
            }
        }
        if (raf == null) return;
        try {}
        catch (Exception e) {
            return;
        }
        raf.close();
    }

    public void createNewDbsources(String pname) throws Exception {
        try {
            System.out.println("[DBM] database ds new binding <" + pname + "> ...");
            ConnectionFactory.bind((String)pname, (ConnectionParam)_param);
        }
        catch (SQLException esql) {
            System.out.println("SQL E: " + esql);
            System.out.println("SQL Code: " + esql.getErrorCode());
            throw esql;
        }
    }

    public static String getTimestampSqlString(Date time) {
        if (time == null) {
            return " NULL ";
        }
        StringBuffer sb = new StringBuffer();
        if (dbType.equalsIgnoreCase("oracle")) {
            sb.append(" to_date('");
            sb.append(sdf.format(new Date(time.getTime())));
            sb.append("', 'yyyy-MM-dd HH24:mi:ss')");
        } else {
            sb.append("'");
            sb.append(sdf.format(new Date(time.getTime())));
            sb.append("'");
        }
        return sb.toString();
    }
}

