/*
 * Decompiled with CFR 0.152.
 */
package com.creawor.meip2.main;

import com.creawor.meip.util.system.Daemon;
import com.creawor.meip.util.system.RuntimeManager;
import com.creawor.meip2.Server;
import com.creawor.meip2.main.JarFileFilter;
import com.creawor.meip2.main.Main;
import com.haibo.config.ConfigHandler;
import com.haibo.config.ConfigManager;
import com.haibo.config.ConfigObserver;
import com.haibo.log.TraceFactory;
import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.rmi.RMISecurityManager;
import java.util.Properties;

public class Main
implements ConfigObserver {
    private static final String PN = "[MAIN]";
    private static ConfigHandler cfghandler;
    private static String CONFIG_NAME;
    private static Main main;
    private static boolean isRun;
    private static String version;
    private Server s = new Server();

    static {
        isRun = false;
        version = "\u73e0\u6d77";
    }

    public static void readConfig() {
        CONFIG_NAME = System.getProperty("service.conf") == null ? "./conf/service.conf" : System.getProperty("service.conf");
        try {
            cfghandler = new ConfigHandler();
            cfghandler.load(CONFIG_NAME, true);
        }
        catch (Exception e) {
            System.out.println("[MAIN] Load service.conf failed!");
            e.printStackTrace();
        }
    }

    private Main() {
    }

    public static ConfigHandler getCfg() {
        return cfghandler;
    }

    public String getConfigName() {
        return CONFIG_NAME;
    }

    public static Main getInstance() {
        if (main == null) {
            main = new Main();
        }
        return main;
    }

    public void onChanged(String configName, long lTimestamp, Properties props) {
        if (this.getConfigName().equals(configName)) {
            try {
                cfghandler.load(configName, false);
                if (isRun) {
                    this.s.stopThread(false);
                    this.s.startThread(false);
                }
            }
            catch (Exception e) {
                TraceFactory.getTrace().trace("[MAIN]relaod conf exception: " + e.getMessage(), 8);
                TraceFactory.getTrace().trace(e, 8);
            }
        }
        isRun = true;
    }

    public void onException(Exception excp) {
        TraceFactory.getTrace().trace(excp, 8);
    }

    public static void main(String[] args) {
        Main.readConfig();
        main = Main.getInstance();
        System.setSecurityManager(new RMISecurityManager());
        TraceFactory.setCommCfg((ConfigHandler)cfghandler);
        ConfigManager.register((String)main.getConfigName(), (ConfigObserver)main);
        Main.showVersion();
        Main.initProxies();
        try {
            new Thread(Main.main.s).start();
            RuntimeManager.addDaemon((Daemon)Main.main.s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initClasspath() {
        String _dir = "lib";
        String key = "java.class.path";
        File fdir = null;
        String[] jars = null;
        String classpath = System.getProperty(key);
        if (classpath == null) {
            classpath = ".";
        }
        try {
            try {
                fdir = new File(_dir);
                if (fdir.exists()) {
                    jars = fdir.list(new JarFileFilter());
                    int i = 0;
                    while (i < jars.length) {
                        jars[i] = "." + File.separator + _dir + File.separator + jars[i];
                        classpath = String.valueOf(classpath) + File.pathSeparator + jars[i];
                        ++i;
                    }
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            fdir = null;
            jars = null;
            throw throwable;
        }
        {
            Object var6_9 = null;
            fdir = null;
        }
        jars = null;
    }

    protected static void initProxies() {
        try {
            if (Main.getUseProxy()) {
                System.getProperties().setProperty("http.proxySet", "true");
                System.getProperties().setProperty("http.proxyHost", Main.getCfg().readString("proxyAddress"));
                System.getProperties().setProperty("http.proxyPort", Main.getCfg().readString("proxyPort"));
                System.getProperties().setProperty("proxyHost", Main.getCfg().readString("proxyAddress"));
                System.getProperties().setProperty("proxyPort", Main.getCfg().readString("proxyPort"));
                if (Main.getNeedAuth()) {
                    String user = Main.getCfg().readString("authUser");
                    String pwd = Main.getCfg().readString("authPwd");
                    System.getProperties().setProperty("http.proxyUser", user);
                    System.getProperties().setProperty("http.proxyPassword", pwd);
                    class SimpleAuthenticator
                    extends Authenticator {
                        private String user;
                        private String pwd;

                        public SimpleAuthenticator(String user, String pwd) {
                            this.user = user;
                            this.pwd = pwd;
                        }

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(this.user, this.pwd.toCharArray());
                        }
                    }
                    Authenticator.setDefault(new SimpleAuthenticator(user, pwd));
                }
            }
        }
        catch (Exception _ex) {
            System.out.println("\u521d\u59cb\u5316HTTP\u4ee3\u7406\u5931\u8d25!");
            _ex.printStackTrace(System.out);
        }
    }

    private static void showVersion() {
        System.out.println("*******************************************************************************");
        System.out.println("*        \u4f01\u4e1a\u77ed\u4fe1\u606f\u63a5\u5165\u670d\u52a1(\u7248\u6743\u6240\u6709\uff1a\u73e0\u6d77\u521b\u6211\u79d1\u6280\u53d1\u5c55\u6709\u9650\u516c\u53f8)               *");
        System.out.println("*******************************************************build:0602.001**********");
        System.out.println("\u8bf4\u660e\uff1a\u9519\u8bef\u5f02\u5e38\u5b9a\u4e49\u8bf7\u67e5\u9605\u5b89\u88c5\u76ee\u5f55\u4e0b\u7684\u5f02\u5e38\u4ee3\u7801\u6587\u4ef6\uff1ahelp/\u5f02\u5e38\u5b9a\u4e49.txt");
    }

    public Server getS() {
        return this.s;
    }

    public void setS(Server s) {
        this.s = s;
    }

    public static boolean getUseProxy() {
        boolean useProxy;
        try {
            useProxy = new Boolean(Main.getCfg().readString("useProxy"));
        }
        catch (Exception _ex) {
            useProxy = false;
        }
        return useProxy;
    }

    public static boolean getNeedAuth() {
        boolean needAuth;
        try {
            needAuth = new Boolean(Main.getCfg().readString("authProxy"));
        }
        catch (Exception _ex) {
            needAuth = false;
        }
        return needAuth;
    }
}

