/*
 * Decompiled with CFR 0.152.
 */
package com.creawor.meip2.sms;

import com.creawor.meip2.beans.SmReceived;
import com.creawor.meip2.main.Main;
import com.creawor.meip2.sms.DefaultSmsHandle;
import com.creawor.meip2.sms.HandleException;
import com.creawor.meip2.sms.ISmsHandle;
import com.haibo.log.TraceFactory;
import com.haibo.util.common.MyCalendar;
import java.util.StringTokenizer;
import java.util.Vector;

public class MultiSmsHandler
implements ISmsHandle {
    Vector isms = new Vector();

    public MultiSmsHandler() {
        if (Main.getCfg().readString("QUERY_SMS_HANDLER") == null) {
            return;
        }
        String classname = null;
        StringTokenizer st = new StringTokenizer(Main.getCfg().readString("QUERY_SMS_HANDLER"));
        while (st.hasMoreTokens()) {
            classname = (String)st.nextElement();
            try {
                Object handler = Class.forName(classname).newInstance();
                if (handler instanceof ISmsHandle) {
                    this.isms.add(handler);
                    continue;
                }
                this.print(String.valueOf(classname) + " is not a instance of ISmsHandle");
            }
            catch (ClassNotFoundException e) {
                this.print(e);
            }
            catch (IllegalAccessException e) {
                this.print(e);
            }
            catch (InstantiationException e) {
                this.print(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isms.add(new DefaultSmsHandle());
    }

    protected int addHandler(ISmsHandle handle) {
        if (handle != null && !this.isms.contains(handle)) {
            this.isms.insertElementAt(handle, 0);
        }
        return this.isms.size();
    }

    protected int removeHandler(ISmsHandle handle) {
        if (handle != null && this.isms.contains(handle)) {
            this.isms.remove(handle);
        }
        return this.isms.size();
    }

    public int handle(SmReceived sm) throws HandleException {
        Object obj = null;
        ISmsHandle handler = null;
        int handleResult = 1;
        int i = 0;
        while (i < this.isms.size()) {
            obj = this.isms.get(i);
            if (obj instanceof ISmsHandle && (handleResult = (handler = (ISmsHandle)obj).handle(sm)) != 0) break;
            ++i;
        }
        return handleResult;
    }

    private int print(Object obj) {
        String ctime = new MyCalendar().toTime();
        StringBuffer sb = new StringBuffer(100);
        sb.append(ctime);
        sb.append(": ");
        sb.append(obj);
        TraceFactory.getTrace().trace(sb.toString(), 2);
        int len = sb.length();
        return len;
    }
}

