/*
 * Decompiled with CFR 0.152.
 */
package com.creawor.meip2.thread;

import com.creawor.meip2.http.DataSourceObject;
import com.creawor.meip2.http.HtmlPageChecker;
import com.creawor.meip2.http.HttpMonitorManager;
import com.creawor.meip2.http.IHTMLChecker;
import com.creawor.meip2.main.Main;
import com.haibo.log.TraceFactory;
import com.haibo.thread.ThreadBase;
import java.util.Enumeration;
import java.util.Hashtable;

public class URLCheckingThread
extends ThreadBase {
    private Hashtable ht_urls = null;

    public URLCheckingThread(Hashtable ht) {
        this.ht_urls = ht;
    }

    public URLCheckingThread() {
        this.ht_urls = HttpMonitorManager.getHandlers();
    }

    private void checkDataSource(DataSourceObject dso, IHTMLChecker idh) {
        if (dso == null || idh == null) {
            return;
        }
        try {
            String new_content = HtmlPageChecker.getInstance().getContent(dso);
            if (new_content != null) {
                idh.changed(dso, new_content);
            }
        }
        catch (Exception e) {
            idh.onException(dso, e);
        }
    }

    public void run() {
        Enumeration enumeration = null;
        DataSourceObject dso = null;
        IHTMLChecker idh = null;
        while (!this.bTerminal) {
            if (this.ht_urls != null) {
                enumeration = this.ht_urls.keys();
                while (enumeration.hasMoreElements()) {
                    dso = (DataSourceObject)enumeration.nextElement();
                    if (dso == null || this.ht_urls == null) continue;
                    idh = (IHTMLChecker)this.ht_urls.get(dso);
                    this.checkDataSource(dso, idh);
                }
                enumeration = null;
            }
            try {
                int nc = 5000;
                int nTotal = 1200000;
                try {
                    nTotal = Main.getCfg().readInt("URL_CHECKING_INTERVAL", 1200);
                    nTotal *= 1000;
                }
                catch (Exception e) {
                    TraceFactory.getTrace().trace("Parse URL_CHECKING_INTERVAL failed.", 2);
                    TraceFactory.getTrace().trace(e, 8);
                }
                int ep = nTotal / nc;
                int i = 0;
                while (i < nc) {
                    if (this.bTerminal) break;
                    Thread.sleep(ep);
                    ++i;
                }
                if (i >= nc) continue;
            }
            catch (Exception e) {}
            break;
        }
        TraceFactory.getTrace().trace("URLCheckingThread abnormal exit ***********************", 2);
    }
}

