/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;

public class CentralEndpointIntersector {
    private Coordinate[] pts;
    private Coordinate intPt = null;

    public static Coordinate getIntersection(Coordinate p00, Coordinate p01, Coordinate p10, Coordinate p11) {
        CentralEndpointIntersector intor = new CentralEndpointIntersector(p00, p01, p10, p11);
        return intor.getIntersection();
    }

    public CentralEndpointIntersector(Coordinate p00, Coordinate p01, Coordinate p10, Coordinate p11) {
        this.pts = new Coordinate[]{p00, p01, p10, p11};
        this.compute();
    }

    private void compute() {
        Coordinate centroid = CentralEndpointIntersector.average(this.pts);
        this.intPt = this.findNearestPoint(centroid, this.pts);
    }

    public Coordinate getIntersection() {
        return this.intPt;
    }

    private static Coordinate average(Coordinate[] pts) {
        Coordinate avg = new Coordinate();
        int n = pts.length;
        int i = 0;
        while (i < pts.length) {
            avg.x += pts[i].x;
            avg.y += pts[i].y;
            ++i;
        }
        if (n > 0) {
            avg.x /= (double)n;
            avg.y /= (double)n;
        }
        return avg;
    }

    private Coordinate findNearestPoint(Coordinate p, Coordinate[] pts) {
        double minDist = Double.MAX_VALUE;
        Coordinate result = null;
        int i = 0;
        while (i < pts.length) {
            double dist = p.distance(pts[i]);
            if (dist < minDist) {
                minDist = dist;
                result = pts[i];
            }
            ++i;
        }
        return result;
    }
}

