/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;

public class NonRobustCGAlgorithms
extends CGAlgorithms {
    public static boolean isPointInRing(Coordinate p, Coordinate[] ring) {
        int crossings = 0;
        int nPts = ring.length;
        int i = 1;
        while (i < nPts) {
            double xInt;
            int i1 = i - 1;
            Coordinate p1 = ring[i];
            Coordinate p2 = ring[i1];
            double x1 = p1.x - p.x;
            double y1 = p1.y - p.y;
            double x2 = p2.x - p.x;
            double y2 = p2.y - p.y;
            if ((y1 > 0.0 && y2 <= 0.0 || y2 > 0.0 && y1 <= 0.0) && 0.0 < (xInt = (x1 * y2 - x2 * y1) / (y2 - y1))) {
                ++crossings;
            }
            ++i;
        }
        return crossings % 2 == 1;
    }

    public static boolean isCCW(Coordinate[] ring) {
        int nPts = ring.length - 1;
        if (nPts < 4) {
            return false;
        }
        Coordinate hip = ring[0];
        int hii = 0;
        int i = 1;
        while (i <= nPts) {
            Coordinate p = ring[i];
            if (p.y > hip.y) {
                hip = p;
                hii = i;
            }
            ++i;
        }
        int iPrev = hii;
        while (ring[iPrev = (iPrev - 1) % nPts].equals(hip) && iPrev != hii) {
        }
        int iNext = hii;
        while (ring[iNext = (iNext + 1) % nPts].equals(hip) && iNext != hii) {
        }
        Coordinate prev = ring[iPrev];
        Coordinate next = ring[iNext];
        if (prev.equals(hip) || next.equals(hip) || prev.equals(next)) {
            throw new IllegalArgumentException("degenerate ring (does not contain 3 different points)");
        }
        double next2x = next.x - hip.x;
        double prev2y = prev.y - hip.y;
        double next2y = next.y - hip.y;
        double prev2x = prev.x - hip.x;
        double disc = next2x * prev2y - next2y * prev2x;
        if (disc == 0.0) {
            return prev.x > next.x;
        }
        return disc > 0.0;
    }

    public static int computeOrientation(Coordinate p1, Coordinate p2, Coordinate q) {
        double dx1 = p2.x - p1.x;
        double dy2 = q.y - p2.y;
        double dx2 = q.x - p2.x;
        double dy1 = p2.y - p1.y;
        double det = dx1 * dy2 - dx2 * dy1;
        if (det > 0.0) {
            return 1;
        }
        if (det < 0.0) {
            return -1;
        }
        return 0;
    }
}

