/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.geom.Coordinate;

public class RayCrossingCounter {
    private Coordinate p;
    private int crossingCount = 0;
    private boolean isPointOnSegment = false;

    public static int locatePointInRing(Coordinate p, Coordinate[] ring) {
        RayCrossingCounter counter = new RayCrossingCounter(p);
        int i = 1;
        while (i < ring.length) {
            Coordinate p1 = ring[i];
            Coordinate p2 = ring[i - 1];
            counter.countSegment(p1, p2);
            if (counter.isOnSegment()) {
                return counter.getLocation();
            }
            ++i;
        }
        return counter.getLocation();
    }

    public RayCrossingCounter(Coordinate p) {
        this.p = p;
    }

    public void countSegment(Coordinate p1, Coordinate p2) {
        if (p1.x < this.p.x && p2.x < this.p.x) {
            return;
        }
        if (this.p.x == p2.x && this.p.y == p2.y) {
            this.isPointOnSegment = true;
            return;
        }
        if (p1.y == this.p.y && p2.y == this.p.y) {
            double minx = p1.x;
            double maxx = p2.x;
            if (minx > maxx) {
                minx = p2.x;
                maxx = p1.x;
            }
            if (this.p.x >= minx && this.p.x <= maxx) {
                this.isPointOnSegment = true;
            }
            return;
        }
        if (p1.y > this.p.y && p2.y <= this.p.y || p2.y > this.p.y && p1.y <= this.p.y) {
            double x1 = p1.x - this.p.x;
            double y1 = p1.y - this.p.y;
            double x2 = p2.x - this.p.x;
            double y2 = p2.y - this.p.y;
            double xIntSign = RobustDeterminant.signOfDet2x2(x1, y1, x2, y2);
            if (xIntSign == 0.0) {
                this.isPointOnSegment = true;
                return;
            }
            if (y2 < y1) {
                xIntSign = -xIntSign;
            }
            if (xIntSign > 0.0) {
                ++this.crossingCount;
            }
        }
    }

    public boolean isOnSegment() {
        return this.isPointOnSegment;
    }

    public int getLocation() {
        if (this.isPointOnSegment) {
            return 1;
        }
        if (this.crossingCount % 2 == 1) {
            return 0;
        }
        return 2;
    }

    public boolean isPointInPolygon() {
        return this.getLocation() != 2;
    }
}

