/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;
import java.util.Arrays;
import java.util.TreeSet;

public class GeometryCollection
extends Geometry {
    private static final long serialVersionUID = -5694727726395021467L;
    protected Geometry[] geometries;

    public GeometryCollection(Geometry[] geometries, PrecisionModel precisionModel, int SRID) {
        this(geometries, new GeometryFactory(precisionModel, SRID));
    }

    public GeometryCollection(Geometry[] geometries, GeometryFactory factory) {
        super(factory);
        if (geometries == null) {
            geometries = new Geometry[]{};
        }
        if (GeometryCollection.hasNullElements(geometries)) {
            throw new IllegalArgumentException("geometries must not contain null elements");
        }
        this.geometries = geometries;
    }

    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.geometries[0].getCoordinate();
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coordinates = new Coordinate[this.getNumPoints()];
        int k = -1;
        int i = 0;
        while (i < this.geometries.length) {
            Coordinate[] childCoordinates = this.geometries[i].getCoordinates();
            int j = 0;
            while (j < childCoordinates.length) {
                coordinates[++k] = childCoordinates[j];
                ++j;
            }
            ++i;
        }
        return coordinates;
    }

    public boolean isEmpty() {
        int i = 0;
        while (i < this.geometries.length) {
            if (!this.geometries[i].isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getDimension() {
        int dimension = -1;
        int i = 0;
        while (i < this.geometries.length) {
            dimension = Math.max(dimension, this.geometries[i].getDimension());
            ++i;
        }
        return dimension;
    }

    public int getBoundaryDimension() {
        int dimension = -1;
        int i = 0;
        while (i < this.geometries.length) {
            dimension = Math.max(dimension, this.geometries[i].getBoundaryDimension());
            ++i;
        }
        return dimension;
    }

    public int getNumGeometries() {
        return this.geometries.length;
    }

    public Geometry getGeometryN(int n) {
        return this.geometries[n];
    }

    public int getNumPoints() {
        int numPoints = 0;
        int i = 0;
        while (i < this.geometries.length) {
            numPoints += this.geometries[i].getNumPoints();
            ++i;
        }
        return numPoints;
    }

    public String getGeometryType() {
        return "GeometryCollection";
    }

    public Geometry getBoundary() {
        this.checkNotGeometryCollection(this);
        Assert.shouldNeverReachHere();
        return null;
    }

    public double getArea() {
        double area = 0.0;
        int i = 0;
        while (i < this.geometries.length) {
            area += this.geometries[i].getArea();
            ++i;
        }
        return area;
    }

    public double getLength() {
        double sum = 0.0;
        int i = 0;
        while (i < this.geometries.length) {
            sum += this.geometries[i].getLength();
            ++i;
        }
        return sum;
    }

    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        GeometryCollection otherCollection = (GeometryCollection)other;
        if (this.geometries.length != otherCollection.geometries.length) {
            return false;
        }
        int i = 0;
        while (i < this.geometries.length) {
            if (!this.geometries[i].equalsExact(otherCollection.geometries[i], tolerance)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void apply(CoordinateFilter filter) {
        int i = 0;
        while (i < this.geometries.length) {
            this.geometries[i].apply(filter);
            ++i;
        }
    }

    public void apply(CoordinateSequenceFilter filter) {
        if (this.geometries.length == 0) {
            return;
        }
        int i = 0;
        while (i < this.geometries.length) {
            this.geometries[i].apply(filter);
            if (filter.isDone()) break;
            ++i;
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    public void apply(GeometryFilter filter) {
        filter.filter(this);
        int i = 0;
        while (i < this.geometries.length) {
            this.geometries[i].apply(filter);
            ++i;
        }
    }

    public void apply(GeometryComponentFilter filter) {
        filter.filter(this);
        int i = 0;
        while (i < this.geometries.length) {
            this.geometries[i].apply(filter);
            ++i;
        }
    }

    public Object clone() {
        GeometryCollection gc = (GeometryCollection)super.clone();
        gc.geometries = new Geometry[this.geometries.length];
        int i = 0;
        while (i < this.geometries.length) {
            gc.geometries[i] = (Geometry)this.geometries[i].clone();
            ++i;
        }
        return gc;
    }

    public void normalize() {
        int i = 0;
        while (i < this.geometries.length) {
            this.geometries[i].normalize();
            ++i;
        }
        Arrays.sort(this.geometries);
    }

    protected Envelope computeEnvelopeInternal() {
        Envelope envelope = new Envelope();
        int i = 0;
        while (i < this.geometries.length) {
            envelope.expandToInclude(this.geometries[i].getEnvelopeInternal());
            ++i;
        }
        return envelope;
    }

    protected int compareToSameClass(Object o) {
        TreeSet theseElements = new TreeSet(Arrays.asList(this.geometries));
        TreeSet otherElements = new TreeSet(Arrays.asList(((GeometryCollection)o).geometries));
        return this.compare(theseElements, otherElements);
    }

    protected int compareToSameClass(Object o, CoordinateSequenceComparator comp) {
        GeometryCollection gc = (GeometryCollection)o;
        int n1 = this.getNumGeometries();
        int n2 = gc.getNumGeometries();
        int i = 0;
        while (i < n1 && i < n2) {
            Geometry otherGeom;
            Geometry thisGeom = this.getGeometryN(i);
            int holeComp = thisGeom.compareToSameClass(otherGeom = gc.getGeometryN(i), comp);
            if (holeComp != 0) {
                return holeComp;
            }
            ++i;
        }
        if (i < n1) {
            return 1;
        }
        if (i < n2) {
            return -1;
        }
        return 0;
    }
}

