/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.linemerge;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.operation.linemerge.LineMergeEdge;
import com.vividsolutions.jts.operation.linemerge.LineMergeGraph;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.GraphComponent;
import com.vividsolutions.jts.planargraph.Node;
import com.vividsolutions.jts.planargraph.Subgraph;
import com.vividsolutions.jts.planargraph.algorithm.ConnectedSubgraphFinder;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;

public class LineSequencer {
    private LineMergeGraph graph = new LineMergeGraph();
    private GeometryFactory factory = new GeometryFactory();
    private int lineCount = 0;
    private boolean isRun = false;
    private Geometry sequencedGeometry = null;
    private boolean isSequenceable = false;

    public static boolean isSequenced(Geometry geom) {
        if (!(geom instanceof MultiLineString)) {
            return true;
        }
        MultiLineString mls = (MultiLineString)geom;
        TreeSet prevSubgraphNodes = new TreeSet();
        Coordinate lastNode = null;
        ArrayList<Coordinate> currNodes = new ArrayList<Coordinate>();
        int i = 0;
        while (i < mls.getNumGeometries()) {
            LineString line = (LineString)mls.getGeometryN(i);
            Coordinate startNode = line.getCoordinateN(0);
            Coordinate endNode = line.getCoordinateN(line.getNumPoints() - 1);
            if (prevSubgraphNodes.contains(startNode)) {
                return false;
            }
            if (prevSubgraphNodes.contains(endNode)) {
                return false;
            }
            if (lastNode != null && !startNode.equals(lastNode)) {
                prevSubgraphNodes.addAll(currNodes);
                currNodes.clear();
            }
            currNodes.add(startNode);
            currNodes.add(endNode);
            lastNode = endNode;
            ++i;
        }
        return true;
    }

    public void add(Collection geometries) {
        for (Geometry geometry : geometries) {
            this.add(geometry);
        }
    }

    public void add(Geometry geometry) {
        geometry.apply(new GeometryComponentFilter(){

            public void filter(Geometry component) {
                if (component instanceof LineString) {
                    LineSequencer.this.addLine((LineString)component);
                }
            }
        });
    }

    private void addLine(LineString lineString) {
        if (this.factory == null) {
            this.factory = lineString.getFactory();
        }
        this.graph.addEdge(lineString);
        ++this.lineCount;
    }

    public boolean isSequenceable() {
        this.computeSequence();
        return this.isSequenceable;
    }

    public Geometry getSequencedLineStrings() {
        this.computeSequence();
        return this.sequencedGeometry;
    }

    private void computeSequence() {
        if (this.isRun) {
            return;
        }
        this.isRun = true;
        List sequences = this.findSequences();
        if (sequences == null) {
            return;
        }
        this.sequencedGeometry = this.buildSequencedGeometry(sequences);
        this.isSequenceable = true;
        int finalLineCount = this.sequencedGeometry.getNumGeometries();
        Assert.isTrue(this.lineCount == finalLineCount, "Lines were missing from result");
        Assert.isTrue(this.sequencedGeometry instanceof LineString || this.sequencedGeometry instanceof MultiLineString, "Result is not lineal");
    }

    private List findSequences() {
        ArrayList<List> sequences = new ArrayList<List>();
        ConnectedSubgraphFinder csFinder = new ConnectedSubgraphFinder(this.graph);
        List subgraphs = csFinder.getConnectedSubgraphs();
        for (Subgraph subgraph : subgraphs) {
            if (this.hasSequence(subgraph)) {
                List seq = this.findSequence(subgraph);
                sequences.add(seq);
                continue;
            }
            return null;
        }
        return sequences;
    }

    private boolean hasSequence(Subgraph graph) {
        int oddDegreeCount = 0;
        Iterator i = graph.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getDegree() % 2 != 1) continue;
            ++oddDegreeCount;
        }
        return oddDegreeCount <= 2;
    }

    private List findSequence(Subgraph graph) {
        GraphComponent.setVisited(graph.edgeIterator(), false);
        Node startNode = LineSequencer.findLowestDegreeNode(graph);
        DirectedEdge startDE = (DirectedEdge)startNode.getOutEdges().iterator().next();
        DirectedEdge startDESym = startDE.getSym();
        LinkedList seq = new LinkedList();
        ListIterator lit = seq.listIterator();
        this.addReverseSubpath(startDESym, lit, false);
        while (lit.hasPrevious()) {
            DirectedEdge prev = (DirectedEdge)lit.previous();
            DirectedEdge unvisitedOutDE = LineSequencer.findUnvisitedBestOrientedDE(prev.getFromNode());
            if (unvisitedOutDE == null) continue;
            this.addReverseSubpath(unvisitedOutDE.getSym(), lit, true);
        }
        List orientedSeq = this.orient(seq);
        return orientedSeq;
    }

    private static DirectedEdge findUnvisitedBestOrientedDE(Node node) {
        DirectedEdge wellOrientedDE = null;
        DirectedEdge unvisitedDE = null;
        Iterator i = node.getOutEdges().iterator();
        while (i.hasNext()) {
            DirectedEdge de = (DirectedEdge)i.next();
            if (de.getEdge().isVisited()) continue;
            unvisitedDE = de;
            if (!de.getEdgeDirection()) continue;
            wellOrientedDE = de;
        }
        if (wellOrientedDE != null) {
            return wellOrientedDE;
        }
        return unvisitedDE;
    }

    private void addReverseSubpath(DirectedEdge de, ListIterator lit, boolean expectedClosed) {
        Node endNode = de.getToNode();
        Node fromNode = null;
        while (true) {
            lit.add(de.getSym());
            de.getEdge().setVisited(true);
            fromNode = de.getFromNode();
            DirectedEdge unvisitedOutDE = LineSequencer.findUnvisitedBestOrientedDE(fromNode);
            if (unvisitedOutDE == null) break;
            de = unvisitedOutDE.getSym();
        }
        if (expectedClosed) {
            Assert.isTrue(fromNode == endNode, "path not contiguous");
        }
    }

    private static Node findLowestDegreeNode(Subgraph graph) {
        int minDegree = Integer.MAX_VALUE;
        Node minDegreeNode = null;
        Iterator i = graph.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (minDegreeNode != null && node.getDegree() >= minDegree) continue;
            minDegree = node.getDegree();
            minDegreeNode = node;
        }
        return minDegreeNode;
    }

    private List orient(List seq) {
        boolean hasDegree1Node;
        DirectedEdge startEdge = (DirectedEdge)seq.get(0);
        DirectedEdge endEdge = (DirectedEdge)seq.get(seq.size() - 1);
        Node startNode = startEdge.getFromNode();
        Node endNode = endEdge.getToNode();
        boolean flipSeq = false;
        boolean bl = hasDegree1Node = startNode.getDegree() == 1 || endNode.getDegree() == 1;
        if (hasDegree1Node) {
            boolean hasObviousStartNode = false;
            if (endEdge.getToNode().getDegree() == 1 && !endEdge.getEdgeDirection()) {
                hasObviousStartNode = true;
                flipSeq = true;
            }
            if (startEdge.getFromNode().getDegree() == 1 && startEdge.getEdgeDirection()) {
                hasObviousStartNode = true;
                flipSeq = false;
            }
            if (!hasObviousStartNode && startEdge.getFromNode().getDegree() == 1) {
                flipSeq = true;
            }
        }
        if (flipSeq) {
            return this.reverse(seq);
        }
        return seq;
    }

    private List reverse(List seq) {
        LinkedList<DirectedEdge> newSeq = new LinkedList<DirectedEdge>();
        for (DirectedEdge de : seq) {
            newSeq.addFirst(de.getSym());
        }
        return newSeq;
    }

    private Geometry buildSequencedGeometry(List sequences) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (List seq : sequences) {
            for (DirectedEdge de : seq) {
                LineString line;
                LineMergeEdge e = (LineMergeEdge)de.getEdge();
                LineString lineToAdd = line = e.getLine();
                if (!de.getEdgeDirection() && !line.isClosed()) {
                    lineToAdd = LineSequencer.reverse(line);
                }
                lines.add(lineToAdd);
            }
        }
        if (lines.size() == 0) {
            return this.factory.createMultiLineString(new LineString[0]);
        }
        return this.factory.buildGeometry(lines);
    }

    private static LineString reverse(LineString line) {
        Coordinate[] pts = line.getCoordinates();
        Coordinate[] revPts = new Coordinate[pts.length];
        int len = pts.length;
        int i = 0;
        while (i < len) {
            revPts[len - 1 - i] = new Coordinate(pts[i]);
            ++i;
        }
        return line.getFactory().createLineString(revPts);
    }
}

