/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.snap;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.overlay.snap.SnapTransformer;
import java.util.TreeSet;

public class GeometrySnapper {
    private static final double SNAP_PRECISION_FACTOR = 1.0E-9;
    private Geometry srcGeom;

    public static double computeOverlaySnapTolerance(Geometry g) {
        double fixedSnapTol;
        double snapTolerance = GeometrySnapper.computeSizeBasedSnapTolerance(g);
        PrecisionModel pm = g.getPrecisionModel();
        if (pm.getType() == PrecisionModel.FIXED && (fixedSnapTol = 1.0 / pm.getScale() * 2.0 / 1.415) > snapTolerance) {
            snapTolerance = fixedSnapTol;
        }
        return snapTolerance;
    }

    public static double computeSizeBasedSnapTolerance(Geometry g) {
        Envelope env = g.getEnvelopeInternal();
        double minDimension = Math.min(env.getHeight(), env.getWidth());
        double snapTol = minDimension * 1.0E-9;
        return snapTol;
    }

    public static double computeOverlaySnapTolerance(Geometry g0, Geometry g1) {
        return Math.min(GeometrySnapper.computeOverlaySnapTolerance(g0), GeometrySnapper.computeOverlaySnapTolerance(g1));
    }

    public static Geometry[] snap(Geometry g0, Geometry g1, double snapTolerance) {
        Geometry[] snapGeom = new Geometry[2];
        GeometrySnapper snapper0 = new GeometrySnapper(g0);
        snapGeom[0] = snapper0.snapTo(g1, snapTolerance);
        GeometrySnapper snapper1 = new GeometrySnapper(g1);
        snapGeom[1] = snapper1.snapTo(snapGeom[0], snapTolerance);
        return snapGeom;
    }

    public GeometrySnapper(Geometry srcGeom) {
        this.srcGeom = srcGeom;
    }

    private double computeSnapTolerance(Coordinate[] ringPts) {
        double minSegLen = this.computeMinimumSegmentLength(ringPts);
        double snapTol = minSegLen / 10.0;
        return snapTol;
    }

    private double computeMinimumSegmentLength(Coordinate[] pts) {
        double minSegLen = Double.MAX_VALUE;
        int i = 0;
        while (i < pts.length - 1) {
            double segLen = pts[i].distance(pts[i + 1]);
            if (segLen < minSegLen) {
                minSegLen = segLen;
            }
            ++i;
        }
        return minSegLen;
    }

    public Geometry snapTo(Geometry snapGeom, double snapTolerance) {
        Coordinate[] snapPts = this.extractTargetCoordinates(snapGeom);
        SnapTransformer snapTrans = new SnapTransformer(snapTolerance, snapPts);
        return snapTrans.transform(this.srcGeom);
    }

    public Coordinate[] extractTargetCoordinates(Geometry g) {
        TreeSet<Coordinate> ptSet = new TreeSet<Coordinate>();
        Coordinate[] pts = g.getCoordinates();
        int i = 0;
        while (i < pts.length) {
            ptSet.add(pts[i]);
            ++i;
        }
        return ptSet.toArray(new Coordinate[0]);
    }
}

