/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.algorithm.locate.SimplePointInAreaLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.ShortCircuitedGeometryVisitor;

class ContainsPointVisitor
extends ShortCircuitedGeometryVisitor {
    private CoordinateSequence rectSeq;
    private Envelope rectEnv;
    private boolean containsPoint = false;

    public ContainsPointVisitor(Polygon rectangle) {
        this.rectSeq = rectangle.getExteriorRing().getCoordinateSequence();
        this.rectEnv = rectangle.getEnvelopeInternal();
    }

    public boolean containsPoint() {
        return this.containsPoint;
    }

    protected void visit(Geometry geom) {
        if (!(geom instanceof Polygon)) {
            return;
        }
        Envelope elementEnv = geom.getEnvelopeInternal();
        if (!this.rectEnv.intersects(elementEnv)) {
            return;
        }
        Coordinate rectPt = new Coordinate();
        int i = 0;
        while (i < 4) {
            this.rectSeq.getCoordinate(i, rectPt);
            if (elementEnv.contains(rectPt) && SimplePointInAreaLocator.containsPointInPolygon(rectPt, (Polygon)geom)) {
                this.containsPoint = true;
                return;
            }
            ++i;
        }
    }

    protected boolean isDone() {
        return this.containsPoint;
    }
}

