/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.MCPointInRing;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.EdgeIntersectionList;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.operation.valid.ConnectedInteriorTester;
import com.vividsolutions.jts.operation.valid.ConsistentAreaTester;
import com.vividsolutions.jts.operation.valid.QuadtreeNestedRingTester;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import com.vividsolutions.jts.util.Assert;
import java.util.Iterator;
import java.util.TreeSet;

public class IsValidOp {
    private Geometry parentGeometry;
    private boolean isSelfTouchingRingFormingHoleValid = false;
    private boolean isChecked = false;
    private TopologyValidationError validErr;

    public static boolean isValid(Coordinate coord) {
        if (Double.isNaN(coord.x)) {
            return false;
        }
        if (Double.isInfinite(coord.x)) {
            return false;
        }
        if (Double.isNaN(coord.y)) {
            return false;
        }
        return !Double.isInfinite(coord.y);
    }

    public static Coordinate findPtNotNode(Coordinate[] testCoords, LinearRing searchRing, GeometryGraph graph) {
        Edge searchEdge = graph.findEdge(searchRing);
        EdgeIntersectionList eiList = searchEdge.getEdgeIntersectionList();
        int i = 0;
        while (i < testCoords.length) {
            Coordinate pt = testCoords[i];
            if (!eiList.isIntersection(pt)) {
                return pt;
            }
            ++i;
        }
        return null;
    }

    public IsValidOp(Geometry parentGeometry) {
        this.parentGeometry = parentGeometry;
    }

    public void setSelfTouchingRingFormingHoleValid(boolean isValid) {
        this.isSelfTouchingRingFormingHoleValid = isValid;
    }

    public boolean isValid() {
        this.checkValid(this.parentGeometry);
        return this.validErr == null;
    }

    public TopologyValidationError getValidationError() {
        this.checkValid(this.parentGeometry);
        return this.validErr;
    }

    private void checkValid(Geometry g) {
        if (this.isChecked) {
            return;
        }
        this.validErr = null;
        if (g.isEmpty()) {
            return;
        }
        if (g instanceof Point) {
            this.checkValid((Point)g);
        } else if (g instanceof MultiPoint) {
            this.checkValid((MultiPoint)g);
        } else if (g instanceof LinearRing) {
            this.checkValid((LinearRing)g);
        } else if (g instanceof LineString) {
            this.checkValid((LineString)g);
        } else if (g instanceof Polygon) {
            this.checkValid((Polygon)g);
        } else if (g instanceof MultiPolygon) {
            this.checkValid((MultiPolygon)g);
        } else if (g instanceof GeometryCollection) {
            this.checkValid((GeometryCollection)g);
        } else {
            throw new UnsupportedOperationException(g.getClass().getName());
        }
    }

    private void checkValid(Point g) {
        this.checkInvalidCoordinates(g.getCoordinates());
    }

    private void checkValid(MultiPoint g) {
        this.checkInvalidCoordinates(g.getCoordinates());
    }

    private void checkValid(LineString g) {
        this.checkInvalidCoordinates(g.getCoordinates());
        if (this.validErr != null) {
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g);
        this.checkTooFewPoints(graph);
    }

    private void checkValid(LinearRing g) {
        this.checkInvalidCoordinates(g.getCoordinates());
        if (this.validErr != null) {
            return;
        }
        this.checkClosedRing(g);
        if (this.validErr != null) {
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g);
        this.checkTooFewPoints(graph);
        if (this.validErr != null) {
            return;
        }
        RobustLineIntersector li = new RobustLineIntersector();
        graph.computeSelfNodes(li, true);
        this.checkNoSelfIntersectingRings(graph);
    }

    private void checkValid(Polygon g) {
        this.checkInvalidCoordinates(g);
        if (this.validErr != null) {
            return;
        }
        this.checkClosedRings(g);
        if (this.validErr != null) {
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g);
        this.checkTooFewPoints(graph);
        if (this.validErr != null) {
            return;
        }
        this.checkConsistentArea(graph);
        if (this.validErr != null) {
            return;
        }
        if (!this.isSelfTouchingRingFormingHoleValid) {
            this.checkNoSelfIntersectingRings(graph);
            if (this.validErr != null) {
                return;
            }
        }
        this.checkHolesInShell(g, graph);
        if (this.validErr != null) {
            return;
        }
        this.checkHolesNotNested(g, graph);
        if (this.validErr != null) {
            return;
        }
        this.checkConnectedInteriors(graph);
    }

    private void checkValid(MultiPolygon g) {
        Polygon p;
        int i = 0;
        while (i < g.getNumGeometries()) {
            Polygon p2 = (Polygon)g.getGeometryN(i);
            this.checkInvalidCoordinates(p2);
            if (this.validErr != null) {
                return;
            }
            this.checkClosedRings(p2);
            if (this.validErr != null) {
                return;
            }
            ++i;
        }
        GeometryGraph graph = new GeometryGraph(0, g);
        this.checkTooFewPoints(graph);
        if (this.validErr != null) {
            return;
        }
        this.checkConsistentArea(graph);
        if (this.validErr != null) {
            return;
        }
        if (!this.isSelfTouchingRingFormingHoleValid) {
            this.checkNoSelfIntersectingRings(graph);
            if (this.validErr != null) {
                return;
            }
        }
        int i2 = 0;
        while (i2 < g.getNumGeometries()) {
            p = (Polygon)g.getGeometryN(i2);
            this.checkHolesInShell(p, graph);
            if (this.validErr != null) {
                return;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < g.getNumGeometries()) {
            p = (Polygon)g.getGeometryN(i2);
            this.checkHolesNotNested(p, graph);
            if (this.validErr != null) {
                return;
            }
            ++i2;
        }
        this.checkShellsNotNested(g, graph);
        if (this.validErr != null) {
            return;
        }
        this.checkConnectedInteriors(graph);
    }

    private void checkValid(GeometryCollection gc) {
        int i = 0;
        while (i < gc.getNumGeometries()) {
            Geometry g = gc.getGeometryN(i);
            this.checkValid(g);
            if (this.validErr != null) {
                return;
            }
            ++i;
        }
    }

    private void checkInvalidCoordinates(Coordinate[] coords) {
        int i = 0;
        while (i < coords.length) {
            if (!IsValidOp.isValid(coords[i])) {
                this.validErr = new TopologyValidationError(10, coords[i]);
                return;
            }
            ++i;
        }
    }

    private void checkInvalidCoordinates(Polygon poly) {
        this.checkInvalidCoordinates(poly.getExteriorRing().getCoordinates());
        if (this.validErr != null) {
            return;
        }
        int i = 0;
        while (i < poly.getNumInteriorRing()) {
            this.checkInvalidCoordinates(poly.getInteriorRingN(i).getCoordinates());
            if (this.validErr != null) {
                return;
            }
            ++i;
        }
    }

    private void checkClosedRings(Polygon poly) {
        this.checkClosedRing((LinearRing)poly.getExteriorRing());
        if (this.validErr != null) {
            return;
        }
        int i = 0;
        while (i < poly.getNumInteriorRing()) {
            this.checkClosedRing((LinearRing)poly.getInteriorRingN(i));
            if (this.validErr != null) {
                return;
            }
            ++i;
        }
    }

    private void checkClosedRing(LinearRing ring) {
        if (!ring.isClosed()) {
            this.validErr = new TopologyValidationError(11, ring.getCoordinateN(0));
        }
    }

    private void checkTooFewPoints(GeometryGraph graph) {
        if (graph.hasTooFewPoints()) {
            this.validErr = new TopologyValidationError(9, graph.getInvalidPoint());
            return;
        }
    }

    private void checkConsistentArea(GeometryGraph graph) {
        ConsistentAreaTester cat = new ConsistentAreaTester(graph);
        boolean isValidArea = cat.isNodeConsistentArea();
        if (!isValidArea) {
            this.validErr = new TopologyValidationError(5, cat.getInvalidPoint());
            return;
        }
        if (cat.hasDuplicateRings()) {
            this.validErr = new TopologyValidationError(8, cat.getInvalidPoint());
        }
    }

    private void checkNoSelfIntersectingRings(GeometryGraph graph) {
        Iterator i = graph.getEdgeIterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            this.checkNoSelfIntersectingRing(e.getEdgeIntersectionList());
            if (this.validErr == null) continue;
            return;
        }
    }

    private void checkNoSelfIntersectingRing(EdgeIntersectionList eiList) {
        TreeSet<Coordinate> nodeSet = new TreeSet<Coordinate>();
        boolean isFirst = true;
        Iterator i = eiList.iterator();
        while (i.hasNext()) {
            EdgeIntersection ei = (EdgeIntersection)i.next();
            if (isFirst) {
                isFirst = false;
                continue;
            }
            if (nodeSet.contains(ei.coord)) {
                this.validErr = new TopologyValidationError(6, ei.coord);
                return;
            }
            nodeSet.add(ei.coord);
        }
    }

    private void checkHolesInShell(Polygon p, GeometryGraph graph) {
        LinearRing shell = (LinearRing)p.getExteriorRing();
        MCPointInRing pir = new MCPointInRing(shell);
        int i = 0;
        while (i < p.getNumInteriorRing()) {
            boolean outside;
            LinearRing hole = (LinearRing)p.getInteriorRingN(i);
            Coordinate holePt = IsValidOp.findPtNotNode(hole.getCoordinates(), shell, graph);
            if (holePt == null) {
                return;
            }
            boolean bl = outside = !pir.isInside(holePt);
            if (outside) {
                this.validErr = new TopologyValidationError(2, holePt);
                return;
            }
            ++i;
        }
    }

    private void checkHolesNotNested(Polygon p, GeometryGraph graph) {
        QuadtreeNestedRingTester nestedTester = new QuadtreeNestedRingTester(graph);
        int i = 0;
        while (i < p.getNumInteriorRing()) {
            LinearRing innerHole = (LinearRing)p.getInteriorRingN(i);
            nestedTester.add(innerHole);
            ++i;
        }
        boolean isNonNested = nestedTester.isNonNested();
        if (!isNonNested) {
            this.validErr = new TopologyValidationError(3, nestedTester.getNestedPoint());
        }
    }

    private void checkShellsNotNested(MultiPolygon mp, GeometryGraph graph) {
        int i = 0;
        while (i < mp.getNumGeometries()) {
            Polygon p = (Polygon)mp.getGeometryN(i);
            LinearRing shell = (LinearRing)p.getExteriorRing();
            int j = 0;
            while (j < mp.getNumGeometries()) {
                if (i != j) {
                    Polygon p2 = (Polygon)mp.getGeometryN(j);
                    this.checkShellNotNested(shell, p2, graph);
                    if (this.validErr != null) {
                        return;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void checkShellNotNested(LinearRing shell, Polygon p, GeometryGraph graph) {
        Coordinate[] shellPts = shell.getCoordinates();
        LinearRing polyShell = (LinearRing)p.getExteriorRing();
        Coordinate[] polyPts = polyShell.getCoordinates();
        Coordinate shellPt = IsValidOp.findPtNotNode(shellPts, polyShell, graph);
        if (shellPt == null) {
            return;
        }
        boolean insidePolyShell = CGAlgorithms.isPointInRing(shellPt, polyPts);
        if (!insidePolyShell) {
            return;
        }
        if (p.getNumInteriorRing() <= 0) {
            this.validErr = new TopologyValidationError(7, shellPt);
            return;
        }
        Coordinate badNestedPt = null;
        int i = 0;
        while (i < p.getNumInteriorRing()) {
            LinearRing hole = (LinearRing)p.getInteriorRingN(i);
            badNestedPt = this.checkShellInsideHole(shell, hole, graph);
            if (badNestedPt == null) {
                return;
            }
            ++i;
        }
        this.validErr = new TopologyValidationError(7, badNestedPt);
    }

    private Coordinate checkShellInsideHole(LinearRing shell, LinearRing hole, GeometryGraph graph) {
        boolean insideHole;
        Coordinate[] shellPts = shell.getCoordinates();
        Coordinate[] holePts = hole.getCoordinates();
        Coordinate shellPt = IsValidOp.findPtNotNode(shellPts, hole, graph);
        if (shellPt != null && !(insideHole = CGAlgorithms.isPointInRing(shellPt, holePts))) {
            return shellPt;
        }
        Coordinate holePt = IsValidOp.findPtNotNode(holePts, shell, graph);
        if (holePt != null) {
            boolean insideShell = CGAlgorithms.isPointInRing(holePt, shellPts);
            if (insideShell) {
                return holePt;
            }
            return null;
        }
        Assert.shouldNeverReachHere("points in shell and hole appear to be equal");
        return null;
    }

    private void checkConnectedInteriors(GeometryGraph graph) {
        ConnectedInteriorTester cit = new ConnectedInteriorTester(graph);
        if (!cit.isInteriorsConnected()) {
            this.validErr = new TopologyValidationError(4, cit.getCoordinate());
        }
    }
}

