/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.LineSegment;

public class DouglasPeuckerLineSimplifier {
    private Coordinate[] pts;
    private boolean[] usePt;
    private double distanceTolerance;
    private LineSegment seg = new LineSegment();

    public static Coordinate[] simplify(Coordinate[] pts, double distanceTolerance) {
        DouglasPeuckerLineSimplifier simp = new DouglasPeuckerLineSimplifier(pts);
        simp.setDistanceTolerance(distanceTolerance);
        return simp.simplify();
    }

    public DouglasPeuckerLineSimplifier(Coordinate[] pts) {
        this.pts = pts;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        this.distanceTolerance = distanceTolerance;
    }

    public Coordinate[] simplify() {
        this.usePt = new boolean[this.pts.length];
        int i = 0;
        while (i < this.pts.length) {
            this.usePt[i] = true;
            ++i;
        }
        this.simplifySection(0, this.pts.length - 1);
        CoordinateList coordList = new CoordinateList();
        int i2 = 0;
        while (i2 < this.pts.length) {
            if (this.usePt[i2]) {
                coordList.add(new Coordinate(this.pts[i2]));
            }
            ++i2;
        }
        return coordList.toCoordinateArray();
    }

    private void simplifySection(int i, int j) {
        if (i + 1 == j) {
            return;
        }
        this.seg.p0 = this.pts[i];
        this.seg.p1 = this.pts[j];
        double maxDistance = -1.0;
        int maxIndex = i;
        int k = i + 1;
        while (k < j) {
            double distance = this.seg.distance(this.pts[k]);
            if (distance > maxDistance) {
                maxDistance = distance;
                maxIndex = k;
            }
            ++k;
        }
        if (maxDistance <= this.distanceTolerance) {
            k = i + 1;
            while (k < j) {
                this.usePt[k] = false;
                ++k;
            }
        } else {
            this.simplifySection(i, maxIndex);
            this.simplifySection(maxIndex, j);
        }
    }
}

