/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

import com.vividsolutions.jts.util.Progress;
import com.vividsolutions.jts.util.ProgressWrapper;

public class SubProgress
extends ProgressWrapper {
    int workAmount;
    double scale;
    double subWorked;

    public SubProgress(Progress progress, int workAmount) {
        super(progress);
        this.workAmount = workAmount > 0 ? workAmount : 0;
    }

    public void begin(String mainTask, int totalWork) {
        double ratio;
        this.delegate.setTask(mainTask);
        this.scale = totalWork <= 0 ? 0.0 : (ratio = (double)this.workAmount / (double)totalWork);
    }

    public void done() {
        double left = (double)this.workAmount - this.subWorked;
        if (left > 0.0) {
            this.delegate.worked((int)left);
        }
    }

    public boolean isCanceled() {
        return false;
    }

    public void worked(int worked) {
        if (this.subWorked >= (double)this.workAmount) {
            return;
        }
        if (worked <= 0) {
            return;
        }
        double amount = this.scale * (double)worked;
        int before = (int)this.subWorked;
        this.subWorked += amount;
        int after = (int)this.subWorked;
        int difference = after - before;
        if (difference == 0) {
            return;
        }
        this.delegate.worked(difference);
    }
}

