/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.miniseedutils.steim;

public class ChannelMask
implements Cloneable {
    public static final int FLAG_TRANSMIT_CONTINUE = 0;
    public static final int FLAG_TRANSMIT_TRIGGER = 1;
    public static final int FLAG_DATA_TYPE_SEISMIC = 4;
    public static final int FLAG_DATA_TYPE_STRONG = 5;
    public static final int FLAG_COMPONENT_N = 8;
    public static final int FLAG_COMPONENT_E = 9;
    public static final int FLAG_COMPONENT_Z = 10;
    public static final int FLAG_BAND_E = 20;
    public static final int FLAG_BAND_S = 21;
    public static final int FLAG_BAND_H = 22;
    public static final int FLAG_BAND_B = 23;
    public static final int FLAG_BAND_M = 24;
    public static final int FLAG_BAND_L = 25;
    public static final int FLAG_BAND_V = 26;
    public static final int FLAG_BAND_U = 27;
    public static final int FLAG_BAND_R = 28;
    private int mask;

    public static ChannelMask getFullChannelMask() {
        ChannelMask chanMask = new ChannelMask();
        chanMask.set();
        return chanMask;
    }

    public ChannelMask() {
        this.mask = 0;
    }

    public ChannelMask(int mask) {
        this.mask = mask;
    }

    public void clean() {
        this.mask = 0;
    }

    public void clean(int flag) {
        this.mask &= ~(1 << flag);
    }

    public void set(int flag) {
        this.mask |= 1 << flag;
    }

    public void set() {
        this.mask = 535824179;
    }

    public static ChannelMask get(String mask) {
        ChannelMask chanMask = null;
        if (mask.equalsIgnoreCase("ALL")) {
            chanMask = ChannelMask.getFullChannelMask();
        } else if (mask.equalsIgnoreCase("CONTINUE")) {
            chanMask = new ChannelMask(535824177);
        } else if (mask.equalsIgnoreCase("TRIGGER")) {
            chanMask = new ChannelMask(535824178);
        } else if (mask.equalsIgnoreCase("SEISMIC")) {
            chanMask = new ChannelMask(535824147);
        } else if (mask.equalsIgnoreCase("STRONG")) {
            chanMask = new ChannelMask(535824163);
        } else if (mask.equalsIgnoreCase("NS")) {
            chanMask = new ChannelMask(535822643);
        } else if (mask.equalsIgnoreCase("EW")) {
            chanMask = new ChannelMask(535822899);
        } else if (mask.equalsIgnoreCase("UD")) {
            chanMask = new ChannelMask(535823411);
        } else if (mask.equalsIgnoreCase("E")) {
            chanMask = new ChannelMask(1050419);
        } else if (mask.equalsIgnoreCase("S")) {
            chanMask = new ChannelMask(2098995);
        } else if (mask.equalsIgnoreCase("H")) {
            chanMask = new ChannelMask(4196147);
        } else if (mask.equalsIgnoreCase("B")) {
            chanMask = new ChannelMask(8390451);
        } else if (mask.equalsIgnoreCase("M")) {
            chanMask = new ChannelMask(16779059);
        } else if (mask.equalsIgnoreCase("L")) {
            chanMask = new ChannelMask(33556275);
        } else if (mask.equalsIgnoreCase("V")) {
            chanMask = new ChannelMask(67110707);
        } else if (mask.equalsIgnoreCase("U")) {
            chanMask = new ChannelMask(134219571);
        } else if (mask.equalsIgnoreCase("R")) {
            chanMask = new ChannelMask(268437299);
        } else if (mask.startsWith("0X") || mask.startsWith("0x")) {
            try {
                chanMask = new ChannelMask(Integer.parseInt(mask.substring(2), 16));
            }
            catch (NumberFormatException nfEx) {
                chanMask = null;
            }
        } else {
            try {
                chanMask = new ChannelMask(Integer.parseInt(mask, 16));
            }
            catch (NumberFormatException nfEx) {
                chanMask = null;
            }
        }
        return chanMask;
    }

    void set(String chanCode, String locID) {
        char bnd = chanCode.charAt(0);
        switch (bnd) {
            case 'E': {
                this.set(20);
                break;
            }
            case 'S': {
                this.set(21);
                break;
            }
            case 'H': {
                this.set(22);
                break;
            }
            case 'B': {
                this.set(23);
                break;
            }
            case 'M': {
                this.set(24);
                break;
            }
            case 'L': {
                this.set(25);
                break;
            }
            case 'V': {
                this.set(26);
                break;
            }
            case 'U': {
                this.set(27);
                break;
            }
            case 'R': {
                this.set(28);
                break;
            }
        }
        char type = chanCode.charAt(1);
        switch (type) {
            case 'A': {
                this.set(5);
                break;
            }
            default: {
                this.set(4);
            }
        }
        char cmp = chanCode.charAt(2);
        switch (cmp) {
            case 'N': {
                this.set(8);
                break;
            }
            case 'E': {
                this.set(9);
                break;
            }
            case 'Z': {
                this.set(10);
                break;
            }
        }
        try {
            int nLocID = Integer.parseInt(locID);
            if (nLocID < 50) {
                this.set(0);
            } else {
                this.set(1);
            }
        }
        catch (NumberFormatException ex) {
            this.set(0);
        }
    }

    public boolean isValid() {
        if ((this.mask & 3) == 0) {
            return false;
        }
        if ((this.mask & 0x30) == 0) {
            return false;
        }
        if ((this.mask & 0x700) == 0) {
            return false;
        }
        return (this.mask & 0x1FF00000) != 0;
    }

    public boolean contain(ChannelMask cm) {
        if ((this.mask & 3 & cm.mask) == 0) {
            return false;
        }
        if ((this.mask & 0x30 & cm.mask) == 0) {
            return false;
        }
        if ((this.mask & 0x700 & cm.mask) == 0) {
            return false;
        }
        return (this.mask & 0x1FF00000 & cm.mask) != 0;
    }

    public void add(ChannelMask cm) {
        this.mask |= cm.mask;
    }

    public void remove(ChannelMask cm) {
        this.mask &= ~cm.mask;
    }

    public boolean get(int flag) {
        boolean result = false;
        result = (this.mask & 1 << flag) != 0;
        return result;
    }

    public Object clone() {
        ChannelMask result = null;
        try {
            result = (ChannelMask)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.mask = this.mask;
        return result;
    }

    public String toString() {
        String hex = Integer.toHexString(this.mask);
        int lft = 8 - hex.length();
        String pad = "";
        int i = 0;
        while (i < lft) {
            pad = String.valueOf(pad) + "0";
            ++i;
        }
        return String.valueOf(pad) + hex;
    }
}

