/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.miniseedutils.steim;

import edu.iris.miniseedutils.steim.CompressMiniSeedRecord;
import edu.iris.timeutils.TimeStamp;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class GenericCompressMiniSeedRecord
extends CompressMiniSeedRecord {
    Vector vec = new Vector();

    public GenericCompressMiniSeedRecord(short steimLevel, short dframes) {
        super(steimLevel, dframes);
    }

    public int encodeMiniSeedRecord(int[] darray) {
        return this.encodeMiniSeedRecord(darray, 0, darray.length);
    }

    public int encodeMiniSeedRecord(int[] darray, int compSamps) {
        return this.encodeMiniSeedRecord(darray, 0, compSamps);
    }

    public int encodeMiniSeedRecord(int[] darray, int startIdx, int compSamps) {
        int nSamps = 0;
        int totalSamps = 0;
        do {
            nSamps = this.encodeOneMiniSeedRecord(darray, startIdx + totalSamps, compSamps - totalSamps);
            totalSamps += nSamps;
            this.vec.add(super.getBytes());
            TimeStamp ots = this.getStartTime();
            TimeStamp ts = new TimeStamp(ots.getTime() / 1000L * 1000L + (long)(ots.getNanos() / 1000000) + Math.round((double)(nSamps * 1000) / this.getSampleRate()));
            this.setStartTime(ts);
        } while (totalSamps < compSamps);
        if (totalSamps != compSamps) {
            System.err.println("Intenal Error in GenericCompressMiniSeedRecord.encodeMiniSeedRecord");
        }
        return totalSamps;
    }

    public Vector getComressFrame() {
        Vector oVec = (Vector)this.vec.clone();
        this.vec.removeAllElements();
        return oVec;
    }

    public byte[] getTotalBytes() {
        Enumeration Enum2 = this.vec.elements();
        int nTotal = 0;
        while (Enum2.hasMoreElements()) {
            byte[] msBytes = (byte[])Enum2.nextElement();
            nTotal += msBytes.length;
        }
        byte[] totalBytes = new byte[nTotal];
        int count = 0;
        Enum2 = this.vec.elements();
        while (Enum2.hasMoreElements()) {
            byte[] msBytes = (byte[])Enum2.nextElement();
            System.arraycopy(msBytes, 0, totalBytes, count, msBytes.length);
            count += msBytes.length;
        }
        this.vec.removeAllElements();
        return totalBytes;
    }

    public static void main(String[] args) {
        try {
            GenericCompressMiniSeedRecord cmsr = new GenericCompressMiniSeedRecord(1, 7);
            cmsr.setSampleRate(50.0);
            cmsr.setStartTime(TimeStamp.buildTimestamp("2000-10-18 22:50:40"));
            cmsr.setStationInfo("IC", "SSE", "10", "BHZ");
            int[] test = new int[1024];
            int A = (int)Math.pow(2.0, 6.0);
            int y0 = (int)Math.pow(2.0, 6.0);
            int i = 0;
            while (i < 1024) {
                test[i] = i % 2 * A + y0;
                ++i;
            }
            int nEncode = cmsr.encodeOneMiniSeedRecord(test);
            System.out.println("total samples: " + nEncode);
            FileOutputStream fos = new FileOutputStream("/tmp/my.mseed");
            fos.write(cmsr.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }
}

