/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.miniseedutils.steim;

import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniseedFormatException;
import edu.iris.miniseedutils.steim.UnrecognizedBlocketteException;
import edu.iris.miniseedutils.steim.UnrecognizedFormatException;
import edu.iris.seedutils.SeedBlocketteReader;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class GenericMiniSeedRecordOutput
implements Runnable {
    protected ArrayList recordList = new ArrayList();
    private int numBytesToRead = -1;
    private BufferedInputStream bis;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList parseMiniSeedWaveforms(String mseedFileName) {
        String currWfNet = "";
        String currWfSta = "";
        String currWfLocID = "";
        String currWfChan = "";
        boolean firstRecord = true;
        short currWfFormatCode = 0;
        short currWfWordOrder = 0;
        int recLen = 0;
        long numSamplesInWf = 0L;
        long offsetToWf = 0L;
        long numBytesInWf = 0L;
        long numRecsInWf = 0L;
        float clockTolerance = 1.0E-4f;
        double avgWfSampleRate = 0.0;
        TimeStamp currWfStartTime = null;
        boolean lastSummarySaved = false;
        ArrayList wfSummary = new ArrayList();
        File fileRef = new File(mseedFileName);
        String dir = fileRef.getParent();
        String dfile = fileRef.getName();
        try {
            this.bis = new BufferedInputStream(new FileInputStream(mseedFileName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return wfSummary;
        }
        Thread thread = new Thread(this);
        thread.start();
        while (true) {
            GenericMiniSeedRecord gmsRec = null;
            double time_diff = 0.0;
            double allowedDrift = 0.0;
            double sampleRate = 0.0;
            long numSamples = 0L;
            ArrayList arrayList = this.recordList;
            synchronized (arrayList) {
                try {
                    while (this.recordList.isEmpty()) {
                        this.recordList.wait();
                    }
                    gmsRec = (GenericMiniSeedRecord)this.recordList.get(0);
                    if (gmsRec == null) {
                        this.recordList.remove(0);
                        break;
                    }
                    String net = gmsRec.getNetwork();
                    String sta = gmsRec.getStation();
                    String locid = gmsRec.getLocID();
                    String chan = gmsRec.getChannel();
                    TimeStamp start = TimeStamp.buildTimestamp(gmsRec.getStartTimeStr());
                    numSamples = gmsRec.getNumSamples();
                    sampleRate = gmsRec.getSampleRate();
                    if (!firstRecord) {
                        allowedDrift = (double)clockTolerance * (double)numSamplesInWf;
                        double pred_start_lag = (double)numSamplesInWf / avgWfSampleRate;
                        double currWfStartEpoch = currWfStartTime.toEpochTime();
                        double startEpoch = start.toEpochTime();
                        double start_lag = startEpoch - currWfStartEpoch;
                        time_diff = Math.abs(start_lag - pred_start_lag);
                    }
                    if (firstRecord) {
                        firstRecord = false;
                        currWfNet = net;
                        currWfSta = sta;
                        currWfLocID = locid;
                        currWfChan = chan;
                        currWfStartTime = start;
                        currWfFormatCode = gmsRec.getDataFormat();
                        currWfWordOrder = gmsRec.getWordOrder();
                        avgWfSampleRate = sampleRate;
                        numSamplesInWf = 0L;
                        numBytesInWf = recLen;
                        numRecsInWf = 0L;
                        lastSummarySaved = false;
                    } else if (currWfNet.compareTo(net) != 0 || currWfSta.compareTo(sta) != 0 || currWfLocID.compareTo(locid) != 0 || currWfChan.compareTo(chan) != 0 || time_diff > allowedDrift) {
                        double wfStartEpoch = currWfStartTime.toEpochTime();
                        double wfEndEpoch = wfStartEpoch + (double)numSamplesInWf / avgWfSampleRate;
                        TimeStamp currWfEndTime = TimeStamp.buildTimestamp(wfEndEpoch, 4);
                        ArrayList<Object> wfRec = new ArrayList<Object>();
                        wfRec.add(currWfNet);
                        wfRec.add(currWfSta);
                        wfRec.add(currWfLocID);
                        wfRec.add(currWfChan);
                        wfRec.add(new Double(avgWfSampleRate));
                        wfRec.add(new Long(numSamplesInWf));
                        wfRec.add(currWfStartTime);
                        wfRec.add(currWfEndTime);
                        wfRec.add(dir);
                        wfRec.add(dfile);
                        wfRec.add(new Long(offsetToWf));
                        wfRec.add(new Long(numBytesInWf));
                        wfRec.add(new Short(currWfFormatCode));
                        wfRec.add(new Short(currWfWordOrder));
                        wfSummary.add(wfRec);
                        lastSummarySaved = true;
                        firstRecord = true;
                        offsetToWf += numBytesInWf;
                        continue;
                    }
                    this.recordList.remove(0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (avgWfSampleRate != sampleRate) {
                avgWfSampleRate = (double)(numSamplesInWf + numSamples) / ((double)(numSamplesInWf - 1L) / avgWfSampleRate + (double)(numSamples - 1L) / sampleRate);
            }
            numSamplesInWf += numSamples;
            numBytesInWf += (long)gmsRec.getRecordLength();
            ++numRecsInWf;
        }
        if (!lastSummarySaved) {
            double wfStartEpoch = currWfStartTime.toEpochTime();
            double wfEndEpoch = wfStartEpoch + (double)numSamplesInWf / avgWfSampleRate;
            TimeStamp currWfEndTime = TimeStamp.buildTimestamp(wfEndEpoch, 4);
            ArrayList<Object> wfRec = new ArrayList<Object>();
            wfRec.add(currWfNet);
            wfRec.add(currWfSta);
            wfRec.add(currWfLocID);
            wfRec.add(currWfChan);
            wfRec.add(new Double(avgWfSampleRate));
            wfRec.add(new Long(numSamplesInWf));
            wfRec.add(currWfStartTime);
            wfRec.add(currWfEndTime);
            wfRec.add(dir);
            wfRec.add(dfile);
            wfRec.add(new Long(offsetToWf));
            wfRec.add(new Long(numBytesInWf));
            wfRec.add(new Short(currWfFormatCode));
            wfRec.add(new Short(currWfWordOrder));
            wfSummary.add(wfRec);
        }
        return wfSummary;
    }

    public static void printWaveformSummary(PrintStream os, TimeStamp start, TimeStamp end, long numSamp, double avgSrate, long numBytes, long numRecs) {
        os.println("<<< END OF DATA TRACE >>>");
        os.println("              start time:  " + start.toSeedString());
        os.println("                end time:  " + end.toSeedString());
        os.println("         total # samples:  " + numSamp);
        os.println("        avg. sample rate:  " + avgSrate);
        os.println("           total # bytes:  " + numBytes);
        os.println("         total # records:  " + numRecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMiniSeedRecordContents(BufferedInputStream bis, PrintStream os) {
        String currWfNet = "";
        String currWfSta = "";
        String currWfLocID = "";
        String currWfChan = "";
        boolean firstRecord = true;
        int recLen = 0;
        long numSamplesInWf = 0L;
        long numBytesInWf = 0L;
        long numRecsInWf = 0L;
        float clockTolerance = 1.0E-4f;
        double avgWfSampleRate = 0.0;
        TimeStamp currWfStartTime = null;
        boolean lastSummaryPrinted = false;
        this.bis = bis;
        Thread thread = new Thread(this);
        thread.start();
        while (true) {
            GenericMiniSeedRecord gmsRec = null;
            double time_diff = 0.0;
            double allowedDrift = 0.0;
            double sampleRate = 0.0;
            long numSamples = 0L;
            ArrayList arrayList = this.recordList;
            synchronized (arrayList) {
                try {
                    while (this.recordList.isEmpty()) {
                        this.recordList.wait();
                    }
                    gmsRec = (GenericMiniSeedRecord)this.recordList.get(0);
                    if (gmsRec == null) {
                        this.recordList.remove(0);
                        break;
                    }
                    String net = gmsRec.getNetwork();
                    String sta = gmsRec.getStation();
                    String locid = gmsRec.getLocID();
                    String chan = gmsRec.getChannel();
                    TimeStamp start = TimeStamp.buildTimestamp(gmsRec.getStartTimeStr());
                    numSamples = gmsRec.getNumSamples();
                    sampleRate = gmsRec.getSampleRate();
                    if (!firstRecord) {
                        allowedDrift = (double)clockTolerance * (double)numSamplesInWf;
                        double pred_start_lag = (double)numSamplesInWf / avgWfSampleRate;
                        double currWfStartEpoch = currWfStartTime.toEpochTime();
                        double startEpoch = start.toEpochTime();
                        double start_lag = startEpoch - currWfStartEpoch;
                        time_diff = Math.abs(start_lag - pred_start_lag);
                    }
                    if (firstRecord) {
                        firstRecord = false;
                        currWfNet = net;
                        currWfSta = sta;
                        currWfLocID = locid;
                        currWfChan = chan;
                        currWfStartTime = start;
                        avgWfSampleRate = sampleRate;
                        numSamplesInWf = 0L;
                        numBytesInWf = recLen;
                        numRecsInWf = 0L;
                        lastSummaryPrinted = false;
                    } else if (currWfNet.compareTo(net) != 0 || currWfSta.compareTo(sta) != 0 || currWfLocID.compareTo(locid) != 0 || currWfChan.compareTo(chan) != 0 || time_diff > allowedDrift) {
                        double wfStartEpoch = currWfStartTime.toEpochTime();
                        double wfEndEpoch = wfStartEpoch + (double)numSamplesInWf / avgWfSampleRate;
                        TimeStamp currWfEndTime = TimeStamp.buildTimestamp(wfEndEpoch, 4);
                        GenericMiniSeedRecordOutput.printWaveformSummary(os, currWfStartTime, currWfEndTime, numSamplesInWf, avgWfSampleRate, numBytesInWf, numRecsInWf);
                        lastSummaryPrinted = true;
                        firstRecord = true;
                        continue;
                    }
                    this.recordList.remove(0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            gmsRec.printDataBlockettes(os);
            if (avgWfSampleRate != sampleRate) {
                avgWfSampleRate = (double)(numSamplesInWf + numSamples) / ((double)(numSamplesInWf - 1L) / avgWfSampleRate + (double)(numSamples - 1L) / sampleRate);
            }
            numSamplesInWf += numSamples;
            numBytesInWf += (long)gmsRec.getRecordLength();
            ++numRecsInWf;
        }
        if (!lastSummaryPrinted) {
            double wfStartEpoch = currWfStartTime.toEpochTime();
            double wfEndEpoch = wfStartEpoch + (double)numSamplesInWf / avgWfSampleRate;
            TimeStamp currWfEndTime = TimeStamp.buildTimestamp(wfEndEpoch, 4);
            GenericMiniSeedRecordOutput.printWaveformSummary(os, currWfStartTime, currWfEndTime, numSamplesInWf, avgWfSampleRate, numBytesInWf, numRecsInWf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int windowPodData(String mseedFileName, TimeStamp startTime, TimeStamp endTime, long offsetToData, int numBytes, SeedBlocketteReader reader) {
        byte[] buff = null;
        int numRecordsOuput = 0;
        int recLen = 0;
        try {
            this.bis = new BufferedInputStream(new FileInputStream(mseedFileName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return numRecordsOuput;
        }
        try {
            if (offsetToData > 0L) {
                this.bis.skip(offsetToData);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return numRecordsOuput;
        }
        this.numBytesToRead = numBytes;
        Thread thread = new Thread(this);
        thread.start();
        while (true) {
            GenericMiniSeedRecord gmsRec = null;
            double sampleRate = 0.0;
            long numSamples = 0L;
            ArrayList arrayList = this.recordList;
            synchronized (arrayList) {
                try {
                    while (this.recordList.isEmpty()) {
                        this.recordList.wait();
                    }
                    gmsRec = (GenericMiniSeedRecord)this.recordList.get(0);
                    if (gmsRec == null) {
                        this.recordList.remove(0);
                        break;
                    }
                    TimeStamp start = TimeStamp.buildTimestamp(gmsRec.getStartTimeStr());
                    numSamples = gmsRec.getNumSamples();
                    sampleRate = gmsRec.getSampleRate();
                    double recTimeSpan = (double)(numSamples - 1L) / sampleRate;
                    TimeStamp end = TimeStamp.buildTimestamp(start.toEpochTime() + recTimeSpan, 4);
                    if (end.toEpochTime() > startTime.toEpochTime() && start.toEpochTime() < endTime.toEpochTime()) {
                        recLen = gmsRec.getRecordLength();
                        if (buff == null || recLen != buff.length) {
                            buff = new byte[recLen];
                        }
                        byte[] headerBytes = gmsRec.getHeaderBytes();
                        byte[] dataBytes = gmsRec.getDataBytes();
                        System.arraycopy(headerBytes, 0, buff, 0, headerBytes.length);
                        System.arraycopy(dataBytes, 0, buff, headerBytes.length, dataBytes.length);
                        reader.putPodBlkt(buff);
                        ++numRecordsOuput;
                    }
                    this.recordList.remove(0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return numRecordsOuput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] dataBytes = null;
        int numBytesRead = 0;
        GenericMiniSeedRecord gmsRec = null;
        while (true) {
            int recLen;
            byte[] headerBytes;
            try {
                this.bis.mark(1);
                int nbytes = this.bis.read();
                if (nbytes == -1) break;
                this.bis.reset();
                headerBytes = GenericMiniSeedRecord.getHeader(this.bis);
                if (headerBytes == null) break;
                recLen = GenericMiniSeedRecord.getRecordLength(headerBytes);
                if (recLen < 0) {
                    recLen = 4096;
                }
                int dataByteLen = recLen - headerBytes.length;
                if (dataBytes == null || dataBytes.length != dataByteLen) {
                    dataBytes = new byte[dataByteLen];
                }
                int nbytesRead = 0;
                do {
                    if ((nbytes = this.bis.read(dataBytes, nbytesRead, dataByteLen - nbytesRead)) != -1) continue;
                    throw new MiniseedFormatException("End of file reached while reading a miniSEED data record's data");
                } while ((nbytesRead += nbytes) < dataByteLen);
            }
            catch (MiniseedFormatException e) {
                e.printStackTrace();
                break;
            }
            catch (UnrecognizedBlocketteException e) {
                e.printStackTrace();
                break;
            }
            catch (UnrecognizedFormatException e) {
                e.printStackTrace();
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
                break;
            }
            gmsRec = GenericMiniSeedRecord.buildMiniSeedRecord(headerBytes, dataBytes, recLen);
            ArrayList arrayList = this.recordList;
            synchronized (arrayList) {
                if (this.numBytesToRead >= 0 && (numBytesRead += gmsRec.getRecordLength()) > this.numBytesToRead) {
                    break;
                }
                this.recordList.add(gmsRec);
                this.recordList.notify();
            }
        }
        ArrayList arrayList = this.recordList;
        synchronized (arrayList) {
            this.recordList.add(null);
            this.recordList.notify();
        }
    }

    public static void main(String[] args) {
        BufferedInputStream bis = null;
        String mseedFileName = "";
        if (args.length != 1) {
            System.err.println("Usage:  java edu.iris.steim.GenericMiniSeedRecord miniSEEDFile");
            System.exit(-1);
        }
        mseedFileName = args[0];
        try {
            bis = new BufferedInputStream(new FileInputStream(mseedFileName), 65536);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(0);
        }
        GenericMiniSeedRecordOutput gmsRec = new GenericMiniSeedRecordOutput();
        gmsRec.printMiniSeedRecordContents(bis, System.err);
        System.exit(0);
    }
}

