/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.miniseedutils.steim;

import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniSeedRecordHeader;

public class MiniSeedRecordDouble
extends MiniSeedRecordHeader {
    private double[] data;

    public MiniSeedRecordDouble cut(double offset, double length, double time) {
        double st = this.startTime;
        double dt = time - st + offset;
        int noff = (int)(dt * this.sampleRate + 0.5);
        int nlen = (int)(length * this.sampleRate + 0.5);
        if (noff < 0) {
            nlen += noff;
            noff = 0;
        }
        double[] d = new double[nlen];
        System.arraycopy(this.data, noff, d, 0, nlen);
        this.data = d;
        this.startTime = st += (double)noff / this.sampleRate;
        this.endTime = st + (double)nlen / this.sampleRate;
        return this;
    }

    public static MiniSeedRecordDouble build(MiniSeedRecord g) {
        MiniSeedRecordDouble msr = new MiniSeedRecordDouble();
        msr.setNetwork(g.getNetwork());
        msr.setStation(g.getStation());
        msr.setLocID(g.getLocID());
        msr.setChannel(g.getChannel());
        msr.setStartTime(g.getStartTime());
        msr.setEndTime(g.getEndTime());
        msr.setSampleRate(g.getSampleRate());
        msr.setNumSamples(g.getNumSamples());
        msr.sequenceNumber = g.getSequenceNumber();
        msr.activeFlag = g.getActiveFlag();
        msr.caliFlag = g.getCaliFlag();
        msr.setData(new double[g.getNumSamples()]);
        int[] udata = g.getData();
        int i = 0;
        while (i < udata.length) {
            msr.getData()[i] = udata[i];
            ++i;
        }
        return msr;
    }

    public static MiniSeedRecordDouble build(GenericMiniSeedRecord g) {
        MiniSeedRecordDouble msr = new MiniSeedRecordDouble();
        MiniSeedRecordHeader.build(g, msr);
        msr.setData(new double[g.getNumSamples()]);
        int[] udata = g.getUData();
        if (udata == null) {
            return null;
        }
        int i = 0;
        while (i < udata.length) {
            msr.getData()[i] = udata[i];
            ++i;
        }
        return msr;
    }

    public double[] getData() {
        return this.data;
    }

    public void setData(double[] data) {
        this.data = data;
    }
}

