/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.miniseedutils.steim;

import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.util.Date;

public class MiniSeedRecordHeader
implements Comparable {
    protected String network;
    protected String station;
    protected String locID;
    protected String channel;
    protected double startTime;
    protected double endTime;
    protected int numSamples;
    protected double sampleRate;
    protected String sequenceNumber;
    protected int activeFlag;
    protected int recordLength;
    protected int caliFlag;

    public String getChannelLocator() {
        return String.valueOf(this.network) + "/" + this.station + "/" + this.locID + "/" + this.channel;
    }

    protected static void build(GenericMiniSeedRecord g, MiniSeedRecordHeader msr) {
        msr.setNetwork(g.getNetwork());
        msr.setStation(g.getStation());
        msr.setLocID(g.getLocID());
        msr.setChannel(g.getChannel());
        long ms = g.getStartTime().getTime() / 1000L * 1000L;
        msr.setStartTime((double)(ms / 1000L) + (double)g.getStartTime().getNanos() / 1.0E9);
        long ed_ms = g.getEndTime().getTime() / 1000L * 1000L;
        msr.setEndTime((double)(ed_ms / 1000L) + (double)g.getEndTime().getNanos() / 1.0E9);
        msr.setSampleRate(g.getSampleRate());
        msr.setNumSamples(g.getNumSamples());
        msr.sequenceNumber = g.getSequenceNumber();
        msr.activeFlag = g.getActiveFlag();
        msr.caliFlag = g.getCaliFlag();
        msr.recordLength = g.getRecordLength();
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String chan) {
        this.channel = chan;
    }

    public String getLocID() {
        return this.locID;
    }

    public void setLocID(String locId) {
        this.locID = locId;
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String net) {
        this.network = net;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int sampNum) {
        this.numSamples = sampNum;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(double sampRate) {
        this.sampleRate = sampRate;
    }

    public String getStation() {
        return this.station;
    }

    public void setStation(String sta) {
        this.station = sta;
    }

    public int compareTo(Object obj) {
        MiniSeedRecordHeader msc = (MiniSeedRecordHeader)obj;
        return (int)Math.signum(this.startTime - msc.startTime);
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void setRecordLength(int recLength) {
        this.recordLength = recLength;
    }

    public String toString() {
        return String.valueOf(this.getSequenceNumber()) + " " + this.getNetwork() + "/" + this.getStation() + "/" + this.getLocID() + "/" + this.getChannel() + " " + new Date((long)(this.startTime * 1000.0)) + "\tnsamples " + this.getNumSamples() + " sps " + this.getSampleRate() + " ActiveFlag:" + this.getActiveFlag() + " CaliFlag:" + this.getCaliFlag();
    }

    public int getActiveFlag() {
        return this.activeFlag;
    }

    public void setActiveFlag(int activeFlag) {
        this.activeFlag = activeFlag;
    }

    public int getCaliFlag() {
        return this.caliFlag;
    }

    public void setCaliFlag(int caliFlag) {
        this.caliFlag = caliFlag;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void setEndTime(double endTime) {
        this.endTime = endTime;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }
}

