/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.miniseedutils.steim;

import edu.iris.miniseedutils.steim.AdaptivityControl;
import edu.iris.miniseedutils.steim.CompressedFrame;
import edu.iris.miniseedutils.steim.CompressionContinuity;
import edu.iris.miniseedutils.steim.DecompressionContinuity;
import edu.iris.miniseedutils.steim.GenericDataRecord;
import edu.iris.miniseedutils.steim.GenericDataRecordControl;
import java.io.PrintStream;

public class Steim {
    protected static final boolean STATISTICS = true;
    protected static final int PEEKELEMS = 150;
    protected static final int WORDS_PER_FRAME = 16;
    protected static final int WORD_SIZE = 4;
    protected static final int MAXSAMPPERWORD = 9;
    protected static final int ICONSTCODE = -536870912;
    protected static final int ICONSTMASK = 0x1FFFFFFF;
    protected static final int ICONSTSIGN = 0x10000000;
    protected static final int NOTDIFFERENCE = -939524096;
    protected static final int SECONDDIFF = Integer.MIN_VALUE;
    protected static final int REPLACEMENTMASK = 0x70000000;
    protected static final int UNPACKSIZE = 150;
    protected static final int UNPACKFINAL = 148;
    protected static final int EDF_OK = 0;
    protected static final int EDF_INTEGRESYNC = 1;
    protected static final int EDF_INTEGFAIL = 2;
    protected static final int EDF_SECSUBCODE = 4;
    protected static final int EDF_TWOBLOCK = 8;
    protected static final int EDF_OVERRUN = 16;
    protected static final int EDF_REPLACEMENT = 32;
    protected static final int EDF_LASTERROR = 64;
    protected static final int EDF_COUNTERROR = 128;
    protected static final int EDF_FATAL = 62;
    protected static final int EDF_NONFATAL = 193;
    protected static final int MAXTOTALFRAMESPERRECORD = 64;
    protected static final int GENERICHDRL = 64;
    protected static final int B7X4 = 8;
    protected static final int B9X3 = 24;
    protected static final int B6X5 = 1;
    protected static final int B5X6 = 0;
    protected static final int B5X12 = 0;
    protected static final int B3X20 = 1;
    protected static final int B3X10 = 3;
    protected static final int B2X15 = 2;
    protected static final int B1X30 = 1;
    protected static final int HUGE = Integer.MAX_VALUE;
    protected static final int LARGE = 0x3FFFFFFF;
    protected static final int BIG = 0x1FFFFFFF;
    protected static final int GRAND = 0xFFFFFF;
    protected static final int FAT = 0x7FFFFF;
    protected static final int F8X3 = 0x1000000;
    protected static final int F6X4 = 0x2000000;
    protected static final int F4X6 = 0x3000000;
    protected static final int F3X8 = 0x4000000;
    protected static final int F2X12 = 0x5000000;
    protected static final int F1X24 = 0x6000000;

    public static short makeShort(byte left, byte right) {
        short out = (short)(left << 8);
        out = right < 0 ? (short)(out + (256 + right)) : (short)(out + right);
        return out;
    }

    public static short makeShort(byte left, byte right, boolean swapFlag) {
        short out = swapFlag ? Steim.makeShort(right, left) : Steim.makeShort(left, right);
        return out;
    }

    public static int makeInt(byte leftest, byte left, byte right, byte rightest) {
        short out_left = Steim.makeShort(leftest, left);
        short out_right = Steim.makeShort(right, rightest);
        int out = out_left << 16;
        out = out_right < 0 ? (out += 65536 + out_right) : (out += out_right);
        return out;
    }

    public static int makeInt(byte leftest, byte left, byte right, byte rightest, boolean swapFlag) {
        int out = swapFlag ? Steim.makeInt(rightest, right, left, leftest) : Steim.makeInt(leftest, left, right, rightest);
        return out;
    }

    public static float makeFloat(byte leftest, byte left, byte right, byte rightest) {
        int intVal = Steim.makeInt(leftest, left, right, rightest);
        return Float.intBitsToFloat(intVal);
    }

    public static float makeFloat(byte leftest, byte left, byte right, byte rightest, boolean swapFlag) {
        int intVal = Steim.makeInt(leftest, left, right, rightest, swapFlag);
        return Float.intBitsToFloat(intVal);
    }

    private void endianFlipFrame(int[] framep) {
        int i = 0;
        while (i < 16) {
            framep[i] = Steim.endianflip(framep[i]);
            ++i;
        }
    }

    private static int endianflip(int e) {
        short lshort = (short)(e >> 16);
        short rshort = (short)(e & 0xFFFF);
        byte leftest = (byte)(lshort >> 8);
        byte left = (byte)(lshort & 0xFF);
        byte right = (byte)(rshort >> 8);
        byte rightest = (byte)(rshort & 0xFF);
        return Steim.makeInt(rightest, right, left, leftest);
    }

    /*
     * Unable to fully structure code
     */
    short compressFrame(CompressionContinuity ccp, short difference, short level, short reserve, short flip) {
        compseq = new CompressSeqType[]{new CompressSeqType(1, 4, 4, 1, 0, '\b', 255, 127, 8), new CompressSeqType(2, 2, 8, 2, 0, '\u0010', 65535, 32767, 16), new CompressSeqType(-1, 1, 10, 3, 0, ' ', -1, 0x7FFFFFFF, 32), new CompressSeqType(4, 7, 1, 3, 8, '\u0004', 15, 7, 4), new CompressSeqType(5, 6, 2, 3, 1, '\u0005', 31, 15, 5), new CompressSeqType(6, 5, 3, 3, 0, '\u0006', 63, 31, 6), new CompressSeqType(7, 4, 4, 1, 0, '\b', 255, 127, 8), new CompressSeqType(8, 3, 5, 2, 3, '\n', 1023, 511, 10), new CompressSeqType(9, 2, 7, 2, 2, '\u000f', 32767, 16383, 15), new CompressSeqType(-1, 1, 9, 2, 1, '\u001e', 0x3FFFFFFF, 0x1FFFFFFF, 30), new CompressSeqType(11, 9, 0, 3, 24, '\u0003', 7, 3, 3), new CompressSeqType(12, 7, 1, 3, 8, '\u0004', 15, 7, 4), new CompressSeqType(13, 6, 2, 3, 1, '\u0005', 31, 15, 5), new CompressSeqType(14, 5, 3, 3, 0, '\u0006', 63, 31, 6), new CompressSeqType(15, 4, 4, 1, 0, '\b', 255, 127, 8), new CompressSeqType(16, 3, 5, 2, 3, '\n', 1023, 511, 10), new CompressSeqType(17, 5, 6, 2, 0, '\f', 4095, 2047, 12), new CompressSeqType(18, 2, 7, 2, 2, '\u000f', 32767, 16383, 15), new CompressSeqType(19, 2, 8, 0, 0, '\u0010', 65535, 32767, 16), new CompressSeqType(20, 3, 17, 2, 1, '\u0014', 1048575, 524287, 20), new CompressSeqType(-1, 1, 9, 2, 1, '\u001e', 0x3FFFFFFF, 0x1FFFFFFF, 30), new CompressSeqType(22, 8, 11, 0, 0x1000000, '\u0003', 7, 3, 3), new CompressSeqType(23, 6, 12, 0, 0x2000000, '\u0004', 15, 7, 4), new CompressSeqType(24, 4, 13, 0, 0x3000000, '\u0006', 63, 31, 6), new CompressSeqType(25, 3, 14, 0, 0x4000000, '\b', 255, 127, 8), new CompressSeqType(26, 2, 15, 0, 0x5000000, '\f', 4095, 2047, 12), new CompressSeqType(-1, 1, 16, 0, 0x6000000, '\u0018', 0xFFFFFF, 0x7FFFFF, 24)};
        commonflags = new FlagRepType[]{new FlagRepType(0x15555555, 0x50000000), new FlagRepType(0x2AAAAAAA, 0x60000000), new FlagRepType(0x3FFFFFFF, 0x70000000)};
        diffs = new int[9];
        s = new int[11];
        ctabx = 0;
        ctabhi = 0;
        ctablo = 0;
        ctabw = 0;
        ctabfit = 0;
        flag_word = 0;
        total_in_peek_buffer_at_entry = ccp.peek_total;
        number_of_samples = 0;
        samp_1 = ccp.peeks[ccp.next_out];
        samp_2 = ccp.peeks[(ccp.next_out + 1) % 150];
        if (reserve >= 16) {
            reserve = (short)15;
        }
        block = 1;
        while (block < reserve + 1) {
            if (level < 3) {
                block_code = 0;
                switch (block) {
                    case 1: {
                        if (ccp.peek_total >= 1) {
                            ccp.framebuf.cfp[block] = samp_1;
                            break;
                        }
                        ccp.framebuf.cfp[block] = 0;
                        break;
                    }
                    default: {
                        ccp.framebuf.cfp[block] = 0;
                        break;
                    }
                }
            } else {
                block_code = 3;
                switch (block) {
                    case 1: {
                        if (ccp.peek_total >= 1) {
                            ccp.framebuf.cfp[block] = samp_1 & 0x1FFFFFFF | -536870912;
                            break;
                        }
                        ccp.framebuf.cfp[block] = -939524096;
                        break;
                    }
                    case 2: {
                        if (ccp.peek_total >= 2) {
                            ccp.framebuf.cfp[block] = samp_2 & 0x1FFFFFFF | -536870912;
                            break;
                        }
                        ccp.framebuf.cfp[block] = -939524096;
                        break;
                    }
                    default: {
                        ccp.framebuf.cfp[block] = -939524096;
                    }
                }
            }
            flag_word = (flag_word << 2) + block_code;
            block = (short)(block + 1);
        }
        switch (level) {
            case 3: {
                ctablo = 10;
                ctabhi = 20;
                ctabx = 13;
                break;
            }
            case 2: {
                ctablo = 3;
                ctabhi = 9;
                ctabx = 5;
                break;
            }
            case 1: {
                ctablo = 0;
                ctabhi = 2;
                ctabx = 0;
            }
        }
        while (block < 16) {
            s[0] = ccp.last_2;
            s[1] = ccp.last_1;
            empty = ccp.peek_total <= 0 ? 0 : -1;
            hiscan = 0;
            done = false;
            ctabfit = -1;
            ctabw = ctabx;
            block17: do {
                block65: {
                    sp = compseq[ctabx];
                    t_scan = sp.scan;
                    t_disc = sp.disc;
                    if (ccp.peek_total < t_scan) ** GOTO lbl101
                    if (difference != 1) ** GOTO lbl89
                    while (hiscan < t_scan) {
                        s[hiscan + 2] = ccp.peeks[(ccp.next_out + hiscan) % 150];
                        diffs[hiscan] = s[hiscan + 2] - s[hiscan + 1];
                        hiscan = (short)(hiscan + 1);
                    }
                    break block65;
lbl-1000:
                    // 1 sources

                    {
                        s[hiscan + 2] = ccp.peeks[(ccp.next_out + hiscan) % 150];
                        diffs[hiscan] = s[hiscan + 2] - (s[hiscan + 1] << 1) + s[hiscan];
                        hiscan = (short)(hiscan + 1);
lbl89:
                        // 2 sources

                        ** while (hiscan < t_scan)
                    }
lbl90:
                    // 1 sources

                    break block65;
lbl-1000:
                    // 1 sources

                    {
                        pop = (short)((ccp.next_out + hiscan) % 150);
                        if (pop == ccp.next_in && ccp.peek_total < 150 && empty < 0) {
                            empty = hiscan;
                        }
                        if (empty < 0) {
                            s[hiscan + 2] = ccp.peeks[pop];
                            diffs[hiscan] = difference == 1 ? s[hiscan + 2] - s[hiscan + 1] : s[hiscan + 2] - (s[hiscan + 1] << 1) + s[hiscan];
                        } else {
                            s[hiscan + 2] = 0;
                            diffs[hiscan] = 0;
                        }
                        hiscan = (short)(hiscan + 1);
lbl101:
                        // 2 sources

                        ** while (hiscan < t_scan)
                    }
                }
                if (empty < 0) {
                    i = 0;
                    while (i < t_scan) {
                        if (Math.abs(diffs[i]) > t_disc) {
                            if (ctabfit < 0) {
                                ctabx = sp.next;
                                continue block17;
                            }
                            ctabx = ctabfit;
                            done = true;
                            continue block17;
                        }
                        if (i == t_scan - 1) {
                            if (ctabx > ctabw) {
                                done = true;
                                continue block17;
                            }
                            if (ctabx > ctablo) {
                                ctabfit = ctabx;
                                ctabx = (short)(ctabx - 1);
                                continue block17;
                            }
                            done = true;
                            continue block17;
                        }
                        i = (short)(i + 1);
                    }
                } else {
                    if (empty > 0) {
                        ctabw = ctabx;
                        ctabfit = -1;
                        while (ctabx >= 0 && compseq[ctabx].scan - 1 >= empty) {
                            ctabx = compseq[ctabx].next;
                        }
                        empty = -1;
                        continue;
                    }
                    ctabx = ctabhi;
                    break;
                }
            } while (ctabx >= 0 && !done);
            if (ctabx < 0) break;
            if (block == 15 && (compseq[ctabx].ccVal == 6 || compseq[ctabx].ccVal == 17)) {
                ctabx = compseq[ctabx].next;
            }
            sp = compseq[ctabx];
            t_scan = sp.scan;
            t_mask = sp.mask;
            ccp.last_2 = s[t_scan];
            ccp.last_1 = s[t_scan + 1];
            ccp.peek_total = (short)(ccp.peek_total - t_scan);
            ccp.next_out = (short)((ccp.next_out + t_scan) % 150);
            if (ccp.peek_total < 0) {
                if (level < 3) {
                    block_code = 0;
                    ccp.framebuf.cfp[block] = 0;
                } else {
                    block_code = 3;
                    ccp.framebuf.cfp[block] = -939524096;
                }
            } else {
                ccp.finalVal = ccp.last_1;
                block_code = sp.bc;
                ccp.fits[sp.fit] = ccp.fits[sp.fit] + t_scan;
                i2 = 0;
                accum = sp.cbits;
                switch (sp.ccVal) {
                    case 6: 
                    case 17: {
                        t_halfshift = (char)(sp.shift >> 1);
                        accum = 0;
                        while (i2 < t_scan >> 1) {
                            v0 = i2;
                            i2 = (short)(v0 + 1);
                            accum = accum << sp.shift | t_mask & diffs[v0];
                        }
                        ccp.framebuf.cfp[block] = accum = accum << t_halfshift | (t_mask & diffs[i2]) >> t_halfshift;
                        flag_word = (flag_word << 2) + block_code;
                        block = (short)(block + 1);
                        accum = sp.cbits;
                        v1 = i2;
                        i2 = (short)(v1 + 1);
                        accum = accum << t_halfshift | t_mask >> t_halfshift & diffs[v1];
                    }
                }
                t_shift = sp.shift;
                while (i2 < t_scan) {
                    v2 = i2;
                    i2 = (short)(v2 + 1);
                    accum = accum << t_shift | t_mask & diffs[v2];
                }
                ccp.framebuf.cfp[block] = accum;
            }
            flag_word = (flag_word << 2) + block_code;
            block = (short)(block + 1);
        }
        while (block < 16) {
            if (level < 3) {
                block_code = 0;
                ccp.framebuf.cfp[block] = 0;
            } else {
                block_code = 3;
                ccp.framebuf.cfp[block] = -939524096;
            }
            flag_word = (flag_word << 2) + block_code;
            block = (short)(block + 1);
        }
        diffbit = difference == 1 ? 0 : -2147483648;
        clipped_total = ccp.peek_total;
        if (clipped_total < 0) {
            clipped_total = 0;
        }
        number_of_samples = (short)(total_in_peek_buffer_at_entry - clipped_total);
        ccp.framebuf.cfp[0] = flag_word | diffbit;
        ++ccp.frames;
        if (flip != 0) {
            this.endianFlipFrame(ccp.framebuf.cfp);
        }
        if (reserve >= 15) {
            return 0;
        }
        if (ctabx < 0) {
            if (number_of_samples == 0) {
                return -1;
            }
            return number_of_samples;
        }
        if (level != 3 || ccp.peek_total < 8) {
            return number_of_samples;
        }
        i = 0;
        while (i < 3) {
            if (flag_word == commonflags[i].fword) break;
            i = (short)(i + 1);
        }
        if (i >= 3) {
            return number_of_samples;
        }
        flag_replacement = commonflags[i].repcode;
        s[0] = ccp.last_2;
        s[1] = ccp.last_1;
        i = 0;
        while (i < 8) {
            s[i + 2] = ccp.peeks[(ccp.next_out + i) % 150];
            diffs[i] = difference == 1 ? s[i + 2] - s[i + 1] : s[i + 2] - (s[i + 1] << 1) + s[i];
            i = (short)(i + 1);
        }
        ctabx = 21;
        done = false;
        block28: while (ctabx >= 0 && !done) {
            sp = compseq[ctabx];
            i = 0;
            while (i < sp.scan) {
                if (Math.abs(diffs[i]) > sp.disc) {
                    ctabx = sp.next;
                    continue block28;
                }
                if (i == sp.scan - 1) {
                    done = true;
                    continue block28;
                }
                i = (short)(i + 1);
            }
        }
        if (ctabx < 0) {
            return number_of_samples;
        }
        ++ccp.squeezed_flags;
        sp = compseq[ctabx];
        ccp.last_2 = s[sp.scan];
        ccp.finalVal = ccp.last_1 = s[sp.scan + 1];
        ccp.peek_total = (short)(ccp.peek_total - sp.scan);
        number_of_samples = (short)(number_of_samples + sp.scan);
        ccp.next_out = (short)((ccp.next_out + sp.scan) % 150);
        ccp.fits[sp.fit] = ccp.fits[sp.fit] + sp.scan;
        accum = 0;
        i = 0;
        while (i < sp.scan) {
            accum = accum << sp.shift | sp.mask & diffs[i];
            i = (short)(i + 1);
        }
        flag_word = flag_replacement | sp.cbits | accum & 0xFFFFFF;
        ccp.framebuf.cfp[0] = flip != 0 ? Steim.endianflip(flag_word | diffbit) : flag_word | diffbit;
        return number_of_samples;
    }

    int extend29(int c) {
        if (((c &= 0x1FFFFFFF) & 0x10000000) != 0) {
            c -= 0x20000000;
        }
        return c;
    }

    int unpack(DecompBitType p, int[] wunpk, short start, short stop, int accum) {
        short k = start;
        while (k >= stop) {
            int work = accum & p.mask;
            if ((work & p.hibit) != 0) {
                work -= p.neg;
            }
            wunpk[k] = work;
            accum >>= p.postshift;
            k = (short)(k - 1);
        }
        return accum;
    }

    short decompressFrame(CompressedFrame framep, int[] unpacked, short finalVal, short lastframesize, short level, short recursion, short flip, short ignore, short statcode) {
        short j;
        int accum;
        DecompBitType dcp;
        int subcode;
        int squeezed_flagword;
        FlagRepType[] commonflags = new FlagRepType[]{new FlagRepType(0x15555555, 0x50000000), new FlagRepType(0x2AAAAAAA, 0x60000000), new FlagRepType(0x3FFFFFFF, 0x70000000)};
        DecompBitType[] decomptab = new DecompBitType[]{new DecompBitType(5, '\f', 4095, 2048, 4096), new DecompBitType(1, '\u0000', 0x3FFFFFFF, 0x20000000, 0x40000000), new DecompBitType(2, '\u000f', Short.MAX_VALUE, 16384, 32768), new DecompBitType(3, '\n', 1023, 512, 1024), new DecompBitType(5, '\u0006', 63, 32, 64), new DecompBitType(6, '\u0005', 31, 16, 32), new DecompBitType(7, '\u0004', 15, 8, 16), new DecompBitType(9, '\u0003', 7, 4, 8), new DecompBitType(3, '\u0014', 1048575, 524288, 0x100000), new DecompBitType(4, '\b', 255, 128, 256), new DecompBitType(2, '\u0010', 65535, 32768, 65536), new DecompBitType(1, '\u0000', -1, 0, 0)};
        DecompBitType[] squeezeddecomptab = new DecompBitType[]{new DecompBitType(0, '\u0000', 0, 0, 0), new DecompBitType(8, '\u0003', 7, 4, 8), new DecompBitType(6, '\u0004', 15, 8, 16), new DecompBitType(4, '\u0006', 63, 32, 64), new DecompBitType(3, '\b', 255, 128, 256), new DecompBitType(2, '\f', 4095, 2048, 4096), new DecompBitType(1, '\u0018', 0xFFFFFF, 0x800000, 0x1000000), new DecompBitType(0, '\u0000', 0, 0, 0)};
        short[] flags = new short[16];
        int[] wunpk = new int[9];
        int samp_1 = 0;
        int samp_2 = 0;
        CompressedFrame eframe = new CompressedFrame();
        short scode = 0;
        if (flip != 0) {
            eframe.setFrameArray(framep.getFrameArray());
            framep = eframe;
            this.endianFlipFrame(framep.cfp);
        }
        finalVal = 0;
        statcode = 0;
        int embeddedcount = 0;
        if (recursion == 0) {
            if (lastframesize > 0) {
                unpacked[0] = unpacked[lastframesize];
                unpacked[1] = unpacked[lastframesize + 1];
            } else {
                unpacked[1] = 0;
                unpacked[0] = 0;
            }
        }
        int fp = 0;
        int flag_word = framep.cfp[0];
        int difference = (flag_word & Integer.MIN_VALUE) != 0 ? 2 : 1;
        int i = 0;
        while (i < 3) {
            if ((flag_word & 0x70000000) == commonflags[i].repcode) break;
            i = (short)(i + 1);
        }
        if (i < 3) {
            squeezed_flagword = flag_word;
            flag_word = commonflags[i].fword;
        } else {
            squeezed_flagword = 0;
        }
        i = 15;
        while (i >= 1) {
            flags[i] = (short)(flag_word & 3);
            flag_word >>= 2;
            i = (short)(i - 1);
        }
        short blockindex = 1;
        while (blockindex < 16) {
            short integrate = 0;
            short blockcode = flags[blockindex];
            int block = framep.cfp[blockindex];
            if (level < 3 && blockcode == 0 || level == 3 && block == -939524096) {
                if (level < 3 && ignore < blockindex) {
                    switch (blockindex) {
                        case 1: {
                            samp_1 = block;
                            embeddedcount = 1;
                            break;
                        }
                        case 2: {
                            unpacked[148] = block;
                            finalVal = (short)148;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (level == 3 && blockcode == 3 && (block & 0xE0000000) == -536870912) {
                if (ignore < blockindex) {
                    switch (blockindex) {
                        case 1: {
                            samp_1 = this.extend29(block);
                            embeddedcount = 1;
                            break;
                        }
                        case 2: {
                            samp_2 = this.extend29(block);
                            embeddedcount = 2;
                            break;
                        }
                        case 3: {
                            unpacked[148] = this.extend29(block);
                            finalVal = (short)148;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                subcode = blockcode == 1 ? 9 : (level == 1 && blockcode == 2 || level == 3 && blockcode == 0 ? 10 : (level == 1 && blockcode == 3 ? 11 : (int)((short)((blockcode - 2 << 2) + (block >> 30 & 3)))));
                dcp = decomptab[subcode];
                accum = block;
                if (subcode > 0) {
                    this.unpack(dcp, wunpk, (short)(dcp.samps - 1), (short)0, accum);
                    integrate = dcp.samps;
                } else if (blockindex < 15) {
                    blockindex = (short)(blockindex + 1);
                    int nextblock = framep.cfp[blockindex];
                    short twoblocksubcode = (short)(nextblock >> 30 & 3);
                    switch (twoblocksubcode) {
                        case 0: 
                        case 1: {
                            dcp = decomptab[8 * twoblocksubcode];
                            short halfshift = (short)(dcp.postshift >> 1);
                            short middle = (short)(dcp.samps >> 1);
                            int halfmask = dcp.mask >> halfshift;
                            wunpk[middle] = accum & halfmask;
                            this.unpack(dcp, wunpk, (short)(middle - 1), (short)0, accum >>= halfshift);
                            accum = nextblock;
                            accum = this.unpack(dcp, wunpk, (short)(dcp.samps - 1), (short)(middle + 1), accum);
                            accum = accum & halfmask | wunpk[middle] << halfshift;
                            this.unpack(dcp, wunpk, middle, middle, accum);
                            integrate = dcp.samps;
                            break;
                        }
                        default: {
                            statcode = (short)(statcode | 4);
                            break;
                        }
                    }
                } else {
                    statcode = (short)(statcode | 8);
                }
            }
            if (fp + integrate > 148) {
                statcode = (short)(statcode | 0x10);
            } else if (integrate > 0) {
                if (difference == 1) {
                    j = 0;
                    while (j < integrate) {
                        unpacked[fp + 2] = wunpk[j] + unpacked[fp + 1];
                        fp = (short)(fp + 1);
                        j = (short)(j + 1);
                    }
                } else {
                    j = 0;
                    while (j < integrate) {
                        unpacked[fp + 2] = wunpk[j] + (unpacked[fp + 1] << 1) - unpacked[fp];
                        fp = (short)(fp + 1);
                        j = (short)(j + 1);
                    }
                }
            }
            blockindex = (short)(blockindex + 1);
        }
        if (squeezed_flagword != 0) {
            subcode = squeezed_flagword >> 24 & 7;
            dcp = squeezeddecomptab[subcode];
            if (dcp.samps > 0) {
                if (fp + dcp.samps > 148) {
                    statcode = (short)(statcode | 0x10);
                } else {
                    accum = squeezed_flagword & 0xFFFFFF;
                    this.unpack(dcp, wunpk, (short)(dcp.samps - 1), (short)0, accum);
                    j = 0;
                    while (j < dcp.samps) {
                        unpacked[fp + 2] = difference == 1 ? wunpk[j] + unpacked[fp + 1] : wunpk[j] + (unpacked[fp + 1] << 1) - unpacked[fp];
                        fp = (short)(fp + 1);
                        j = (short)(j + 1);
                    }
                }
            } else {
                statcode = (short)(statcode | 0x20);
            }
        }
        if (embeddedcount >= 1 && unpacked[2] != samp_1 || embeddedcount >= 2 && unpacked[3] != samp_2) {
            if (recursion == 0) {
                if (fp > 0) {
                    if (lastframesize > 0) {
                        statcode = (short)(statcode | 1);
                    }
                    if (difference == 1) {
                        unpacked[1] = unpacked[1] + samp_1 - unpacked[2];
                    } else {
                        if (fp < 2 && embeddedcount < 2) {
                            unpacked[3] = 0;
                            samp_2 = 0;
                        }
                        unpacked[0] = -3 * unpacked[2] + 3 * samp_1 + 2 * unpacked[3] - 2 * samp_2 + unpacked[0];
                        unpacked[1] = unpacked[3] - samp_2 - 2 * unpacked[2] + 2 * samp_1 + unpacked[1];
                    }
                    fp = this.decompressFrame(framep, unpacked, finalVal, (short)0, level, (short)(recursion + 1), (short)0, ignore, scode);
                }
            } else {
                fp = -1;
                statcode = (short)(statcode | 2);
            }
        }
        return (short)fp;
    }

    boolean dfErrorFatal(short statcode, PrintStream ps) {
        if (ps != null) {
            if ((statcode & 0xFF) != 0) {
                ps.println("");
            }
            if ((statcode & 4) != 0) {
                ps.println("decompress frame: illegal secondary subcode spanning two blocks.");
            }
            if ((statcode & 8) != 0) {
                ps.println("decompress frame: illegal two-block code at end of frame.");
            }
            if ((statcode & 0x10) != 0) {
                ps.println("decompress frame: unpacked buffer overrun.");
            }
            if ((statcode & 0x20) != 0) {
                ps.println("decompress frame: illegal flag-word replacement subcode.");
            }
            if ((statcode & 1) != 0) {
                ps.println("decompress frame: expansion error at integration constant check.");
            }
            if ((statcode & 2) != 0) {
                ps.println("decompress frame: expansion failed. frame internally damaged.");
            }
            if ((statcode & 0x40) != 0) {
                ps.println("decompress record: last sample does not agree with decompression.");
            }
            if ((statcode & 0x80) != 0) {
                ps.println("decompress record: sample count disagreement.");
            }
        }
        return (statcode & 0x3E) != 0;
    }

    void fix(CompressionContinuity ccp) {
        int s1 = ccp.peeks[ccp.next_out];
        int s0 = ccp.last_1;
        int diff = s1 - s0;
        if (diff < 0) {
            if (diff < -536870911) {
                diff = -536870911;
            }
        } else if (diff > 0x1FFFFFFF) {
            diff = 0x1FFFFFFF;
        }
        ccp.peeks[ccp.next_out] = s1 = diff + s0;
    }

    void clearCompression(CompressionContinuity ccp, short level) {
        int i = 0;
        while (i < 33) {
            ccp.fits[i] = 0;
            i = (short)(i + 1);
        }
        ccp.squeezed_flags = 0;
        ccp.next_in = 0;
        ccp.peek_total = 0;
        ccp.next_out = 0;
        ccp.last_1 = 0;
        ccp.last_2 = 0;
        ccp.frames = 0;
        switch (level) {
            case 1: {
                ccp.peek_threshold = (short)62;
                break;
            }
            case 2: {
                ccp.peek_threshold = (short)107;
                break;
            }
            case 3: {
                ccp.peek_threshold = (short)145;
            }
        }
    }

    CompressionContinuity initCompression(short level) {
        CompressionContinuity ccp = new CompressionContinuity();
        this.clearCompression(ccp, level);
        return ccp;
    }

    int finalSample(CompressionContinuity ccp) {
        return ccp.finalVal;
    }

    short peekThresholdAvail(CompressionContinuity ccp) {
        return (short)(ccp.peek_total - ccp.peek_threshold);
    }

    short peekContents(CompressionContinuity ccp) {
        return ccp.peek_total;
    }

    int frames(CompressionContinuity ccp) {
        return ccp.frames;
    }

    short blocksPadded(CompressionContinuity ccp) {
        if (ccp.peek_total < 0) {
            return (short)Math.abs(ccp.peek_total);
        }
        return 0;
    }

    short peekWrite(CompressionContinuity ccp, int[] samples, short numwrite) {
        short written = 0;
        int count = 0;
        while (ccp.peek_total < 150 && written < numwrite) {
            ccp.peeks[ccp.next_in] = samples[count++];
            ccp.next_in = (short)((ccp.next_in + 1) % 150);
            ccp.peek_total = (short)(ccp.peek_total + 1);
            written = (short)(written + 1);
        }
        return written;
    }

    void insertConstant(CompressedFrame framep, int sample, short level, short flip, short blockindex, boolean force) {
        if (flip != 0) {
            framep.cfp[blockindex] = Steim.endianflip(framep.cfp[blockindex]);
        }
        if (level < 3) {
            if (force || framep.cfp[blockindex] == 0) {
                framep.cfp[blockindex] = sample;
            }
        } else if (force || framep.cfp[blockindex] == -939524096) {
            framep.cfp[blockindex] = sample & 0x1FFFFFFF | 0xE0000000;
        }
        if (flip != 0) {
            framep.cfp[blockindex] = Steim.endianflip(framep.cfp[blockindex]);
        }
    }

    AdaptivityControl initAdaptivity(short diff, short fpt, short fpp, short level, short flip) {
        AdaptivityControl adp = new AdaptivityControl();
        adp.ccp = this.initCompression(level);
        if (adp.ccp == null) {
            return null;
        }
        adp.bestdiff = 0;
        adp.trials = 0;
        adp.firstframe = 0;
        adp.difference = diff;
        adp.framespertrial = fpt;
        adp.framesperpackage = fpp;
        adp.level = level;
        adp.flip = flip;
        return adp;
    }

    short compressAdaptively(AdaptivityControl adp) {
        short used;
        CompressionContinuity[] saved = new CompressionContinuity[2];
        short reserve = adp.ccp.frames % adp.framesperpackage == adp.firstframe ? (adp.level < 3 ? (short)2 : 3) : (short)0;
        if (adp.level < 3) {
            used = this.compressFrame(adp.ccp, adp.difference, adp.level, reserve, adp.flip);
        } else {
            if (adp.ccp.frames % adp.framesperpackage == adp.firstframe) {
                adp.bestdiff = 0;
                adp.trials = adp.framespertrial;
            }
            if (adp.trials != 0) {
                saved[0] = adp.ccp;
                short used1 = this.compressFrame(adp.ccp, (short)1, (short)3, reserve, adp.flip);
                saved[1] = adp.ccp;
                adp.ccp = saved[0];
                used = this.compressFrame(adp.ccp, (short)2, (short)3, reserve, adp.flip);
                if (used <= used1) {
                    adp.ccp = saved[1];
                    used = used1;
                } else {
                    adp.bestdiff = (short)(adp.bestdiff + 1);
                }
                adp.trials = (short)(adp.trials - 1);
                if (adp.trials == 0) {
                    adp.difference = (short)(2 * adp.bestdiff >= adp.framespertrial ? 2 : 1);
                }
            } else {
                used = this.compressFrame(adp.ccp, adp.difference, (short)3, reserve, adp.flip);
            }
        }
        return used;
    }

    void clearGenericDecompression(DecompressionContinuity dcp) {
        dcp.numdecomp = 0;
        dcp.samp_1 = 0;
        dcp.samp_2 = 0;
    }

    DecompressionContinuity initGenericDecompression() {
        DecompressionContinuity dcp = new DecompressionContinuity();
        this.clearGenericDecompression(dcp);
        return dcp;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    int decompressGenericRecord(GenericDataRecord gdr, int[] udata, short statcode, DecompressionContinuity dcp, short firstframe, int headertotal, short level, short flip, short dataframes) {
        short havefinal;
        int total_in_record;
        int finalsample;
        int[] samples;
        block13: {
            short s;
            int frameIdx;
            short framecount;
            int ignore;
            short dstat;
            short finalVal;
            block12: {
                samples = new int[150];
                finalVal = 0;
                dstat = 0;
                finalsample = 0;
                if (dcp.numdecomp > 0) {
                    samples[dcp.numdecomp] = dcp.samp_1;
                    samples[dcp.numdecomp + 1] = dcp.samp_2;
                }
                total_in_record = 0;
                havefinal = 0;
                ignore = 0;
                statcode = 0;
                framecount = (short)(dataframes - firstframe);
                frameIdx = 0;
                if (!true) break block12;
                s = framecount;
                framecount = (short)(s - 1);
                if (s <= 0) break block13;
            }
            do {
                CompressedFrame framep;
                short thisdecompress;
                if ((thisdecompress = this.decompressFrame(framep = gdr.frames[frameIdx++], samples, finalVal, dcp.numdecomp, level, (short)0, flip, (short)ignore, dstat)) > 0) {
                    dcp.numdecomp = thisdecompress;
                }
                if (this.dfErrorFatal(statcode = (short)(statcode | dstat), null)) {
                    return -1;
                }
                ignore = 2;
                if (level > 2) {
                    ignore = 3;
                }
                havefinal = (short)(havefinal + finalVal);
                if (finalVal > 0) {
                    finalsample = samples[finalVal];
                }
                short i = 1;
                while (i <= thisdecompress) {
                    if (total_in_record >= udata.length) break;
                    udata[total_in_record++] = samples[i + 1];
                    i = (short)(i + 1);
                }
                s = framecount;
                framecount = (short)(s - 1);
            } while (s > 0);
        }
        if (havefinal != 0 && dcp.numdecomp != 0 && finalsample != samples[dcp.numdecomp + 1]) {
            statcode = (short)(statcode | 0x40);
        }
        if (headertotal >= 0 && headertotal != total_in_record) {
            statcode = (short)(statcode | 0x80);
        }
        if (dcp.numdecomp > 0) {
            dcp.samp_1 = samples[dcp.numdecomp];
            dcp.samp_2 = samples[dcp.numdecomp + 1];
        }
        int k = total_in_record;
        while (k < udata.length) {
            udata[k] = 0;
            ++k;
        }
        return total_in_record;
    }

    short compressGenericRecord(GenericDataRecordControl gdp, short firstframe) {
        if (gdp.adp.ccp.frames >= gdp.adp.framesperpackage) {
            return (short)gdp.adp.ccp.frames;
        }
        CompressedFrame framep = gdp.gdr.frames[gdp.adp.ccp.frames];
        short used = this.compressAdaptively(gdp.adp);
        framep.setFrameArray(gdp.adp.ccp.framebuf.getFrameArray());
        if (used > 0) {
            gdp.nsamples += used;
        } else {
            this.fix(gdp.adp.ccp);
        }
        if (gdp.adp.ccp.frames >= gdp.adp.framesperpackage) {
            short blockindex = gdp.adp.level < 3 ? (short)2 : 3;
            this.insertConstant(gdp.gdr.frames[firstframe], this.finalSample(gdp.adp.ccp), gdp.adp.level, gdp.adp.flip, blockindex, false);
        }
        return (short)gdp.adp.ccp.frames;
    }

    int genericRecordSamples(GenericDataRecordControl gdp) {
        return gdp.nsamples;
    }

    void clearGenericCompression(GenericDataRecordControl gdp, short framesreserved) {
        gdp.nsamples = 0;
        gdp.adp.ccp.frames = framesreserved;
        gdp.adp.firstframe = framesreserved;
    }

    GenericDataRecordControl initGenericCompression(short diff, short fpt, short fpp, short level, short flip, GenericDataRecord gdr) {
        GenericDataRecordControl gdp = new GenericDataRecordControl();
        gdp.adp = this.initAdaptivity(diff, fpt, fpp, level, flip);
        if (gdp.adp == null) {
            return null;
        }
        gdp.gdr = gdr;
        return gdp;
    }

    private static interface CodeType {
        public static final int c9x3 = 0;
        public static final int c7x4 = 1;
        public static final int c6x5 = 2;
        public static final int c5x6 = 3;
        public static final int c4x8 = 4;
        public static final int c3x10 = 5;
        public static final int c5x12 = 6;
        public static final int c2x15 = 7;
        public static final int c2x16 = 8;
        public static final int c1x30 = 9;
        public static final int c1x32 = 10;
        public static final int c8x3 = 11;
        public static final int c6x4 = 12;
        public static final int c4x6 = 13;
        public static final int c3x8 = 14;
        public static final int c2x12 = 15;
        public static final int c1x24 = 16;
        public static final int c3x20 = 17;
    }

    private class CompressSeqType {
        short next;
        short scan;
        int ccVal;
        int bc;
        int cbits;
        char shift;
        int mask;
        int disc;
        short fit;

        public CompressSeqType() {
        }

        public CompressSeqType(int next, int scan, int ccVal, int bc, int cbits, char shift, int mask, int disc, short fit) {
            this.next = (short)next;
            this.scan = (short)scan;
            this.ccVal = ccVal;
            this.bc = bc;
            this.cbits = cbits;
            this.shift = shift;
            this.mask = mask;
            this.disc = disc;
            this.fit = fit;
        }
    }

    private class DecompBitType {
        short samps;
        char postshift;
        int mask;
        int hibit;
        int neg;

        public DecompBitType() {
        }

        public DecompBitType(short samps, char postshift, int mask, int hibit, int neg) {
            this.samps = samps;
            this.postshift = postshift;
            this.mask = mask;
            this.hibit = hibit;
            this.neg = neg;
        }
    }

    private class FlagRepType {
        int fword;
        int repcode;

        public FlagRepType() {
        }

        public FlagRepType(int fword, int repcode) {
            this.fword = fword;
            this.repcode = repcode;
        }
    }
}

