/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedReader;
import java.util.Date;

public class Blockette10
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette10() {
    }

    public Blockette10(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette10(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
    }

    public Blockette10(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        if (paramFlag) {
            Format fmt2_2d = new Format("%2.2d");
            Format fmt3_3d = new Format("%3.3d");
            Format fmt4_4d = new Format("%4.4d");
            Format fmt4_1f = new Format("%04.1f");
            Format fmtvar_str = new Format("%s~");
            blktStr = String.valueOf(blktStr) + fmt4_1f.format((Double)this.get("Format version"));
            blktStr = String.valueOf(blktStr) + fmt2_2d.format((Integer)this.get("Logical record length"));
            blktStr = String.valueOf(blktStr) + fmtvar_str.format(((TimeStamp)this.get("Beginning time")).toSeedString());
            blktStr = String.valueOf(blktStr) + fmtvar_str.format(((TimeStamp)this.get("End time")).toSeedString());
            blktStr = String.valueOf(blktStr) + fmtvar_str.format(((TimeStamp)this.get("Volume time")).toSeedString());
            blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)this.get("Originating organization"));
            blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)this.get("Label"));
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 4;
            this.put("Format version", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 4) + 2;
            this.put("Logical record length", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = blktInfo.substring(sIdx += 2).indexOf(126) + sIdx;
            this.put("Beginning time", TimeStamp.buildTimestamp(blktInfo.substring(sIdx, eIdx).trim()));
            sIdx = eIdx + 1;
            eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
            if (sIdx != eIdx) {
                this.put("End time", TimeStamp.buildTimestamp(blktInfo.substring(sIdx, eIdx).trim()));
            } else {
                this.put("End time", TimeStamp.buildTimestamp("99999999999.9999"));
            }
            sIdx = eIdx + 1;
            eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
            this.put("Volume time", TimeStamp.buildTimestamp(blktInfo.substring(sIdx, eIdx).trim()));
            sIdx = eIdx + 1;
            eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
            this.put("Originating organization", blktInfo.substring(sIdx, eIdx).trim());
            sIdx = eIdx + 1;
            eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
            this.put("Label", blktInfo.substring(sIdx, eIdx).trim());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Format version");
        this.paramOutputType.put("Format version", "%.1f");
        this.paramInputType.put("Format version", new Integer(2));
        this.respFieldNames.add("Format version");
        this.paramLookup.put("04", "Logical record length");
        this.paramOutputType.put("Logical record length", "%d");
        this.paramInputType.put("Logical record length", new Integer(1));
        this.respFieldNames.add("Logical record length");
        this.paramLookup.put("05", "Beginning time");
        this.paramOutputType.put("Beginning time", "%s");
        this.paramInputType.put("Beginning time", new Integer(3));
        this.respFieldNames.add("Beginning time");
        this.paramLookup.put("06", "End time");
        this.paramOutputType.put("End time", "%s");
        this.paramInputType.put("End time", new Integer(3));
        this.respFieldNames.add("End time");
        this.paramLookup.put("07", "Volume time");
        this.paramOutputType.put("Volume time", "%s");
        this.paramInputType.put("Volume time", new Integer(3));
        this.respFieldNames.add("Volume time");
        this.paramLookup.put("08", "Originating organization");
        this.paramOutputType.put("Originating organization", "%s");
        this.paramInputType.put("Originating organization", new Integer(0));
        this.respFieldNames.add("Originating organization");
        this.paramLookup.put("09", "Label");
        this.paramOutputType.put("Label", "%s");
        this.paramInputType.put("Label", new Integer(0));
        this.respFieldNames.add("Label");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b010 = TestData.test_b010a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        Blockette10 test_val = new Blockette10(test_b010, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b010.length());
        System.out.println(test_val.toString().compareTo(test_b010) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        Date dateStart = new Date();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        Date dateEnd = new Date();
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        long elapsed_time = dateEnd.getTime() - dateStart.getTime();
        System.out.println("hashed " + test_val.toString().length() + " characters in " + elapsed_time + " milliseconds");
    }
}

