/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.seedutils.DataBlockette;
import edu.iris.seedutils.DataBlocketteHeader;
import edu.iris.seedutils.SeedDataRecord;

public class Blockette100
extends DataBlockette {
    public Blockette100(DataBlocketteHeader header, byte[] data) {
        super(header, data);
    }

    public float getSampleRate() {
        float srate = this.converter.makeFloat(this.blktBytes[4], this.blktBytes[5], this.blktBytes[6], this.blktBytes[7]);
        if (this.byteSwapNeeded()) {
            srate = this.converter.swapFloat(srate);
        }
        return srate;
    }

    public byte getFlags() {
        return this.blktBytes[8];
    }

    public byte[] getReserved() {
        return new String(this.blktBytes).substring(9).getBytes();
    }

    public String toString() {
        String srateString = "                  actual sample rate: " + this.getSampleRate();
        String flagString = "                               flags: to be defined - " + SeedDataRecord.buildFlagString(this.getFlags());
        String reservedString = "                       reserved[0-2]:";
        byte[] reservedBytes = this.getReserved();
        int i = 0;
        while (i < reservedBytes.length) {
            reservedString = String.valueOf(reservedString) + " " + SeedDataRecord.buildFlagString(reservedBytes[i]);
            ++i;
        }
        return String.valueOf(this.blktHeader.toString()) + "\n" + srateString + "\n" + flagString + "\n" + reservedString;
    }
}

