/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.seedutils.DataBlockette;
import edu.iris.seedutils.DataBlocketteHeader;
import edu.iris.seedutils.SeedDataRecord;

public class Blockette1000
extends DataBlockette {
    public Blockette1000(DataBlocketteHeader header, byte[] data) {
        super(header, data);
    }

    public short getEncodingFormat() {
        return this.blktBytes[4];
    }

    public short getWordOrder() {
        return this.blktBytes[5];
    }

    public short getRecordLength() {
        return this.blktBytes[6];
    }

    public byte getReserved() {
        return this.blktBytes[7];
    }

    public String toString() {
        short formatCode = this.getEncodingFormat();
        String dataFormat = "                     encoding format: ";
        switch (formatCode) {
            case 1: {
                dataFormat = String.valueOf(dataFormat) + "16 bit integers";
                break;
            }
            case 2: {
                dataFormat = String.valueOf(dataFormat) + "24 bit integers";
                break;
            }
            case 3: {
                dataFormat = String.valueOf(dataFormat) + "32 bit integers";
                break;
            }
            case 4: {
                dataFormat = String.valueOf(dataFormat) + "IEEE floating point";
                break;
            }
            case 5: {
                dataFormat = String.valueOf(dataFormat) + "IEEE double precision floating point";
                break;
            }
            case 10: {
                dataFormat = String.valueOf(dataFormat) + "STEIM (1) Compression";
                break;
            }
            case 11: {
                dataFormat = String.valueOf(dataFormat) + "STEIM (2) Compression";
                break;
            }
            case 12: {
                dataFormat = String.valueOf(dataFormat) + "GEOSCOPE Multiplexed Format 24 bit integer";
                break;
            }
            case 13: {
                dataFormat = String.valueOf(dataFormat) + "GEOSCOPE Multiplexed Format 16 bit gain-ranged, 3 bit exponent";
                break;
            }
            case 14: {
                dataFormat = String.valueOf(dataFormat) + "GEOSCOPE Multiplexed Format 16 bit gain-ranged, 4 bit exponent";
                break;
            }
            case 15: {
                dataFormat = String.valueOf(dataFormat) + "US National Network compression";
                break;
            }
            case 16: {
                dataFormat = String.valueOf(dataFormat) + "CDSN 16 bit gain ranged";
                break;
            }
            case 17: {
                dataFormat = String.valueOf(dataFormat) + "Graefenberg 16 bit gain ranged";
                break;
            }
            case 18: {
                dataFormat = String.valueOf(dataFormat) + "IPG - Strasbourg 16 bit gain ranged";
                break;
            }
            case 19: {
                dataFormat = String.valueOf(dataFormat) + "STEIM (3) Compression";
                break;
            }
            case 30: {
                dataFormat = String.valueOf(dataFormat) + "SRO Format";
                break;
            }
            case 31: {
                dataFormat = String.valueOf(dataFormat) + "HGLP Format";
                break;
            }
            case 32: {
                dataFormat = String.valueOf(dataFormat) + "DWWSSN gain ranged format";
                break;
            }
            case 33: {
                dataFormat = String.valueOf(dataFormat) + "RSTN 16 bit gain ranged";
                break;
            }
            default: {
                dataFormat = String.valueOf(dataFormat) + "Unrecognized Data Format (" + formatCode + ")";
            }
        }
        String wordOrder = "                          word order: ";
        wordOrder = this.getWordOrder() == 1 ? String.valueOf(wordOrder) + "68000/SPARC word order" : String.valueOf(wordOrder) + "VAX/8086 word order";
        String recordLength = "                  data record length: " + this.getRecordLength();
        String reservedString = "                            reserved: " + SeedDataRecord.buildFlagString(this.getReserved());
        return String.valueOf(this.blktHeader.toString()) + "\n" + dataFormat + "\n" + wordOrder + "\n" + recordLength + "\n" + reservedString;
    }
}

