/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import java.io.BufferedReader;
import java.util.ArrayList;

public class Blockette30
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette30() {
    }

    public Blockette30(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette30(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
        this.checkNumParams();
    }

    public Blockette30(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
        this.checkNumParams();
    }

    void checkNumParams() throws ParseStageException {
        ArrayList decoderKeys = (ArrayList)this.get("Decoder keys");
        if (((Integer)this.get("Number of decoder keys")).intValue() != decoderKeys.size()) {
            throw new ParseStageException("'Number of decoder keys' found (" + decoderKeys.size() + " != 'Number of decoder keys' in blockette (" + (Integer)this.get("Number of decoder keys") + ")");
        }
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        Format fmt2_2d = new Format("%2.2d");
        Format fmt3_3d = new Format("%3.3d");
        Format fmt4_4d = new Format("%4.4d");
        Format fmtvar_str = new Format("%s~");
        if (paramFlag) {
            blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)this.get("Data format name"));
            blktStr = String.valueOf(blktStr) + fmt4_4d.format((Integer)this.get("Data format ID"));
            blktStr = String.valueOf(blktStr) + fmt3_3d.format((Integer)this.get("Data family type"));
            int nkeys = (Integer)this.get("Number of decoder keys");
            blktStr = String.valueOf(blktStr) + fmt2_2d.format(nkeys);
        }
        if (listParamFlag) {
            ArrayList tmpList = (ArrayList)this.get("Decoder keys");
            int i = 0;
            while (i < tmpList.size()) {
                blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)tmpList.get(i));
                ++i;
            }
        }
        if (paramFlag) {
            returnVal = fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        } else {
            returnVal = String.valueOf(returnVal) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            ArrayList tmpList = (ArrayList)this.get("Decoder keys");
            tmpList.clear();
            int sIdx = 0;
            int eIdx = sIdx + 3;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = blktInfo.substring(sIdx += 4).indexOf(126) + sIdx;
            this.put("Data format name", blktInfo.substring(sIdx, eIdx).trim());
            sIdx = eIdx + 1;
            eIdx = sIdx + 4;
            this.put("Data format ID", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 4) + 3;
            this.put("Data family type", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 2;
            Integer numKeys = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            int nkeys = numKeys;
            this.put("Number of decoder keys", numKeys);
            eIdx = blktInfo.substring(sIdx += 2).indexOf(126) + sIdx;
            int i = 0;
            while (i < nkeys) {
                tmpList.add(blktInfo.substring(sIdx, eIdx).trim());
                sIdx = eIdx + 1;
                eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
                ++i;
            }
            this.put("Decoder keys", tmpList);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Data format name");
        this.paramOutputType.put("Data format name", "%s");
        this.paramInputType.put("Data format name", new Integer(0));
        this.respFieldNames.add("Data format name");
        this.paramLookup.put("04", "Data format ID");
        this.paramOutputType.put("Data format ID", "%d");
        this.paramInputType.put("Data format ID", new Integer(1));
        this.respFieldNames.add("Data format ID");
        this.idxFieldNames = "Data format ID";
        this.paramLookup.put("05", "Data family type");
        this.paramOutputType.put("Data family type", "%d");
        this.paramInputType.put("Data family type", new Integer(1));
        this.respFieldNames.add("Data family type");
        this.paramLookup.put("06", "Number of decoder keys");
        this.paramOutputType.put("Number of decoder keys", "%d");
        this.paramInputType.put("Number of decoder keys", new Integer(1));
        this.respFieldNames.add("Number of decoder keys");
        this.multiParamLookup.put("07", "Decoder keys");
        this.multiParamOutputType.put("Decoder keys", "%s");
        this.multiParamInputType.put("Decoder keys", new Integer(0));
        this.multiParamOutputTag.put("Decoder keys", "Key");
        this.respFieldNames.add("Decoder keys");
        this.put("Decoder keys", new ArrayList());
    }

    public String objToCompString() {
        String lclString = this.toString();
        int sIdx = 7;
        int eIdx = lclString.substring(sIdx).indexOf(126) + sIdx;
        return String.valueOf(lclString.substring(sIdx, eIdx + 1)) + lclString.substring(eIdx + 5);
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        int mapType = 4;
        Format fmt3_3d = new Format("%3.3d");
        Format fmt4_4d = new Format("%4.4d");
        String compVal = fmt3_3d.format(30);
        int sIdx = 0;
        int eIdx = abbrev.substring(sIdx).indexOf(126) + sIdx;
        compVal = String.valueOf(compVal) + fmt4_4d.format(abbrev.length() + 7 + 4) + abbrev.substring(sIdx, eIdx + 1) + fmt4_4d.format(0) + abbrev.substring(eIdx + 1);
        this.setLookupMap(lm);
        this.fromString(compVal);
    }

    public static void main(String[] args) {
        String test_b030 = TestData.test_b030a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        Blockette30 test_val = new Blockette30(test_b030, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.print("matches '" + test_b030 + "'?  ");
        System.out.println(test_val.toString().compareTo(test_b030) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        System.out.println("Coefficient Values Hash to value of: " + test_val.getListParamElfHash());
    }
}

