/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.Blockette34;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

public class Blockette31
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette31() {
    }

    public Blockette31(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette31(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
    }

    public Blockette31(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        Format fmt3_3d = new Format("%3.3d");
        Format fmt4_4d = new Format("%4.4d");
        Format fmt1s = new Format("%1s");
        Format fmtvar_str = new Format("%s~");
        if (paramFlag) {
            blktStr = String.valueOf(blktStr) + fmt4_4d.format((Integer)this.get("Comment lookup"));
            blktStr = String.valueOf(blktStr) + fmt1s.format((String)this.get("Comment class"));
            blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)this.get("Comment description"));
            int mapType = 8;
            Blockette34 unitsAbbrev = (Blockette34)this.get("Comment units");
            if (unitsAbbrev != null) {
                int lookupVal = this.lookupMap.getLookup(mapType, unitsAbbrev);
                blktStr = String.valueOf(blktStr) + fmt3_3d.format(lookupVal);
            } else {
                blktStr = String.valueOf(blktStr) + fmt3_3d.format(0);
            }
            returnVal = fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            Blockette34 unitsAbbrev;
            int sIdx = 0;
            int eIdx = sIdx + 3;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 4;
            this.put("Comment lookup", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 4) + 1;
            this.put("Comment class", blktInfo.substring(sIdx, eIdx).trim());
            eIdx = blktInfo.substring(++sIdx).indexOf(126) + sIdx;
            this.put("Comment description", blktInfo.substring(sIdx, eIdx).trim());
            sIdx = eIdx + 1;
            eIdx = sIdx + 3;
            Integer lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            if (lookupVal > 0) {
                int mapType = 8;
                unitsAbbrev = (Blockette34)this.lookupMap.getMatch(mapType, lookupVal);
            } else {
                unitsAbbrev = null;
            }
            this.put("Comment units", unitsAbbrev);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Comment lookup");
        this.paramOutputType.put("Comment lookup", "%d");
        this.paramInputType.put("Comment lookup", new Integer(1));
        this.respFieldNames.add("Comment lookup");
        this.idxFieldNames = "Comment lookup";
        this.paramLookup.put("04", "Comment class");
        this.paramOutputType.put("Comment class", "%s");
        this.paramInputType.put("Comment class", new Integer(0));
        this.respFieldNames.add("Comment class");
        this.paramLookup.put("05", "Comment description");
        this.paramOutputType.put("Comment description", "%s");
        this.paramInputType.put("Comment description", new Integer(0));
        this.respFieldNames.add("Comment description");
        this.paramLookup.put("06", "Comment units");
        this.paramOutputType.put("Comment units", "%s");
        this.paramInputType.put("Comment units", new Integer(8));
        this.respFieldNames.add("Comment units");
    }

    public String objToCompString() {
        String lclString = this.toString();
        int sIdx = 11;
        return lclString.substring(sIdx);
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        Format fmt4_4d = new Format("%4.4d");
        Format fmt3_3d = new Format("%3.3d");
        String lclString = fmt3_3d.format(31);
        lclString = String.valueOf(lclString) + fmt4_4d.format(abbrev.length() + 11) + fmt4_4d.format(0) + abbrev;
        this.setLookupMap(lm);
        this.fromString(lclString);
    }

    public static void main(String[] args) {
        String test_b031 = TestData.test_b031b;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        String unitsStr = "SECS - Period in Seconds";
        Blockette34 unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(4), unitsVal);
        Blockette31 test_val = new Blockette31(test_b031, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.print("matches '" + test_b031 + "'?  ");
        System.out.println(test_val.toString().compareTo(test_b031) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        System.out.println("Coefficient Values Hash to value of: " + test_val.getListParamElfHash());
        try {
            String fileSep = System.getProperty("file.separator");
            String infile = "test-files" + fileSep + "commdescblkt.resp";
            BufferedReader rd = new BufferedReader(new InputStreamReader(new FileInputStream(infile)));
            Blockette31 test_val2 = new Blockette31();
            StandaloneLookupMap lm2 = new StandaloneLookupMap();
            test_val2.setLookupMap(lm2);
            test_val2.parseResp(31, rd);
            System.out.println("-------- test #3 --------");
            System.out.println(test_val2);
            test_val2.echoResp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

