/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import java.io.BufferedReader;

public class Blockette32
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette32() {
    }

    public Blockette32(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette32(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
    }

    public Blockette32(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        Format fmt2_2d = new Format("%2.2d");
        Format fmt3_3d = new Format("%3.3d");
        Format fmt4_4d = new Format("%4.4d");
        Format fmtvar_str = new Format("%s~");
        if (paramFlag) {
            blktStr = String.valueOf(blktStr) + fmt2_2d.format((Integer)this.get("Source lookup code"));
            blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)this.get("Name of publication/author"));
            blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)this.get("Date published/catalog"));
            blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)this.get("Publisher name"));
            returnVal = fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            int sIdx = 0;
            int eIdx = sIdx + 3;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 2;
            this.put("Source lookup code", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = blktInfo.substring(sIdx += 2).indexOf(126) + sIdx;
            this.put("Name of publication/author", blktInfo.substring(sIdx, eIdx).trim());
            sIdx = eIdx + 1;
            eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
            this.put("Date published/catalog", blktInfo.substring(sIdx, eIdx).trim());
            sIdx = eIdx + 1;
            eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
            this.put("Publisher name", blktInfo.substring(sIdx, eIdx).trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Source lookup code");
        this.paramOutputType.put("Source lookup code", "%d");
        this.paramInputType.put("Source lookup code", new Integer(1));
        this.respFieldNames.add("Source lookup code");
        this.idxFieldNames = "Source lookup code";
        this.paramLookup.put("04", "Name of publication/author");
        this.paramOutputType.put("Name of publication/author", "%s");
        this.paramInputType.put("Name of publication/author", new Integer(0));
        this.respFieldNames.add("Name of publication/author");
        this.paramLookup.put("05", "Date published/catalog");
        this.paramOutputType.put("Date published/catalog", "%s");
        this.paramInputType.put("Date published/catalog", new Integer(0));
        this.respFieldNames.add("Date published/catalog");
        this.paramLookup.put("06", "Publisher name");
        this.paramOutputType.put("Publisher name", "%s");
        this.paramInputType.put("Publisher name", new Integer(0));
        this.respFieldNames.add("Publisher name");
    }

    public String objToCompString() {
        Format fmt4_4d = new Format("%4.4d");
        String lclString = this.toString();
        int sIdx = 9;
        return lclString.substring(sIdx);
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        int mapType = 5;
        Format fmt2_2d = new Format("%2.2d");
        Format fmt3_3d = new Format("%3.3d");
        Format fmt4_4d = new Format("%4.4d");
        String compVal = fmt3_3d.format(32);
        compVal = String.valueOf(compVal) + fmt4_4d.format(abbrev.length() + 9) + fmt2_2d.format(0) + abbrev;
        this.setLookupMap(lm);
        this.fromString(compVal);
    }

    public static void main(String[] args) {
        String test_b032 = TestData.test_b032a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        Blockette32 test_val = new Blockette32(test_b032, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.print("matches '" + test_b032 + "'?  ");
        System.out.println(test_val.toString().compareTo(test_b032) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        System.out.println("Coefficient Values Hash to value of: " + test_val.getListParamElfHash());
    }
}

