/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import java.io.BufferedReader;

public class Blockette33
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette33() {
    }

    public Blockette33(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette33(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
    }

    public Blockette33(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        Format fmt3_3d = new Format("%3.3d");
        Format fmt4_4d = new Format("%4.4d");
        Format fmtvar_str = new Format("%s~");
        if (paramFlag) {
            blktStr = String.valueOf(blktStr) + fmt3_3d.format((Integer)this.get("Abbrev lookup code"));
            blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)this.get("Abbrev description"));
            returnVal = fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            int sIdx = 0;
            int eIdx = sIdx + 3;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 3;
            this.put("Abbrev lookup code", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = blktInfo.substring(sIdx += 3).indexOf(126) + sIdx;
            this.put("Abbrev description", blktInfo.substring(sIdx, eIdx).trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Abbrev lookup code");
        this.paramOutputType.put("Abbrev lookup code", "%d");
        this.paramInputType.put("Abbrev lookup code", new Integer(1));
        this.respFieldNames.add("Abbrev lookup code");
        this.paramLookup.put("04", "Abbrev description");
        this.paramOutputType.put("Abbrev description", "%s");
        this.paramInputType.put("Abbrev description", new Integer(0));
        this.respFieldNames.add("Abbrev description");
    }

    public String objToCompString() {
        return (String)this.get("Abbrev description");
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        int mapType = 7;
        this.setLookupMap(lm);
        this.put("Abbrev description", abbrev);
        this.put("Abbrev lookup code", new Integer(0));
        this.setType(33);
    }

    public static void main(String[] args) {
        String test_b033 = TestData.test_b033a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        Blockette33 test_val = new Blockette33(test_b033, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.print("matches '" + test_b033 + "'?  ");
        System.out.println(test_val.toString().compareTo(test_b033) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        System.out.println("Coefficient Values Hash to value of: " + test_val.getListParamElfHash());
    }
}

