/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.Blockette33;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Date;

public class Blockette50
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette50() {
    }

    public Blockette50(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette50(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
    }

    public Blockette50(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        if (paramFlag) {
            Format fmt1s = new Format("%1s");
            Format fmt2s = new Format("%-2s");
            Format fmt5s = new Format("%-5s");
            Format fmt2_2d = new Format("%2.2d");
            Format fmt3_3d = new Format("%3.3d");
            Format fmt4_4d = new Format("%4.4d");
            Format fmt5_5d = new Format("%5.5d");
            Format fmt7_1f = new Format("%7.1f");
            Format fmt10_6f = new Format("%10.6f");
            Format fmt11_6f = new Format("%11.6f");
            Format fmtvar_str = new Format("%s~");
            blktStr = String.valueOf(blktStr) + fmt5s.format((String)this.get("Station"));
            blktStr = String.valueOf(blktStr) + fmt10_6f.format((Double)this.get("Latitude (degrees)"));
            blktStr = String.valueOf(blktStr) + fmt11_6f.format((Double)this.get("Longitude (degrees)"));
            blktStr = String.valueOf(blktStr) + fmt7_1f.format((Double)this.get("Elevation (m)"));
            blktStr = String.valueOf(blktStr) + fmt4_4d.format((Integer)this.get("Number of channels"));
            blktStr = String.valueOf(blktStr) + fmt3_3d.format((Integer)this.get("Number of station comments"));
            blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)this.get("Site name"));
            Blockette33 genAbbrev = (Blockette33)this.get("Network name");
            int mapType = 7;
            int lookupVal = this.lookupMap.getLookup(mapType, genAbbrev);
            blktStr = String.valueOf(blktStr) + fmt3_3d.format(lookupVal);
            blktStr = String.valueOf(blktStr) + fmt4_4d.format((Integer)this.get("32-Bit word order"));
            blktStr = String.valueOf(blktStr) + fmt2_2d.format((Integer)this.get("16-Bit word order"));
            blktStr = String.valueOf(blktStr) + fmtvar_str.format(((TimeStamp)this.get("Start date")).toSeedString());
            String tmpStr = ((TimeStamp)this.get("End date")).toSeedString();
            blktStr = tmpStr.compareTo("5138,320,09:46:39.9999") == 0 ? String.valueOf(blktStr) + fmtvar_str.format("") : String.valueOf(blktStr) + fmtvar_str.format(tmpStr);
            blktStr = String.valueOf(blktStr) + fmt1s.format((String)this.get("Update flag"));
            blktStr = String.valueOf(blktStr) + fmt2s.format((String)this.get("Network"));
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 5;
            this.put("Station", blktInfo.substring(sIdx, eIdx).trim());
            eIdx = (sIdx += 5) + 10;
            this.put("Latitude (degrees)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 10) + 11;
            this.put("Longitude (degrees)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 11) + 7;
            this.put("Elevation (m)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 7) + 4;
            String tmpString = blktInfo.substring(sIdx, eIdx).trim();
            if (tmpString == null || tmpString.length() == 0) {
                tmpString = "0";
            }
            this.put("Number of channels", new Integer(tmpString));
            eIdx = (sIdx += 4) + 3;
            tmpString = blktInfo.substring(sIdx, eIdx).trim();
            if (tmpString == null || tmpString.length() == 0) {
                tmpString = "0";
            }
            this.put("Number of station comments", new Integer(tmpString));
            eIdx = blktInfo.substring(sIdx += 3).indexOf(126) + sIdx;
            this.put("Site name", blktInfo.substring(sIdx, eIdx).trim());
            sIdx = eIdx + 1;
            eIdx = sIdx + 3;
            Integer lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            int mapType = 7;
            Blockette33 genAbbrev = (Blockette33)this.lookupMap.getMatch(mapType, lookupVal);
            this.put("Network name", genAbbrev);
            eIdx = (sIdx += 3) + 4;
            this.put("32-Bit word order", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 4) + 2;
            this.put("16-Bit word order", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = blktInfo.substring(sIdx += 2).indexOf(126) + sIdx;
            this.put("Start date", TimeStamp.buildTimestamp(blktInfo.substring(sIdx, eIdx).trim()));
            sIdx = eIdx + 1;
            eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
            if (sIdx != eIdx) {
                tmpString = blktInfo.substring(sIdx, eIdx).trim();
                if (tmpString.length() == 0) {
                    this.put("End date", TimeStamp.buildTimestamp("99999999999.9999"));
                } else {
                    this.put("End date", TimeStamp.buildTimestamp(tmpString));
                }
            } else {
                this.put("End date", TimeStamp.buildTimestamp("99999999999.9999"));
            }
            sIdx = eIdx + 1;
            eIdx = sIdx + 1;
            this.put("Update flag", blktInfo.substring(sIdx, eIdx).trim());
            eIdx = ++sIdx + 2;
            this.put("Network", blktInfo.substring(sIdx, eIdx).trim());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Station");
        this.paramOutputType.put("Station", "%s");
        this.paramInputType.put("Station", new Integer(0));
        this.respFieldNames.add("Station");
        this.paramLookup.put("04", "Latitude (degrees)");
        this.paramOutputType.put("Latitude (degrees)", "%10.6f");
        this.paramInputType.put("Latitude (degrees)", new Integer(2));
        this.respFieldNames.add("Latitude (degrees)");
        this.paramLookup.put("05", "Longitude (degrees)");
        this.paramOutputType.put("Longitude (degrees)", "%11.6f");
        this.paramInputType.put("Longitude (degrees)", new Integer(2));
        this.respFieldNames.add("Longitude (degrees)");
        this.paramLookup.put("06", "Elevation (m)");
        this.paramOutputType.put("Elevation (m)", "%7.1f");
        this.paramInputType.put("Elevation (m)", new Integer(2));
        this.respFieldNames.add("Elevation (m)");
        this.paramLookup.put("07", "Number of channels");
        this.paramOutputType.put("Number of channels", "%d");
        this.paramInputType.put("Number of channels", new Integer(1));
        this.respFieldNames.add("Number of channels");
        this.paramLookup.put("08", "Number of station comments");
        this.paramOutputType.put("Number of station comments", "%d");
        this.paramInputType.put("Number of station comments", new Integer(1));
        this.respFieldNames.add("Number of station comments");
        this.paramLookup.put("09", "Site name");
        this.paramOutputType.put("Site name", "%s");
        this.paramInputType.put("Site name", new Integer(0));
        this.respFieldNames.add("Site name");
        this.paramLookup.put("10", "Network name");
        this.paramOutputType.put("Network name", "%s");
        this.paramInputType.put("Network name", new Integer(7));
        this.respFieldNames.add("Network name");
        this.paramLookup.put("11", "32-Bit word order");
        this.paramOutputType.put("32-Bit word order", "%d");
        this.paramInputType.put("32-Bit word order", new Integer(1));
        this.respFieldNames.add("32-Bit word order");
        this.paramLookup.put("12", "16-Bit word order");
        this.paramOutputType.put("16-Bit word order", "%d");
        this.paramInputType.put("16-Bit word order", new Integer(1));
        this.respFieldNames.add("16-Bit word order");
        this.paramLookup.put("13", "Start date");
        this.paramOutputType.put("Start date", "%s");
        this.paramInputType.put("Start date", new Integer(3));
        this.respFieldNames.add("Start date");
        this.paramLookup.put("14", "End date");
        this.paramOutputType.put("End date", "%s");
        this.paramInputType.put("End date", new Integer(3));
        this.respFieldNames.add("End date");
        this.paramLookup.put("15", "Update flag");
        this.paramOutputType.put("Update flag", "%s");
        this.paramInputType.put("Update flag", new Integer(0));
        this.respFieldNames.add("Update flag");
        this.paramLookup.put("16", "Network");
        this.paramOutputType.put("Network", "%s");
        this.paramInputType.put("Network", new Integer(0));
        this.respFieldNames.add("Network");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b050 = TestData.test_b050a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        String genStr = "(GSN) Global Seismograph Network (IRIS/IDA)";
        Blockette33 genVal = new Blockette33();
        genVal.compStringToObj(genStr, lm);
        lm.setLookup(7, new Integer(7), genVal);
        Blockette50 test_val = new Blockette50(test_b050, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b050.length());
        System.out.println(test_val.toString().compareTo(test_b050) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        Date dateStart = new Date();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        Date dateEnd = new Date();
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        long elapsed_time = dateEnd.getTime() - dateStart.getTime();
        System.out.println("hashed " + test_val.toString().length() + " characters in " + elapsed_time + " milliseconds");
        try {
            String fileSep = System.getProperty("file.separator");
            String infile = "test-files" + fileSep + "stablkt.resp";
            BufferedReader rd = new BufferedReader(new InputStreamReader(new FileInputStream(infile)));
            StandaloneLookupMap lm2 = new StandaloneLookupMap();
            Blockette50 test_val2 = new Blockette50(rd, lm2, 50);
            System.out.println("-------- test #3 --------");
            System.out.println(test_val2);
            test_val2.echoResp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

