/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.Blockette31;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Date;

public class Blockette51
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette51() {
    }

    public Blockette51(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette51(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
    }

    public Blockette51(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        if (paramFlag) {
            Format fmt3_3d = new Format("%3.3d");
            Format fmt4_4d = new Format("%4.4d");
            Format fmt6_6d = new Format("%6.6d");
            Format fmt_vars = new Format("%s~");
            blktStr = String.valueOf(blktStr) + fmt_vars.format(((TimeStamp)this.get("Beginning effective time")).toSeedString());
            String tmpStr = ((TimeStamp)this.get("Ending effective time")).toSeedString();
            blktStr = tmpStr.compareTo("5138,320,09:46:39.9999") == 0 ? String.valueOf(blktStr) + fmt_vars.format("") : String.valueOf(blktStr) + fmt_vars.format(tmpStr);
            int mapType = 6;
            Blockette31 commVal = (Blockette31)this.get("Station comment");
            int lookupVal = this.lookupMap.getLookup(mapType, commVal);
            blktStr = String.valueOf(blktStr) + fmt4_4d.format(lookupVal);
            blktStr = String.valueOf(blktStr) + fmt6_6d.format((Integer)this.get("Comment value"));
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = blktInfo.substring(sIdx += 4).indexOf(126) + sIdx;
            String tmpStr = blktInfo.substring(sIdx, eIdx).trim();
            this.put("Beginning effective time", TimeStamp.buildTimestamp(tmpStr));
            sIdx = eIdx + 1;
            eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
            if (sIdx != eIdx) {
                tmpStr = blktInfo.substring(sIdx, eIdx).trim();
                if (tmpStr.length() == 0) {
                    this.put("Ending effective time", TimeStamp.buildTimestamp("99999999999.9999"));
                } else {
                    this.put("Ending effective time", TimeStamp.buildTimestamp(tmpStr));
                }
            } else {
                this.put("Ending effective time", TimeStamp.buildTimestamp("99999999999.9999"));
            }
            sIdx = eIdx + 1;
            eIdx = sIdx + 4;
            Integer lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            int mapType = 6;
            Blockette31 commVal = (Blockette31)this.lookupMap.getMatch(mapType, lookupVal);
            this.put("Station comment", commVal);
            eIdx = (sIdx += 4) + 6;
            this.put("Comment value", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Beginning effective time");
        this.paramOutputType.put("Beginning effective time", "%s");
        this.paramInputType.put("Beginning effective time", new Integer(3));
        this.respFieldNames.add("Beginning effective time");
        this.paramLookup.put("04", "Ending effective time");
        this.paramOutputType.put("Ending effective time", "%s");
        this.paramInputType.put("Ending effective time", new Integer(3));
        this.respFieldNames.add("Ending effective time");
        this.paramLookup.put("05", "Station comment");
        this.paramOutputType.put("Station comment", "%s");
        this.paramInputType.put("Station comment", new Integer(6));
        this.respFieldNames.add("Station comment");
        this.paramLookup.put("06", "Comment value");
        this.paramOutputType.put("Comment value", "%d");
        this.paramInputType.put("Comment value", new Integer(1));
        this.respFieldNames.add("Comment value");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b051 = TestData.test_b051a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        String commStr = "CHigh frequence noise~001";
        Blockette31 commVal = new Blockette31();
        commVal.compStringToObj(commStr, lm);
        lm.setLookup(6, new Integer(3), commVal);
        Blockette51 test_val = new Blockette51(test_b051, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b051.length());
        System.out.println(test_val.toString().compareTo(test_b051) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        Date dateStart = new Date();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        Date dateEnd = new Date();
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        long elapsed_time = dateEnd.getTime() - dateStart.getTime();
        System.out.println("hashed " + test_val.toString().length() + " characters in " + elapsed_time + " milliseconds");
        try {
            String fileSep = System.getProperty("file.separator");
            String infile = "test-files" + fileSep + "stacommblkt.resp";
            BufferedReader rd = new BufferedReader(new InputStreamReader(new FileInputStream(infile)));
            StandaloneLookupMap lm2 = new StandaloneLookupMap();
            Blockette51 test_val2 = new Blockette51(rd, lm2, 51);
            System.out.println("-------- test #3 --------");
            System.out.println(test_val2);
            test_val2.echoResp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

