/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.Blockette34;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.SeedResponseBlockette;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import java.io.BufferedReader;
import java.util.ArrayList;

public class Blockette53
extends SeedResponseBlockette {
    private static final long serialVersionUID = 1L;
    private ArrayList poles;
    private ArrayList poleErrors;
    private ArrayList zeros;
    private ArrayList zeroErrors;
    public static final int MAXNUMPAIRS = 207;

    public Blockette53() {
    }

    public Blockette53(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette53(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
        String tfType = (String)this.get("Transfer function type");
        if (tfType == null) {
            throw new ParseStageException("transfer function type not found");
        }
        this.put("Transfer function type", tfType.substring(0, 1));
        this.checkNumParams();
    }

    public Blockette53(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
        String tfType = (String)this.get("Transfer function type");
        if (tfType == null) {
            throw new ParseStageException("transfer function type not found");
        }
        this.put("Transfer function type", tfType.substring(0, 1));
        this.checkNumParams();
    }

    void checkNumParams() throws ParseStageException {
        ArrayList polesRet = (ArrayList)this.get("poles");
        ArrayList zerosRet = (ArrayList)this.get("zeros");
        if (((Integer)this.get("Number of zeros")).intValue() != zerosRet.size()) {
            throw new ParseStageException("'Number of zeros' found (" + zerosRet.size() + " != 'Number of zeros' in blockette (" + (Integer)this.get("Number of zeros") + ")");
        }
        if (((Integer)this.get("Number of poles")).intValue() != polesRet.size()) {
            throw new ParseStageException("'Number of poles' found (" + polesRet.size() + " != 'Number of poles' in blockette (" + (Integer)this.get("Number of poles") + ")");
        }
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        String respHdr = "";
        Format fmt2_2d = new Format("%2.2d");
        Format fmt3_3d = new Format("%3.3d");
        Format fmt4_4d = new Format("%4.4d");
        Format fmt12_5e = new Format("%12.5E");
        int nzeros = 0;
        int npoles = 0;
        if (paramFlag) {
            respHdr = String.valueOf(respHdr) + (String)this.get("Transfer function type");
            respHdr = String.valueOf(respHdr) + fmt2_2d.format((Integer)this.get("Stage sequence number"));
            int mapType = 8;
            Blockette34 unitsAbbrev = (Blockette34)this.get("Response input units");
            int lookupVal = this.lookupMap.getLookup(mapType, unitsAbbrev);
            respHdr = String.valueOf(respHdr) + fmt3_3d.format(lookupVal);
            unitsAbbrev = (Blockette34)this.get("Response output units");
            lookupVal = this.lookupMap.getLookup(mapType, unitsAbbrev);
            respHdr = String.valueOf(respHdr) + fmt3_3d.format(lookupVal);
            respHdr = String.valueOf(respHdr) + fmt12_5e.format((Double)this.get("A0 normalization factor"));
            respHdr = String.valueOf(respHdr) + fmt12_5e.format((Double)this.get("Normalization frequency"));
        }
        nzeros = (Integer)this.get("Number of zeros");
        npoles = (Integer)this.get("Number of poles");
        if (listParamFlag) {
            int zeroIdx = 0;
            int poleIdx = 0;
            int totNum = 0;
            while (true) {
                String zeroStr = "";
                String poleStr = "";
                int nBlktVals = 0;
                int zerosInBlkt = 0;
                int polesInBlkt = 0;
                ArrayList poles = (ArrayList)this.get("poles");
                ArrayList zeros = (ArrayList)this.get("zeros");
                while (nBlktVals < 207 && totNum < nzeros + npoles) {
                    ArrayList tmpList;
                    if (totNum < nzeros) {
                        tmpList = (ArrayList)zeros.get(zeroIdx);
                        zeroStr = String.valueOf(zeroStr) + fmt12_5e.format((Double)tmpList.get(0));
                        zeroStr = String.valueOf(zeroStr) + fmt12_5e.format((Double)tmpList.get(1));
                        zeroStr = String.valueOf(zeroStr) + fmt12_5e.format((Double)tmpList.get(2));
                        zeroStr = String.valueOf(zeroStr) + fmt12_5e.format((Double)tmpList.get(3));
                        ++zeroIdx;
                        ++totNum;
                        ++nBlktVals;
                        ++zerosInBlkt;
                        continue;
                    }
                    tmpList = (ArrayList)poles.get(poleIdx);
                    poleStr = String.valueOf(poleStr) + fmt12_5e.format((Double)tmpList.get(0));
                    poleStr = String.valueOf(poleStr) + fmt12_5e.format((Double)tmpList.get(1));
                    poleStr = String.valueOf(poleStr) + fmt12_5e.format((Double)tmpList.get(2));
                    poleStr = String.valueOf(poleStr) + fmt12_5e.format((Double)tmpList.get(3));
                    ++poleIdx;
                    ++totNum;
                    ++nBlktVals;
                    ++polesInBlkt;
                }
                if (nBlktVals == 207 && totNum != nzeros + npoles) {
                    blktStr = zerosInBlkt > 0 && polesInBlkt == 0 ? (paramFlag ? String.valueOf(blktStr) + respHdr + fmt3_3d.format(zerosInBlkt) + zeroStr + fmt3_3d.format(0) : String.valueOf(blktStr) + zeroStr) : (polesInBlkt > 0 && zerosInBlkt == 0 ? (paramFlag ? String.valueOf(blktStr) + respHdr + fmt3_3d.format(0) + fmt3_3d.format(polesInBlkt) + poleStr : String.valueOf(blktStr) + poleStr) : (paramFlag ? String.valueOf(blktStr) + respHdr + fmt3_3d.format(zerosInBlkt) + zeroStr + fmt3_3d.format(polesInBlkt) + poleStr : String.valueOf(blktStr) + zeroStr + poleStr));
                    if (paramFlag) {
                        returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
                        returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr + "\n";
                    } else {
                        returnVal = String.valueOf(returnVal) + blktStr + "\n";
                    }
                } else {
                    if (paramFlag) {
                        blktStr = String.valueOf(respHdr) + fmt3_3d.format(zerosInBlkt) + zeroStr + fmt3_3d.format(polesInBlkt) + poleStr;
                        break;
                    }
                    blktStr = String.valueOf(zeroStr) + poleStr;
                    break;
                }
                nBlktVals = 0;
                blktStr = "";
            }
        }
        if (paramFlag) {
            if (!listParamFlag) {
                blktStr = String.valueOf(respHdr) + fmt3_3d.format(nzeros) + fmt3_3d.format(npoles);
            }
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        } else {
            returnVal = String.valueOf(returnVal) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            int npoles = 0;
            int nzeros = 0;
            int tmpIdx = -1;
            boolean isFirst = true;
            ArrayList poles = (ArrayList)this.get("poles");
            ArrayList zeros = (ArrayList)this.get("zeros");
            do {
                Integer tmpVal;
                if (isFirst) {
                    this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 3) + 4;
                    eIdx = (sIdx += 4) + 1;
                    this.put("Transfer function type", blktInfo.substring(sIdx, eIdx).trim());
                    eIdx = ++sIdx + 2;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    stageSeqNo = tmpVal;
                    this.put("Stage sequence number", tmpVal);
                    eIdx = (sIdx += 2) + 3;
                    Integer lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    int mapType = 8;
                    Blockette34 unitsAbbrev = (Blockette34)this.lookupMap.getMatch(mapType, lookupVal);
                    this.put("Response input units", unitsAbbrev);
                    eIdx = (sIdx += 3) + 3;
                    lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    mapType = 8;
                    unitsAbbrev = (Blockette34)this.lookupMap.getMatch(mapType, lookupVal);
                    this.put("Response output units", unitsAbbrev);
                    eIdx = (sIdx += 3) + 12;
                    this.put("A0 normalization factor", new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 12) + 12;
                    this.put("Normalization frequency", new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 12) + 3;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    nzeros += tmpVal.intValue();
                    sIdx += 3;
                    isFirst = false;
                } else {
                    prevStageSeqNo = stageSeqNo;
                    eIdx = (sIdx += 8) + 2;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    stageSeqNo = tmpVal;
                    eIdx = (sIdx += 32) + 3;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    nzeros += tmpVal.intValue();
                    sIdx += 3;
                }
                int i = 0;
                while (i < tmpVal) {
                    ArrayList<Double> complexZero = new ArrayList<Double>();
                    eIdx = sIdx + 12;
                    complexZero.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 12) + 12;
                    complexZero.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 12) + 12;
                    complexZero.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 12) + 12;
                    complexZero.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    sIdx += 12;
                    zeros.add(complexZero);
                    ++i;
                }
                eIdx = sIdx + 3;
                tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                npoles += tmpVal.intValue();
                sIdx += 3;
                i = 0;
                while (i < tmpVal) {
                    ArrayList<Double> complexPole = new ArrayList<Double>();
                    eIdx = sIdx + 12;
                    complexPole.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 12) + 12;
                    complexPole.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 12) + 12;
                    complexPole.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 12) + 12;
                    complexPole.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    sIdx += 12;
                    poles.add(complexPole);
                    ++i;
                }
                tmpIdx = blktInfo.substring(sIdx).indexOf("\n");
                if (tmpIdx < 0) break;
                sIdx = tmpIdx + sIdx + 1;
            } while (prevStageSeqNo < 0 || stageSeqNo == prevStageSeqNo);
            this.put("Number of zeros", new Integer(nzeros));
            this.put("zeros", zeros);
            this.put("Number of poles", new Integer(npoles));
            this.put("poles", poles);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Transfer function type");
        this.paramOutputType.put("Transfer function type", "%s");
        this.paramInputType.put("Transfer function type", new Integer(0));
        this.respFieldNames.add("Transfer function type");
        this.paramLookup.put("04", "Stage sequence number");
        this.paramOutputType.put("Stage sequence number", "%d");
        this.paramInputType.put("Stage sequence number", new Integer(1));
        this.respFieldNames.add("Stage sequence number");
        this.paramLookup.put("05", "Response input units");
        this.paramOutputType.put("Response input units", "%s");
        this.paramInputType.put("Response input units", new Integer(8));
        this.respFieldNames.add("Response input units");
        this.paramLookup.put("06", "Response output units");
        this.paramOutputType.put("Response output units", "%s");
        this.paramInputType.put("Response output units", new Integer(8));
        this.respFieldNames.add("Response output units");
        this.paramLookup.put("07", "A0 normalization factor");
        this.paramOutputType.put("A0 normalization factor", "%12.5E");
        this.paramInputType.put("A0 normalization factor", new Integer(2));
        this.respFieldNames.add("A0 normalization factor");
        this.paramLookup.put("08", "Normalization frequency");
        this.paramOutputType.put("Normalization frequency", "%12.5E");
        this.paramInputType.put("Normalization frequency", new Integer(2));
        this.respFieldNames.add("Normalization frequency");
        this.paramLookup.put("09", "Number of zeros");
        this.paramOutputType.put("Number of zeros", "%d");
        this.paramInputType.put("Number of zeros", new Integer(1));
        this.respFieldNames.add("Number of zeros");
        this.paramLookup.put("14", "Number of poles");
        this.paramOutputType.put("Number of poles", "%d");
        this.paramInputType.put("Number of poles", new Integer(1));
        this.respFieldNames.add("Number of poles");
        this.listParamLookup.put("10-13", "zeros");
        ArrayList<Object> tmpList = new ArrayList<Object>();
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(2));
        this.listParamInputTypes.put("zeros", tmpList);
        tmpList = new ArrayList();
        tmpList.add("%12.5E");
        tmpList.add("%12.5E");
        tmpList.add("%12.5E");
        tmpList.add("%12.5E");
        this.listParamOutputTypes.put("zeros", tmpList);
        this.put("zeros", new ArrayList());
        this.listParamLookup.put("15-18", "poles");
        tmpList = new ArrayList();
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(2));
        this.listParamInputTypes.put("poles", tmpList);
        tmpList = new ArrayList();
        tmpList.add("%12.5E");
        tmpList.add("%12.5E");
        tmpList.add("%12.5E");
        tmpList.add("%12.5E");
        this.listParamOutputTypes.put("poles", tmpList);
        this.put("poles", new ArrayList());
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b053 = TestData.test_b053a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        String unitsStr = "M/S - Velocity in Meters Per Second";
        Blockette34 unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(1), unitsVal);
        unitsStr = "V - Volts";
        unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(2), unitsVal);
        unitsStr = "COUNTS - Digital Counts";
        unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(3), unitsVal);
        Blockette53 test_val = new Blockette53(test_b053, lm);
        System.out.println("-------- test #1 --------");
        System.out.println("    Parameters: " + test_val.getParamString());
        System.out.println("Pole-Zero Vals: " + test_val.getListParamString());
        System.out.println("     Blockette: " + test_val);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        System.out.println("     Blockette Hashes to value of: " + test_val.getElfHash());
        System.out.println("Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        System.out.println("Pole-Zero Values Hash to value of: " + test_val.getListParamElfHash());
        System.out.println("------------------------");
        String test_b053b = TestData.test_b053b;
        Blockette53 test_valb = new Blockette53(test_b053b, lm);
        test_valb.echoResp();
        System.out.println("     Blockette Hashes to value of: " + test_valb.getElfHash());
        System.out.println("Blockette Info Hashes to value of: " + test_valb.getParamElfHash());
        System.out.println("Pole-Zero Values Hash to value of: " + test_valb.getListParamElfHash());
    }
}

