/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.Blockette34;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.SeedResponseBlockette;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import java.io.BufferedReader;
import java.util.ArrayList;

public class Blockette55
extends SeedResponseBlockette {
    private static final long serialVersionUID = 1L;
    public static final int MAXNUMVALS = 166;

    public Blockette55() {
    }

    public Blockette55(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette55(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
        this.checkNumParams();
    }

    public Blockette55(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
        this.checkNumParams();
    }

    void checkNumParams() throws ParseStageException {
        ArrayList responsesRet = (ArrayList)this.get("responses");
        if (((Integer)this.get("Number of responses")).intValue() != responsesRet.size()) {
            throw new ParseStageException("'Number of responses' found (" + responsesRet.size() + " != 'Number of responses' in blockette (" + (Integer)this.get("Number of responses") + ")");
        }
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        String respHdr = "";
        Format fmt2_2d = new Format("%2.2d");
        Format fmt3_3d = new Format("%3.3d");
        Format fmt4_4d = new Format("%4.4d");
        Format fmt12_5e = new Format("%12.5E");
        if (paramFlag) {
            respHdr = String.valueOf(respHdr) + fmt2_2d.format((Integer)this.get("Stage sequence number"));
            int mapType = 8;
            Blockette34 unitsAbbrev = (Blockette34)this.get("Response input units");
            int lookupVal = this.lookupMap.getLookup(mapType, unitsAbbrev);
            respHdr = String.valueOf(respHdr) + fmt3_3d.format(lookupVal);
            unitsAbbrev = (Blockette34)this.get("Response output units");
            lookupVal = this.lookupMap.getLookup(mapType, unitsAbbrev);
            respHdr = String.valueOf(respHdr) + fmt3_3d.format(lookupVal);
        }
        int nRespVals = (Integer)this.get("Number of responses");
        if (listParamFlag) {
            int respValIdx = 0;
            int totNum = 0;
            ArrayList responsesList = (ArrayList)this.get("responses");
            while (true) {
                String valStr = "";
                int valsInBlkt = 0;
                while (valsInBlkt < 166 && totNum < nRespVals) {
                    ArrayList vals = (ArrayList)responsesList.get(respValIdx);
                    valStr = String.valueOf(valStr) + fmt12_5e.format((Double)vals.get(0));
                    valStr = String.valueOf(valStr) + fmt12_5e.format((Double)vals.get(1));
                    valStr = String.valueOf(valStr) + fmt12_5e.format((Double)vals.get(2));
                    valStr = String.valueOf(valStr) + fmt12_5e.format((Double)vals.get(3));
                    valStr = String.valueOf(valStr) + fmt12_5e.format((Double)vals.get(4));
                    ++respValIdx;
                    ++totNum;
                    ++valsInBlkt;
                }
                blktStr = paramFlag ? String.valueOf(blktStr) + respHdr + fmt4_4d.format(valsInBlkt) + valStr : String.valueOf(blktStr) + valStr;
                if (valsInBlkt == 166 && totNum != nRespVals) {
                    if (paramFlag) {
                        returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
                        returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr + "\n";
                    } else {
                        returnVal = String.valueOf(returnVal) + blktStr + "\n";
                    }
                } else {
                    if (paramFlag) {
                        blktStr = String.valueOf(respHdr) + fmt4_4d.format(valsInBlkt) + valStr;
                        break;
                    }
                    blktStr = valStr;
                    break;
                }
                valsInBlkt = 0;
                blktStr = "";
            }
        }
        if (paramFlag) {
            if (!listParamFlag) {
                blktStr = String.valueOf(respHdr) + fmt3_3d.format(nRespVals);
            }
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        } else {
            returnVal = String.valueOf(returnVal) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            ArrayList fapList = new ArrayList();
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            int nlisted = 0;
            int tmpIdx = -1;
            boolean isFirst = true;
            do {
                Integer tmpVal;
                if (isFirst) {
                    this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 3) + 4;
                    eIdx = (sIdx += 4) + 2;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    stageSeqNo = tmpVal;
                    this.put("Stage sequence number", tmpVal);
                    eIdx = (sIdx += 2) + 3;
                    Integer lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    int mapType = 8;
                    Blockette34 unitsAbbrev = (Blockette34)this.lookupMap.getMatch(mapType, lookupVal);
                    this.put("Response input units", unitsAbbrev);
                    eIdx = (sIdx += 3) + 3;
                    lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    mapType = 8;
                    unitsAbbrev = (Blockette34)this.lookupMap.getMatch(mapType, lookupVal);
                    this.put("Response output units", unitsAbbrev);
                    eIdx = (sIdx += 3) + 4;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    nlisted += tmpVal.intValue();
                    sIdx += 4;
                    isFirst = false;
                } else {
                    prevStageSeqNo = stageSeqNo;
                    eIdx = (sIdx += 7) + 2;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    stageSeqNo = tmpVal;
                    eIdx = (sIdx += 8) + 3;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    nlisted += tmpVal.intValue();
                    sIdx += 4;
                }
                int i = 0;
                while (i < tmpVal) {
                    ArrayList<Double> fapVal = new ArrayList<Double>();
                    eIdx = sIdx + 12;
                    fapVal.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 12) + 12;
                    fapVal.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 12) + 12;
                    fapVal.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 12) + 12;
                    fapVal.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 12) + 12;
                    fapVal.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    sIdx += 12;
                    fapList.add(fapVal);
                    ++i;
                }
                tmpIdx = blktInfo.substring(sIdx).indexOf("\n");
                if (tmpIdx < 0) break;
                sIdx = tmpIdx + sIdx + 1;
            } while (prevStageSeqNo < 0 || stageSeqNo == prevStageSeqNo);
            this.put("Number of responses", new Integer(nlisted));
            this.put("responses", fapList);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Stage sequence number");
        this.paramOutputType.put("Stage sequence number", "%d");
        this.paramInputType.put("Stage sequence number", new Integer(1));
        this.respFieldNames.add("Stage sequence number");
        this.paramLookup.put("04", "Response input units");
        this.paramOutputType.put("Response input units", "%s");
        this.paramInputType.put("Response input units", new Integer(8));
        this.respFieldNames.add("Response input units");
        this.paramLookup.put("05", "Response output units");
        this.paramOutputType.put("Response output units", "%s");
        this.paramInputType.put("Response output units", new Integer(8));
        this.respFieldNames.add("Response output units");
        this.paramLookup.put("06", "Number of responses");
        this.paramOutputType.put("Number of responses", "%d");
        this.paramInputType.put("Number of responses", new Integer(1));
        this.respFieldNames.add("Number of responses");
        this.listParamLookup.put("07-11", "responses");
        ArrayList<Object> tmpList = new ArrayList<Object>();
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(2));
        this.listParamInputTypes.put("responses", tmpList);
        tmpList = new ArrayList();
        tmpList.add("%12.5E");
        tmpList.add("%12.5E");
        tmpList.add("%12.5E");
        tmpList.add("%12.5E");
        tmpList.add("%12.5E");
        this.listParamOutputTypes.put("responses", tmpList);
        this.put("responses", new ArrayList());
        this.respFieldNames.add("responses");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b055 = TestData.test_b055a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        String unitsStr = "M/S - Velocity in Meters Per Second";
        Blockette34 unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(1), unitsVal);
        unitsStr = "V - Volts";
        unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(2), unitsVal);
        unitsStr = "COUNTS - Digital Counts";
        unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(3), unitsVal);
        Blockette55 test_val = new Blockette55(test_b055, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b055.length());
        System.out.println(test_val.toString().compareTo(test_b055) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        System.out.println("     Blockette Hashes to value of: " + test_val.getElfHash());
        System.out.println("Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        System.out.println("      FAP Values Hash to value of: " + test_val.getListParamElfHash());
    }
}

