/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.SeedResponseBlockette;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import java.io.BufferedReader;

public class Blockette57
extends SeedResponseBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette57() {
    }

    public Blockette57(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette57(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
    }

    public Blockette57(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        Format fmt2_2d = new Format("%2.2d");
        Format fmt3_3d = new Format("%3.3d");
        Format fmt4_4d = new Format("%4.4d");
        Format fmt5_5d = new Format("%5.5d");
        Format fmt10_4e = new Format("%10.4E");
        Format fmt11_4e = new Format("%11.4E");
        if (paramFlag) {
            blktStr = String.valueOf(blktStr) + fmt2_2d.format((Integer)this.get("Stage sequence number"));
            blktStr = String.valueOf(blktStr) + fmt10_4e.format((Double)this.get("Input sample rate"));
            blktStr = String.valueOf(blktStr) + fmt5_5d.format((Integer)this.get("Decimation factor"));
            blktStr = String.valueOf(blktStr) + fmt5_5d.format((Integer)this.get("Decimation offset"));
            blktStr = String.valueOf(blktStr) + fmt11_4e.format((Double)this.get("Estimated delay (seconds)"));
            blktStr = String.valueOf(blktStr) + fmt11_4e.format((Double)this.get("Correction applied (seconds)"));
            returnVal = fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            int sIdx = 0;
            int eIdx = sIdx + 3;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 2;
            this.put("Stage sequence number", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 2) + 10;
            this.put("Input sample rate", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 10) + 5;
            this.put("Decimation factor", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 5) + 5;
            this.put("Decimation offset", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 5) + 11;
            this.put("Estimated delay (seconds)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 11) + 11;
            this.put("Correction applied (seconds)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Stage sequence number");
        this.paramOutputType.put("Stage sequence number", "%d");
        this.paramInputType.put("Stage sequence number", new Integer(1));
        this.respFieldNames.add("Stage sequence number");
        this.paramLookup.put("04", "Input sample rate");
        this.paramOutputType.put("Input sample rate", "%10.4E");
        this.paramInputType.put("Input sample rate", new Integer(2));
        this.respFieldNames.add("Input sample rate");
        this.paramLookup.put("05", "Decimation factor");
        this.paramOutputType.put("Decimation factor", "%d");
        this.paramInputType.put("Decimation factor", new Integer(1));
        this.respFieldNames.add("Decimation factor");
        this.paramLookup.put("06", "Decimation offset");
        this.paramOutputType.put("Decimation offset", "%d");
        this.paramInputType.put("Decimation offset", new Integer(1));
        this.respFieldNames.add("Decimation offset");
        this.paramLookup.put("07", "Estimated delay (seconds)");
        this.paramOutputType.put("Estimated delay (seconds)", "%11.4E");
        this.paramInputType.put("Estimated delay (seconds)", new Integer(2));
        this.respFieldNames.add("Estimated delay (seconds)");
        this.paramLookup.put("08", "Correction applied (seconds)");
        this.paramOutputType.put("Correction applied (seconds)", "%11.4E");
        this.paramInputType.put("Correction applied (seconds)", new Integer(2));
        this.respFieldNames.add("Correction applied (seconds)");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b057 = TestData.test_b057a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        Blockette57 test_val = new Blockette57(test_b057, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b057.length());
        System.out.println(test_val.toString().compareTo(test_b057) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        System.out.println("     Blockette Hashes to value of: " + test_val.getElfHash());
        System.out.println("Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        System.out.println("     List Values Hash to value of: " + test_val.getListParamElfHash());
    }
}

