/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import java.io.BufferedReader;
import java.util.ArrayList;

public class Blockette58
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette58() {
    }

    public Blockette58(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette58(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
        this.checkNumParams();
    }

    public Blockette58(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
        this.checkNumParams();
    }

    void checkNumParams() throws ParseStageException {
        ArrayList calibVals = (ArrayList)this.get("calibVals");
        if (((Integer)this.get("Number of calibrations")).intValue() != calibVals.size()) {
            throw new ParseStageException("'Number of calibrations' found (" + calibVals.size() + " != 'Number of calibrations' in blockette (" + (Integer)this.get("Number of calibrations") + ")");
        }
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        Format fmt2_2d = new Format("%2.2d");
        Format fmt3_3d = new Format("%3.3d");
        Format fmt4_4d = new Format("%4.4d");
        Format fmt12_5e = new Format("%12.5E");
        Format fmtvar_str = new Format("%s~");
        if (paramFlag) {
            blktStr = String.valueOf(blktStr) + fmt2_2d.format((Integer)this.get("Stage sequence number"));
            blktStr = String.valueOf(blktStr) + fmt12_5e.format((Double)this.get("Gain"));
            blktStr = String.valueOf(blktStr) + fmt12_5e.format((Double)this.get("Gain frequency"));
            blktStr = String.valueOf(blktStr) + fmt2_2d.format((Integer)this.get("Number of calibrations"));
        }
        int ncalib = (Integer)this.get("Number of calibrations");
        if (listParamFlag) {
            ArrayList calibVals = (ArrayList)this.get("calibVals");
            int i = 0;
            while (i < ncalib) {
                ArrayList calibVal = (ArrayList)calibVals.get(i);
                blktStr = String.valueOf(blktStr) + fmt12_5e.format((Double)calibVal.get(0));
                blktStr = String.valueOf(blktStr) + fmt12_5e.format((Double)calibVal.get(1));
                blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)calibVal.get(2));
                ++i;
            }
        }
        if (paramFlag) {
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        } else {
            returnVal = String.valueOf(returnVal) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            int sIdx = 0;
            int eIdx = sIdx + 3;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 2;
            this.put("Stage sequence number", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 2) + 12;
            this.put("Gain", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 12) + 12;
            this.put("Gain frequency", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 12) + 2;
            this.put("Number of calibrations", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            int ncalib = (Integer)this.get("Number of calibrations");
            sIdx += 2;
            ArrayList calibVals = (ArrayList)this.get("calibVals");
            int i = 0;
            while (i < ncalib) {
                ArrayList<Object> calibInfo = new ArrayList<Object>();
                eIdx = sIdx + 12;
                calibInfo.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                eIdx = (sIdx += 12) + 12;
                calibInfo.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                eIdx = blktInfo.substring(sIdx += 12).indexOf(126) + sIdx;
                calibInfo.add(blktInfo.substring(sIdx, eIdx).trim());
                sIdx = eIdx + 1;
                calibVals.add(calibInfo);
                ++i;
            }
            this.put("calibVals", calibVals);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Stage sequence number");
        this.paramOutputType.put("Stage sequence number", "%d");
        this.paramInputType.put("Stage sequence number", new Integer(1));
        this.respFieldNames.add("Stage sequence number");
        this.paramLookup.put("04", "Gain");
        this.paramOutputType.put("Gain", "%12.5E");
        this.paramInputType.put("Gain", new Integer(2));
        this.respFieldNames.add("Gain");
        this.paramLookup.put("05", "Gain frequency");
        this.paramOutputType.put("Gain frequency", "%12.5E");
        this.paramInputType.put("Gain frequency", new Integer(2));
        this.respFieldNames.add("Gain frequency");
        this.paramLookup.put("06", "Number of calibrations");
        this.paramOutputType.put("Number of calibrations", "%d");
        this.paramInputType.put("Number of calibrations", new Integer(1));
        this.respFieldNames.add("Number of calibrations");
        this.listParamLookup.put("07-09", "calibVals");
        ArrayList<Object> tmpList = new ArrayList<Object>();
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(0));
        this.listParamInputTypes.put("calibVals", tmpList);
        tmpList = new ArrayList();
        tmpList.add("%12.5E");
        tmpList.add("%12.5E");
        tmpList.add("%s");
        this.listParamOutputTypes.put("calibVals", tmpList);
        this.put("calibVals", new ArrayList());
        this.respFieldNames.add("calibVals");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        System.out.println("-------- test #1 --------");
        String test_b058 = TestData.test_b058a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        Blockette58 test_val = new Blockette58(test_b058, lm);
        test_val.echoResp();
        System.out.println("     Blockette Hashes to value of: " + test_val.getElfHash());
        System.out.println("Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        System.out.println("    Calib Values Hash to value of: " + test_val.getListParamElfHash());
        System.out.println("-------- test #2 --------");
        test_b058 = "058011201 2.26800E+03 2.00000E-0202 2.26800E+03 2.00000E-021998,188~ 2.26800E+03 2.00000E-021999,188:00:00:01.1~";
        test_val = new Blockette58(test_b058, lm);
        System.out.println(test_val);
        System.out.println("-------- test #3 --------");
        System.out.print("matches '" + test_b058 + "'?  ");
        System.out.println(test_val.toString().compareTo(test_b058) == 0);
        System.out.println("-------- test #4 --------");
        test_val.echoResp();
        System.out.println("     Blockette Hashes to value of: " + test_val.getElfHash());
        System.out.println("Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        System.out.println("    Calib Values Hash to value of: " + test_val.getListParamElfHash());
    }
}

