/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedReader;
import java.util.Date;

public class Blockette70
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette70() {
    }

    public Blockette70(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette70(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
    }

    public Blockette70(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        if (paramFlag) {
            Format fmt3_3d = new Format("%3.3d");
            Format fmt4_4d = new Format("%4.4d");
            Format fmt1s = new Format("%1s");
            Format fmt_vars = new Format("%s~");
            blktStr = String.valueOf(blktStr) + fmt1s.format((String)this.get("Time span flag"));
            blktStr = String.valueOf(blktStr) + fmt_vars.format(((TimeStamp)this.get("Time span start time")).toSeedString());
            blktStr = String.valueOf(blktStr) + fmt_vars.format(((TimeStamp)this.get("Time span end time")).toSeedString());
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 1;
            this.put("Time span flag", blktInfo.substring(sIdx, eIdx).trim());
            eIdx = blktInfo.substring(++sIdx).indexOf(126) + sIdx;
            String tmpStr = blktInfo.substring(sIdx, eIdx).trim();
            this.put("Time span start time", TimeStamp.buildTimestamp(tmpStr));
            sIdx = eIdx + 1;
            eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
            tmpStr = blktInfo.substring(sIdx, eIdx).trim();
            this.put("Time span end time", TimeStamp.buildTimestamp(tmpStr));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Time span flag");
        this.paramOutputType.put("Time span flag", "%1s");
        this.paramInputType.put("Time span flag", new Integer(0));
        this.respFieldNames.add("Time span flag");
        this.paramLookup.put("04", "Time span start time");
        this.paramOutputType.put("Time span start time", "%s");
        this.paramInputType.put("Time span start time", new Integer(3));
        this.respFieldNames.add("Time span start time");
        this.paramLookup.put("05", "Time span end time");
        this.paramOutputType.put("Time span end time", "%s");
        this.paramInputType.put("Time span end time", new Integer(3));
        this.respFieldNames.add("Time span end time");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b070 = TestData.test_b070a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        Blockette70 test_val = new Blockette70(test_b070, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b070.length());
        System.out.println(test_val.toString().compareTo(test_b070) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        Date dateStart = new Date();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        Date dateEnd = new Date();
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        long elapsed_time = dateEnd.getTime() - dateStart.getTime();
        System.out.println("hashed " + test_val.toString().length() + " characters in " + elapsed_time + " milliseconds");
    }
}

