/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.Blockette32;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;

public class Blockette71
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette71() {
    }

    public Blockette71(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette71(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
    }

    public Blockette71(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
        this.checkNumParams();
    }

    void checkNumParams() throws ParseStageException {
        ArrayList tmpList = (ArrayList)this.get("Magnitude values");
        if (((Integer)this.get("Number of magnitudes")).intValue() != tmpList.size()) {
            throw new ParseStageException("'Number of magnitudes' found (" + tmpList.size() + " != 'Number of magnitudes' in blockette (" + (Integer)this.get("Number of magnitudes") + ")");
        }
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        if (paramFlag) {
            Format fmt2_2d = new Format("%2.2d");
            Format fmt3_3d = new Format("%3.3d");
            Format fmt4_4d = new Format("%4.4d");
            Format fmt10_6f = new Format("%10.6f");
            Format fmt11_6f = new Format("%11.6f");
            Format fmt7_2f = new Format("%7.2f");
            Format fmt5_2f = new Format("%5.2f");
            Format fmt_vars = new Format("%s~");
            blktStr = String.valueOf(blktStr) + fmt_vars.format(((TimeStamp)this.get("Origin time")).toSeedString());
            int mapType = 5;
            Blockette32 sourceAbbrev = (Blockette32)this.get("Hypocenter source");
            int lookupVal = this.lookupMap.getLookup(mapType, sourceAbbrev);
            blktStr = String.valueOf(blktStr) + fmt2_2d.format(lookupVal);
            blktStr = String.valueOf(blktStr) + fmt10_6f.format((Double)this.get("Latitude (degrees)"));
            blktStr = String.valueOf(blktStr) + fmt11_6f.format((Double)this.get("Longitude (degrees)"));
            blktStr = String.valueOf(blktStr) + fmt7_2f.format((Double)this.get("Depth (km)"));
            int nMags = (Integer)this.get("Number of magnitudes");
            blktStr = String.valueOf(blktStr) + fmt2_2d.format(nMags);
            ArrayList tmpList = (ArrayList)this.get("Magnitude values");
            int i = 0;
            while (i < nMags) {
                ArrayList valList = (ArrayList)tmpList.get(i);
                blktStr = String.valueOf(blktStr) + fmt5_2f.format((Double)valList.get(0));
                blktStr = String.valueOf(blktStr) + fmt_vars.format((String)valList.get(1));
                blktStr = String.valueOf(blktStr) + fmt2_2d.format((Integer)valList.get(2));
                ++i;
            }
            blktStr = String.valueOf(blktStr) + fmt3_3d.format((Integer)this.get("Seismic region"));
            blktStr = String.valueOf(blktStr) + fmt4_4d.format((Integer)this.get("Seismic location"));
            blktStr = String.valueOf(blktStr) + fmt_vars.format((String)this.get("Region name"));
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            ArrayList tmpList = null;
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = blktInfo.substring(sIdx += 4).indexOf(126) + sIdx;
            this.put("Origin time", TimeStamp.buildTimestamp(blktInfo.substring(sIdx, eIdx).trim()));
            sIdx = eIdx + 1;
            eIdx = sIdx + 2;
            Integer lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            int mapType = 5;
            Blockette32 sourceAbbrev = (Blockette32)this.lookupMap.getMatch(mapType, lookupVal);
            this.put("Hypocenter source", sourceAbbrev);
            eIdx = (sIdx += 2) + 10;
            this.put("Latitude (degrees)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 10) + 11;
            this.put("Longitude (degrees)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 11) + 7;
            this.put("Depth (km)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 7) + 2;
            Integer intVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            int nMags = intVal;
            this.put("Number of magnitudes", intVal);
            if (nMags > 0) {
                tmpList = (ArrayList)this.get("Magnitude values");
                tmpList.clear();
            }
            eIdx = (sIdx += 2) + 5;
            int i = 0;
            while (i < nMags) {
                ArrayList<Object> valList = new ArrayList<Object>();
                valList.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                eIdx = blktInfo.substring(sIdx += 5).indexOf(126) + sIdx;
                valList.add(blktInfo.substring(sIdx, eIdx).trim());
                sIdx = eIdx + 1;
                eIdx = sIdx + 2;
                valList.add(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
                eIdx = (sIdx += 2) + 5;
                tmpList.add(valList);
                ++i;
            }
            eIdx = sIdx + 3;
            this.put("Seismic region", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            this.put("Seismic location", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = blktInfo.substring(sIdx += 4).indexOf(126) + sIdx;
            this.put("Region name", blktInfo.substring(sIdx, eIdx).trim());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Origin time");
        this.paramOutputType.put("Origin time", "%s");
        this.paramInputType.put("Origin time", new Integer(3));
        this.respFieldNames.add("Origin time");
        this.paramLookup.put("04", "Hypocenter source");
        this.paramOutputType.put("Hypocenter source", "%s");
        this.paramInputType.put("Hypocenter source", new Integer(5));
        this.respFieldNames.add("Hypocenter source");
        this.paramLookup.put("05", "Latitude (degrees)");
        this.paramOutputType.put("Latitude (degrees)", "%10.6f");
        this.paramInputType.put("Latitude (degrees)", new Integer(2));
        this.respFieldNames.add("Latitude (degrees)");
        this.paramLookup.put("06", "Longitude (degrees)");
        this.paramOutputType.put("Longitude (degrees)", "%11.6f");
        this.paramInputType.put("Longitude (degrees)", new Integer(2));
        this.respFieldNames.add("Longitude (degrees)");
        this.paramLookup.put("07", "Depth (km)");
        this.paramOutputType.put("Depth (km)", "%7.2f");
        this.paramInputType.put("Depth (km)", new Integer(2));
        this.respFieldNames.add("Depth (km)");
        this.paramLookup.put("08", "Number of magnitudes");
        this.paramOutputType.put("Number of magnitudes", "%d");
        this.paramInputType.put("Number of magnitudes", new Integer(1));
        this.respFieldNames.add("Number of magnitudes");
        this.paramLookup.put("12", "Seismic region");
        this.paramOutputType.put("Seismic region", "%d");
        this.paramInputType.put("Seismic region", new Integer(1));
        this.respFieldNames.add("Seismic region");
        this.paramLookup.put("13", "Seismic location");
        this.paramOutputType.put("Seismic location", "%d");
        this.paramInputType.put("Seismic location", new Integer(1));
        this.respFieldNames.add("Seismic location");
        this.paramLookup.put("14", "Region name");
        this.paramOutputType.put("Region name", "%s");
        this.paramInputType.put("Region name", new Integer(0));
        this.respFieldNames.add("Region name");
        this.listParamLookup.put("09-11", "Magnitude values");
        ArrayList<Object> tmpList = new ArrayList<Object>();
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(0));
        tmpList.add(new Integer(1));
        this.listParamInputTypes.put("Magnitude values", tmpList);
        tmpList = new ArrayList();
        tmpList.add("%5.2f");
        tmpList.add("%s");
        tmpList.add("%d");
        this.listParamOutputTypes.put("Magnitude values", tmpList);
        this.put("Magnitude values", new ArrayList());
        this.respFieldNames.add("Magnitude values");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b071 = TestData.test_b071a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        String source1 = "Harvard CMT~Harvard Centroid Moment Tensor~Harvard University~";
        Blockette32 sourceVal = new Blockette32();
        sourceVal.compStringToObj(source1, lm);
        lm.setLookup(5, new Integer(1), sourceVal);
        String source2 = "NEIC PDE WEEKLY LISTING~3 92 Preliminary Determination of Epicenters~National Earthquake Information Center, USGS~";
        sourceVal = new Blockette32();
        sourceVal.compStringToObj(source2, lm);
        lm.setLookup(5, new Integer(2), sourceVal);
        Blockette71 test_val = new Blockette71(test_b071, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b071.length());
        System.out.println(test_val.toString().compareTo(test_b071) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        Date dateStart = new Date();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        Date dateEnd = new Date();
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        long elapsed_time = dateEnd.getTime() - dateStart.getTime();
        System.out.println("hashed " + test_val.toString().length() + " characters in " + elapsed_time + " milliseconds");
        try {
            String fileSep = System.getProperty("file.separator");
            String infile = "c:" + fileSep + "hypoinfoblkt.resp";
            BufferedReader rd = new BufferedReader(new InputStreamReader(new FileInputStream(infile)));
            StandaloneLookupMap lm2 = new StandaloneLookupMap();
            Blockette71 test_val2 = new Blockette71(rd, lm2, 71);
            System.out.println("-------- test #3 --------");
            System.out.println(test_val2);
            test_val2.echoResp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

