/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Date;

public class Blockette73
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette73() {
    }

    public Blockette73(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette73(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
        this.checkNumParams();
    }

    public Blockette73(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
        this.checkNumParams();
    }

    void checkNumParams() throws ParseStageException {
        ArrayList tmpList = (ArrayList)this.get("Data segment values");
        if (((Integer)this.get("Number of accelerator data segments")).intValue() != tmpList.size()) {
            throw new ParseStageException("'Number of data segments' found (" + tmpList.size() + " != 'Number of data segments' in blockette (" + (Integer)this.get("Number of data segments") + ")");
        }
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        if (paramFlag) {
            Format fmt2_2d = new Format("%2.2d");
            Format fmt3_3d = new Format("%3.3d");
            Format fmt4_4d = new Format("%4.4d");
            Format fmt6_6d = new Format("%6.6d");
            Format fmt2s = new Format("%-2s");
            Format fmt3s = new Format("%-3s");
            Format fmt5s = new Format("%-5s");
            Format fmt_vars = new Format("%s~");
            int numDataSegs = (Integer)this.get("Number of data segments");
            blktStr = String.valueOf(blktStr) + fmt4_4d.format(numDataSegs);
            ArrayList tmpList = (ArrayList)this.get("Data segment values");
            int i = 0;
            while (i < numDataSegs) {
                ArrayList valList = (ArrayList)tmpList.get(i);
                blktStr = String.valueOf(blktStr) + fmt5s.format((String)valList.get(0));
                blktStr = String.valueOf(blktStr) + fmt2s.format((String)valList.get(1));
                blktStr = String.valueOf(blktStr) + fmt3s.format((String)valList.get(2));
                blktStr = String.valueOf(blktStr) + fmt_vars.format(((TimeStamp)valList.get(3)).toSeedString());
                blktStr = String.valueOf(blktStr) + fmt6_6d.format((Integer)valList.get(4));
                blktStr = String.valueOf(blktStr) + fmt2_2d.format((Integer)valList.get(5));
                ++i;
            }
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            ArrayList tmpList = null;
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 4;
            Integer intVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            int numDataSegs = intVal;
            this.put("Number of data segments", intVal);
            if (numDataSegs > 0) {
                tmpList = (ArrayList)this.get("Data segment values");
                tmpList.clear();
                eIdx = (sIdx += 4) + 5;
            }
            int i = 0;
            while (i < numDataSegs) {
                ArrayList<Object> valList = new ArrayList<Object>();
                valList.add(blktInfo.substring(sIdx, eIdx).trim());
                eIdx = (sIdx += 5) + 2;
                valList.add(blktInfo.substring(sIdx, eIdx).trim());
                eIdx = (sIdx += 2) + 3;
                valList.add(blktInfo.substring(sIdx, eIdx).trim());
                eIdx = blktInfo.substring(sIdx += 3).indexOf(126) + sIdx;
                valList.add(TimeStamp.buildTimestamp(blktInfo.substring(sIdx, eIdx).trim()));
                sIdx = eIdx + 1;
                eIdx = sIdx + 6;
                valList.add(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
                eIdx = (sIdx += 6) + 2;
                valList.add(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
                eIdx = (sIdx += 2) + 5;
                tmpList.add(valList);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Number of data segments");
        this.paramOutputType.put("Number of data segments", "%d");
        this.paramInputType.put("Number of data segments", new Integer(1));
        this.respFieldNames.add("Number of data segments");
        this.listParamLookup.put("04-09", "Data segment values");
        ArrayList<Object> tmpList = new ArrayList<Object>();
        tmpList.add(new Integer(0));
        tmpList.add(new Integer(0));
        tmpList.add(new Integer(0));
        tmpList.add(new Integer(3));
        tmpList.add(new Integer(1));
        tmpList.add(new Integer(1));
        this.listParamInputTypes.put("Data segment values", tmpList);
        tmpList = new ArrayList();
        tmpList.add("%-5s");
        tmpList.add("%-2s");
        tmpList.add("%-3s");
        tmpList.add("%s");
        tmpList.add("%6d");
        tmpList.add("%2d");
        this.listParamOutputTypes.put("Data segment values", tmpList);
        this.put("Data segment values", new ArrayList());
        this.respFieldNames.add("Data segment values");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b073 = TestData.test_b073a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        Blockette73 test_val = new Blockette73(test_b073, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b073.length());
        System.out.println(test_val.toString().compareTo(test_b073) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        Date dateStart = new Date();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        Date dateEnd = new Date();
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        long elapsed_time = dateEnd.getTime() - dateStart.getTime();
        System.out.println("hashed " + test_val.toString().length() + " characters in " + elapsed_time + " milliseconds");
    }
}

