/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Date;

public class Blockette74
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette74() {
    }

    public Blockette74(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette74(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
        this.checkNumParams();
    }

    public Blockette74(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
        this.checkNumParams();
    }

    void checkNumParams() throws ParseStageException {
        ArrayList tmpList = (ArrayList)this.get("Accelerator indexes");
        if (((Integer)this.get("Number of accelerator indexes")).intValue() != tmpList.size()) {
            throw new ParseStageException("'Number of accelerator indexes' found (" + tmpList.size() + " != 'Number of accelerator indexes' in blockette (" + (Integer)this.get("Number of accelerator indexes") + ")");
        }
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        if (paramFlag) {
            Format fmt2_2d = new Format("%2.2d");
            Format fmt3_3d = new Format("%3.3d");
            Format fmt4_4d = new Format("%4.4d");
            Format fmt6_6d = new Format("%6.6d");
            Format fmt2s = new Format("%-2s");
            Format fmt3s = new Format("%-3s");
            Format fmt5s = new Format("%-5s");
            Format fmt_vars = new Format("%s~");
            blktStr = String.valueOf(blktStr) + fmt5s.format((String)this.get("Station"));
            blktStr = String.valueOf(blktStr) + fmt2s.format((String)this.get("Location ID"));
            blktStr = String.valueOf(blktStr) + fmt3s.format((String)this.get("Channel"));
            blktStr = String.valueOf(blktStr) + fmt_vars.format(((TimeStamp)this.get("Series start time")).toSeedString());
            blktStr = String.valueOf(blktStr) + fmt6_6d.format((Integer)this.get("Seq. number of first data"));
            blktStr = String.valueOf(blktStr) + fmt2_2d.format((Integer)this.get("Sub-Seq. number of first data"));
            blktStr = String.valueOf(blktStr) + fmt_vars.format(((TimeStamp)this.get("Series end time")).toSeedString());
            blktStr = String.valueOf(blktStr) + fmt6_6d.format((Integer)this.get("Seq. number of last record"));
            blktStr = String.valueOf(blktStr) + fmt2_2d.format((Integer)this.get("Sub-Seq. number of last record"));
            int numAccel = (Integer)this.get("Number of accelerator indexes");
            blktStr = String.valueOf(blktStr) + fmt3_3d.format(numAccel);
            ArrayList tmpList = (ArrayList)this.get("Accelerator indexes");
            int i = 0;
            while (i < numAccel) {
                ArrayList valList = (ArrayList)tmpList.get(i);
                blktStr = String.valueOf(blktStr) + fmt_vars.format(((TimeStamp)valList.get(0)).toSeedString());
                blktStr = String.valueOf(blktStr) + fmt6_6d.format((Integer)valList.get(1));
                blktStr = String.valueOf(blktStr) + fmt2_2d.format((Integer)valList.get(2));
                ++i;
            }
            blktStr = String.valueOf(blktStr) + fmt2s.format((String)this.get("Network"));
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            ArrayList tmpList = null;
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 5;
            this.put("Station", blktInfo.substring(sIdx, eIdx).trim());
            eIdx = (sIdx += 5) + 2;
            this.put("Location ID", blktInfo.substring(sIdx, eIdx).trim());
            eIdx = (sIdx += 2) + 3;
            this.put("Channel", blktInfo.substring(sIdx, eIdx).trim());
            eIdx = blktInfo.substring(sIdx += 3).indexOf(126) + sIdx;
            this.put("Series start time", TimeStamp.buildTimestamp(blktInfo.substring(sIdx, eIdx).trim()));
            sIdx = eIdx + 1;
            eIdx = sIdx + 6;
            this.put("Seq. number of first data", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 6) + 2;
            this.put("Sub-Seq. number of first data", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = blktInfo.substring(sIdx += 2).indexOf(126) + sIdx;
            this.put("Series end time", TimeStamp.buildTimestamp(blktInfo.substring(sIdx, eIdx).trim()));
            sIdx = eIdx + 1;
            eIdx = sIdx + 6;
            this.put("Seq. number of last record", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 6) + 2;
            this.put("Sub-Seq. number of last record", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 2) + 3;
            Integer intVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            int numAccel = intVal;
            sIdx += 3;
            this.put("Number of accelerator indexes", intVal);
            if (numAccel > 0) {
                tmpList = (ArrayList)this.get("Accelerator indexes");
                tmpList.clear();
                eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
            }
            int i = 0;
            while (i < numAccel) {
                ArrayList<Comparable<Date>> valList = new ArrayList<Comparable<Date>>();
                valList.add(TimeStamp.buildTimestamp(blktInfo.substring(sIdx, eIdx).trim()));
                sIdx = eIdx + 1;
                eIdx = sIdx + 6;
                valList.add(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
                eIdx = (sIdx += 6) + 2;
                valList.add(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
                if (i + 1 < numAccel) {
                    eIdx = blktInfo.substring(sIdx += 2).indexOf(126) + sIdx;
                } else {
                    sIdx += 2;
                }
                tmpList.add(valList);
                ++i;
            }
            eIdx = sIdx + 2;
            this.put("Network", blktInfo.substring(sIdx, eIdx).trim());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Station");
        this.paramOutputType.put("Station", "%-5s");
        this.paramInputType.put("Station", new Integer(0));
        this.respFieldNames.add("Station");
        this.paramLookup.put("04", "Location ID");
        this.paramOutputType.put("Location ID", "%-2s");
        this.paramInputType.put("Location ID", new Integer(0));
        this.respFieldNames.add("Location ID");
        this.paramLookup.put("05", "Channel");
        this.paramOutputType.put("Channel", "%-3s");
        this.paramInputType.put("Channel", new Integer(0));
        this.respFieldNames.add("Channel");
        this.paramLookup.put("06", "Series start time");
        this.paramOutputType.put("Series start time", "%s");
        this.paramInputType.put("Series start time", new Integer(3));
        this.respFieldNames.add("Series start time");
        this.paramLookup.put("07", "Seq. number of first data");
        this.paramOutputType.put("Seq. number of first data", "%d");
        this.paramInputType.put("Seq. number of first data", new Integer(1));
        this.respFieldNames.add("Seq. number of first data");
        this.paramLookup.put("08", "Sub-Seq. number of first data");
        this.paramOutputType.put("Sub-Seq. number of first data", "%d");
        this.paramInputType.put("Sub-Seq. number of first data", new Integer(1));
        this.respFieldNames.add("Sub-Seq. number of first data");
        this.paramLookup.put("09", "Series end time");
        this.paramOutputType.put("Series end time", "%s");
        this.paramInputType.put("Series end time", new Integer(3));
        this.respFieldNames.add("Series end time");
        this.paramLookup.put("10", "Seq. number of last record");
        this.paramOutputType.put("Seq. number of last record", "%d");
        this.paramInputType.put("Seq. number of last record", new Integer(1));
        this.respFieldNames.add("Seq. number of last record");
        this.paramLookup.put("11", "Sub-Seq. number of last record");
        this.paramOutputType.put("Sub-Seq. number of last record", "%d");
        this.paramInputType.put("Sub-Seq. number of last record", new Integer(1));
        this.respFieldNames.add("Sub-Seq. number of last record");
        this.paramLookup.put("12", "Number of accelerator indexes");
        this.paramOutputType.put("Number of accelerator indexes", "%d");
        this.paramInputType.put("Number of accelerator indexes", new Integer(1));
        this.respFieldNames.add("Number of accelerator indexes");
        this.paramLookup.put("16", "Network");
        this.paramOutputType.put("Network", "%-2s");
        this.paramInputType.put("Network", new Integer(0));
        this.respFieldNames.add("Network");
        this.listParamLookup.put("13-15", "Accelerator indexes");
        ArrayList<Object> tmpList = new ArrayList<Object>();
        tmpList.add(new Integer(3));
        tmpList.add(new Integer(1));
        tmpList.add(new Integer(1));
        this.listParamInputTypes.put("Accelerator indexes", tmpList);
        tmpList = new ArrayList();
        tmpList.add("%s");
        tmpList.add("%d");
        tmpList.add("%d");
        this.listParamOutputTypes.put("Accelerator indexes", tmpList);
        this.put("Accelerator indexes", new ArrayList());
        this.respFieldNames.add("Accelerator indexes");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b074 = TestData.test_b074a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        Blockette74 test_val = new Blockette74(test_b074, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b074.length());
        System.out.println(test_val.toString().compareTo(test_b074) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        Date dateStart = new Date();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        Date dateEnd = new Date();
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        long elapsed_time = dateEnd.getTime() - dateStart.getTime();
        System.out.println("hashed " + test_val.toString().length() + " characters in " + elapsed_time + " milliseconds");
    }
}

