/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.seedutils.Converter;
import edu.iris.seedutils.SeedFormatException;

public class DataBlocketteHeader {
    byte[] blktBytes;
    boolean byteSwap;
    Converter converter = new Converter();
    private static final int MSB_FIRST = 1985229328;
    private static final int MSB_LAST = 271733878;

    public DataBlocketteHeader(byte[] data, boolean swapFlag) throws SeedFormatException {
        if (data.length != 4) {
            throw new SeedFormatException("DataBlocketteHeaders must be 4 bytes long");
        }
        this.blktBytes = data;
        this.byteSwap = swapFlag;
        int blktType = this.getType();
        switch (blktType) {
            case 100: 
            case 200: 
            case 201: 
            case 202: 
            case 300: 
            case 310: 
            case 320: 
            case 390: 
            case 395: 
            case 400: 
            case 405: 
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw new SeedFormatException("Unrecognized blockette type found (" + blktType + ")");
            }
        }
    }

    public int getType() {
        short type = this.converter.makeShort(this.blktBytes[0], this.blktBytes[1]);
        if (this.byteSwapNeeded()) {
            type = this.converter.swapShort(type);
        }
        return type;
    }

    public int nextDataBlocketteOffset() {
        short offset = this.converter.makeShort(this.blktBytes[2], this.blktBytes[3]);
        if (this.byteSwapNeeded()) {
            offset = this.converter.swapShort(offset);
        }
        return offset;
    }

    boolean byteSwapNeeded() {
        return this.byteSwap;
    }

    public byte[] getBytes() {
        return this.blktBytes;
    }

    public String toString() {
        String blktTypeStr = "                      blockette type: " + this.getType();
        String nextOffsetString = "            offset to next blockette: " + this.nextDataBlocketteOffset();
        return String.valueOf(blktTypeStr) + "\n" + nextOffsetString;
    }
}

