/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.AlphaComparator;
import edu.iris.seedutils.Blockette10;
import edu.iris.seedutils.Blockette11;
import edu.iris.seedutils.Blockette12;
import edu.iris.seedutils.Blockette30;
import edu.iris.seedutils.Blockette31;
import edu.iris.seedutils.Blockette32;
import edu.iris.seedutils.Blockette33;
import edu.iris.seedutils.Blockette34;
import edu.iris.seedutils.Blockette50;
import edu.iris.seedutils.Blockette51;
import edu.iris.seedutils.Blockette52;
import edu.iris.seedutils.Blockette53;
import edu.iris.seedutils.Blockette54;
import edu.iris.seedutils.Blockette55;
import edu.iris.seedutils.Blockette57;
import edu.iris.seedutils.Blockette58;
import edu.iris.seedutils.Blockette59;
import edu.iris.seedutils.Blockette61;
import edu.iris.seedutils.Blockette70;
import edu.iris.seedutils.Blockette71;
import edu.iris.seedutils.Blockette72;
import edu.iris.seedutils.Blockette73;
import edu.iris.seedutils.Blockette74;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.SeedResp;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class SeedBlockette
extends HashMap
implements SeedResp {
    private int blocketteType;
    HashMap paramLookup = new HashMap();
    HashMap paramInputType = new HashMap();
    HashMap paramOutputType = new HashMap();
    HashMap multiParamLookup = new HashMap();
    HashMap multiParamInputType = new HashMap();
    HashMap multiParamOutputType = new HashMap();
    HashMap multiParamOutputTag = new HashMap();
    HashMap listParamLookup = new HashMap();
    HashMap listParamInputTypes = new HashMap();
    HashMap listParamOutputTypes = new HashMap();
    ArrayList respFieldNames = new ArrayList();
    String idxFieldNames = "";
    SeedLookupMap lookupMap;
    static final int BLOCKETTE_PREFIXLENGTH = 4;
    private static final int FIELD_PREFIXMAXLENGTH = 6;
    public static final int SEED_STRING = 0;
    public static final int SEED_INTEGER = 1;
    public static final int SEED_DOUBLE = 2;
    public static final int SEED_DATETIME = 3;
    public static final int SEED_DATAFORMAT_LOOKUP = 4;
    public static final int SEED_CITEDSOURCE_LOOKUP = 5;
    public static final int SEED_COMMENT_LOOKUP = 6;
    public static final int SEED_GENERIC_LOOKUP = 7;
    public static final int SEED_UNITS_LOOKUP = 8;
    public static final int DATAFORMAT_BLKTNO = 30;
    public static final int COMMENTDESC_BLKTNO = 31;
    public static final int CITEDSOURCE_BLKTNO = 32;
    public static final int GENERIC_BLKTNO = 33;
    public static final int UNITS_BLKTNO = 34;
    public static final String MAXEPOCHSTR = "99999999999.9999";
    public static final String MAXSEEDSTR = "5138,320,09:46:39.9999";
    private boolean debugOutput = false;

    public SeedBlockette() {
        this.setupBlockette();
    }

    public SeedBlockette(String blktInfo, SeedLookupMap lm) {
        this();
        this.lookupMap = lm;
        this.fromString(blktInfo);
    }

    public SeedBlockette(BufferedReader rd, int blktType) throws ParseStageException {
        this();
        this.setType(blktType);
        this.parseResp(this.getType(), rd);
        int i = 0;
        while (i < this.respFieldNames.size()) {
            String keyName = (String)this.respFieldNames.get(i);
            if (!this.containsKey(keyName)) {
                throw new ParseStageException("'" + keyName + "' not found");
            }
            ++i;
        }
    }

    public SeedBlockette(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        this();
        this.lookupMap = lm;
        this.parseResp(blktType, rd);
        int i = 0;
        while (i < this.respFieldNames.size()) {
            String keyName = (String)this.respFieldNames.get(i);
            if (!this.containsKey(keyName)) {
                throw new ParseStageException("'" + keyName + "' not found");
            }
            ++i;
        }
    }

    public boolean isType(int btype) {
        return this.blocketteType == btype;
    }

    public int getType() {
        return this.blocketteType;
    }

    public static boolean isType(String blktInfo, int btype) {
        int test;
        try {
            test = new Integer(blktInfo.substring(0, 3));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return test == btype;
    }

    public static int getType(String blktInfo) {
        try {
            int test = new Integer(blktInfo.substring(0, 3));
            return test;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public abstract String toString(boolean var1, boolean var2);

    abstract boolean fromString(String var1);

    abstract void setupBlockette();

    public abstract String objToCompString();

    public abstract void compStringToObj(String var1, SeedLookupMap var2);

    public String toString() {
        return this.toString(true, true);
    }

    public String getParamString() {
        return this.toString(true, false);
    }

    public String getListParamString() {
        return this.toString(false, true);
    }

    private String getStringVal(String line, String prefSep) {
        String val = null;
        Object startVal = null;
        Object st = null;
        int idx = line.indexOf(prefSep);
        if (idx >= 0) {
            String subString = line.substring(idx + 1);
            val = subString.trim();
        }
        return val;
    }

    private ArrayList getListOfVals(String line, int startFld, int endFld, ArrayList dataTypes) {
        ArrayList<Object> vals = new ArrayList<Object>();
        StringTokenizer st = null;
        int fldNo = -1;
        int fldIdx = 0;
        if (startFld < 0) {
            return null;
        }
        st = new StringTokenizer(line);
        while (st.hasMoreTokens()) {
            if (fldNo >= startFld && fldNo <= endFld) {
                int dataType = (Integer)dataTypes.get(fldIdx);
                switch (dataType) {
                    case 0: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        vals.add(st.nextToken());
                        break;
                    }
                    case 1: {
                        vals.add(new Integer(Format.atoi(st.nextToken())));
                        break;
                    }
                    case 2: {
                        vals.add(new Double(Format.atof(st.nextToken())));
                        break;
                    }
                    case 3: {
                        vals.add(TimeStamp.buildTimestamp(st.nextToken()));
                        break;
                    }
                }
                ++fldIdx;
            } else {
                st.nextToken();
            }
            ++fldNo;
        }
        if (--fldNo != endFld) {
            return null;
        }
        return vals;
    }

    protected void setType(int val) {
        this.blocketteType = val;
    }

    public long getElfHash(String strVal) {
        long h = 0L;
        byte[] strBytes = strVal.getBytes();
        int byteLen = strBytes.length;
        int i = 0;
        while (i < byteLen) {
            long g = (h = (h << 4) + (long)strBytes[i]) & 0xFFFFFFFFF0000000L;
            if (g != 0L) {
                h ^= g >> 24;
            }
            h &= g ^ 0xFFFFFFFFFFFFFFFFL;
            ++i;
        }
        return h;
    }

    public long getElfHash() {
        return this.getElfHash(this.toString());
    }

    public long getParamElfHash() {
        return this.getElfHash(this.getParamString());
    }

    public long getListParamElfHash() {
        return this.getElfHash(this.getListParamString());
    }

    /*
     * Unable to fully structure code
     */
    public void echoResp() {
        fmt2_2d = new Format("%2.2d");
        fmt3_3d = new Format("%3.3d");
        fmt4d = new Format("%4d");
        fmt10s = new Format("%-10s");
        fieldOutStr = "";
        comparator = new AlphaComparator();
        keys = this.paramLookup.keySet();
        keyVals = keys.toArray();
        Arrays.sort(keyVals, comparator);
        i = 0;
        while (i < keyVals.length) {
            block35: {
                block38: {
                    block37: {
                        block36: {
                            keyVal = (String)keyVals[i];
                            lookupVal = (String)this.paramLookup.get(keyVals[i]);
                            if (!this.respFieldNames.contains(lookupVal)) break block35;
                            prefStr = "B" + fmt3_3d.format(this.getType()) + "F" + keyVal;
                            fldFormat = new Format((String)this.paramOutputType.get(lookupVal));
                            dataType = (Integer)this.paramInputType.get(lookupVal);
                            if (dataType != 2) break block36;
                            fieldOutStr = fldFormat.format((Double)this.get(lookupVal));
                            ** GOTO lbl62
                        }
                        if (dataType != 1) break block37;
                        fieldOutStr = fldFormat.format((Integer)this.get(lookupVal));
                        ** GOTO lbl62
                    }
                    if (dataType != 3) break block38;
                    tmpStr = ((TimeStamp)this.get(lookupVal)).toSeedString();
                    if (lookupVal.startsWith("End") && tmpStr.compareTo("5138,320,09:46:39.9999") == 0) {
                        tmpStr = "No Ending Time";
                    }
                    fieldOutStr = fldFormat.format(tmpStr);
                    ** GOTO lbl62
                }
                if (dataType == 4) {
                    blkt = (Blockette30)this.get(lookupVal);
                    compareBlkt = new Blockette30();
                    compareBlkt.compStringToObj(blkt.objToCompString(), this.lookupMap);
                    lookupIdx = this.lookupMap.getLookup(4, compareBlkt);
                    System.out.println(String.valueOf(fmt10s.format(prefStr)) + " " + lookupVal + ": " + lookupIdx);
                    blkt.echoResp(new Integer(lookupIdx));
                } else if (dataType == 6) {
                    blkt = (Blockette31)this.get(lookupVal);
                    compareBlkt = new Blockette31();
                    compareBlkt.compStringToObj(blkt.objToCompString(), this.lookupMap);
                    lookupIdx = this.lookupMap.getLookup(6, compareBlkt);
                    System.out.println(String.valueOf(fmt10s.format(prefStr)) + " " + lookupVal + ": " + lookupIdx);
                    blkt.echoResp(new Integer(lookupIdx));
                } else if (dataType == 5) {
                    blkt = (Blockette32)this.get(lookupVal);
                    compareBlkt = new Blockette32();
                    compareBlkt.compStringToObj(blkt.objToCompString(), this.lookupMap);
                    lookupIdx = this.lookupMap.getLookup(5, compareBlkt);
                    System.out.println(String.valueOf(fmt10s.format(prefStr)) + " " + lookupVal + ": " + lookupIdx);
                    blkt.echoResp(new Integer(lookupIdx));
                } else {
                    if (dataType == 7) {
                        genAbbrev = (Blockette33)this.get(lookupVal);
                        fieldOutStr = genAbbrev.objToCompString();
                    } else {
                        fieldOutStr = dataType == 8 ? ((unitsAbbrev = (Blockette34)this.get(lookupVal)) == null ? "" : unitsAbbrev.objToCompString()) : ((testStr = (String)this.get(lookupVal)) == null ? fldFormat.format("") : fldFormat.format(testStr));
                    }
lbl62:
                    // 5 sources

                    System.out.println(String.valueOf(fmt10s.format(prefStr)) + " " + lookupVal + ": " + fieldOutStr);
                }
            }
            ++i;
        }
        keys = this.multiParamLookup.keySet();
        keyVals = keys.toArray();
        Arrays.sort(keyVals, comparator);
        i = 0;
        while (i < keyVals.length) {
            keyVal = (String)keyVals[i];
            lookupVal = (String)this.multiParamLookup.get(keyVals[i]);
            prefStr = "B" + fmt3_3d.format(this.getType()) + "F" + keyVal;
            valList = (ArrayList)this.get(lookupVal);
            fldFormat = new Format((String)this.multiParamOutputType.get(lookupVal));
            dataType = (Integer)this.multiParamInputType.get(lookupVal);
            tag = (String)this.multiParamOutputTag.get(lookupVal);
            j = 0;
            while (j < valList.size()) {
                block41: {
                    block40: {
                        block39: {
                            outStr = String.valueOf(fmt10s.format(prefStr)) + "\t" + tag + " " + fmt4d.format(j) + ": ";
                            if (dataType != 2) break block39;
                            outStr = String.valueOf(outStr) + fldFormat.format((Double)valList.get(j));
                            ** GOTO lbl110
                        }
                        if (dataType != 1) break block40;
                        outStr = String.valueOf(outStr) + fldFormat.format((Integer)valList.get(j));
                        ** GOTO lbl110
                    }
                    if (dataType != 3) break block41;
                    tmpTime = (TimeStamp)valList.get(j);
                    outStr = lookupVal.startsWith("End") && tmpTime.toEpochString().compareTo("99999999999.9999") == 0 ? "No_Ending_Time" : fldFormat.format(tmpTime.toSeedString());
                    ** GOTO lbl110
                }
                if (dataType == 4) {
                    blkt = (Blockette30)this.get(lookupVal);
                    lookupIdx = this.lookupMap.getLookup(4, blkt);
                    System.out.println(String.valueOf(fmt10s.format(prefStr)) + " " + lookupVal + ": " + lookupIdx);
                    blkt.echoResp();
                } else {
                    if (dataType != 5 && dataType != 6) {
                        if (dataType == 7) {
                            genAbbrev = (Blockette33)this.get(lookupVal);
                            outStr = String.valueOf(outStr) + genAbbrev.objToCompString();
                        } else if (dataType == 8) {
                            unitsAbbrev = (Blockette34)this.get(lookupVal);
                            outStr = String.valueOf(outStr) + unitsAbbrev.objToCompString();
                        } else {
                            outStr = String.valueOf(outStr) + fldFormat.format((String)valList.get(j));
                        }
                    }
lbl110:
                    // 8 sources

                    System.out.println(outStr);
                }
                ++j;
            }
            ++i;
        }
        keys = this.listParamLookup.keySet();
        keyVals = keys.toArray();
        Arrays.sort(keyVals, comparator);
        i = 0;
        while (i < keyVals.length) {
            keyVal = (String)keyVals[i];
            lookupVal = (String)this.listParamLookup.get(keyVals[i]);
            prefStr = "B" + fmt3_3d.format(this.getType()) + "F" + keyVal;
            valList = (ArrayList)this.get(lookupVal);
            inputFormatList = (ArrayList)this.listParamInputTypes.get(lookupVal);
            formatList = (ArrayList)this.listParamOutputTypes.get(lookupVal);
            j = 0;
            while (j < valList.size()) {
                vals = (ArrayList)valList.get(j);
                outStr = String.valueOf(fmt10s.format(prefStr)) + " " + fmt4d.format(j);
                k = 0;
                while (k < vals.size()) {
                    fldFormat = new Format((String)formatList.get(k));
                    dataType = (Integer)inputFormatList.get(k);
                    outStr = String.valueOf(outStr) + " ";
                    if (dataType == 2) {
                        outStr = String.valueOf(outStr) + fldFormat.format((Double)vals.get(k));
                    } else if (dataType == 1) {
                        outStr = String.valueOf(outStr) + fldFormat.format((Integer)vals.get(k));
                    } else if (dataType == 3) {
                        tmpTime = (TimeStamp)vals.get(k);
                        outStr = String.valueOf(outStr) + fldFormat.format(tmpTime.toSeedString());
                    } else if (dataType == 4) {
                        blkt = (Blockette30)this.get(lookupVal);
                        lookupIdx = this.lookupMap.getLookup(4, blkt);
                        outStr = String.valueOf(outStr) + fldFormat.format(lookupIdx);
                    } else if (dataType != 5 && dataType != 6) {
                        if (dataType == 7) {
                            blkt = (Blockette33)this.get(lookupVal);
                            lookupIdx = this.lookupMap.getLookup(7, blkt);
                            outStr = String.valueOf(outStr) + fldFormat.format(lookupIdx);
                        } else if (dataType == 8) {
                            blkt = (Blockette34)this.get(lookupVal);
                            lookupIdx = this.lookupMap.getLookup(8, blkt);
                            outStr = String.valueOf(outStr) + fldFormat.format(lookupIdx);
                        } else {
                            outStr = String.valueOf(outStr) + fldFormat.format((String)vals.get(k));
                        }
                    }
                    ++k;
                }
                System.out.println(outStr);
                ++j;
            }
            ++i;
        }
    }

    public void echoResp(Integer lookupIdx) {
        Integer oldIdx = null;
        boolean resetIdx = false;
        if (this.idxFieldNames != "") {
            oldIdx = this.put(this.idxFieldNames, lookupIdx);
            resetIdx = true;
        }
        this.echoResp();
        if (resetIdx) {
            this.put(this.idxFieldNames, oldIdx);
        }
    }

    public static Vector parseSeedBlockette(BufferedReader bpr, SeedLookupMap lm) throws ParseStageException, IOException {
        Vector<SeedBlockette> vec = new Vector<SeedBlockette>();
        SeedBlockette blkt = null;
        char[] blk = new char[4];
        int blktNum = 0;
        int nread = -1;
        bpr.mark(4);
        int count = 0;
        while ((nread = bpr.read(blk)) == 4) {
            bpr.reset();
            if (blk[0] == 'B') {
                blktNum = Integer.parseInt(new String(blk, 1, 3));
            }
            switch (blktNum) {
                case 10: {
                    blkt = new Blockette10(bpr, lm, blktNum);
                    break;
                }
                case 11: {
                    blkt = new Blockette11(bpr, lm, blktNum);
                    break;
                }
                case 12: {
                    blkt = new Blockette12(bpr, lm, blktNum);
                    break;
                }
                case 30: {
                    blkt = new Blockette30(bpr, lm, blktNum);
                    break;
                }
                case 31: {
                    blkt = new Blockette31(bpr, lm, blktNum);
                    break;
                }
                case 32: {
                    blkt = new Blockette32(bpr, lm, blktNum);
                    break;
                }
                case 33: {
                    blkt = new Blockette33(bpr, lm, blktNum);
                    break;
                }
                case 34: {
                    blkt = new Blockette34(bpr, lm, blktNum);
                    break;
                }
                case 50: {
                    blkt = new Blockette50(bpr, lm, blktNum);
                    break;
                }
                case 51: {
                    blkt = new Blockette51(bpr, lm, blktNum);
                    break;
                }
                case 52: {
                    blkt = new Blockette52(bpr, lm, blktNum);
                    break;
                }
                case 53: {
                    blkt = new Blockette53(bpr, lm, blktNum);
                    break;
                }
                case 54: {
                    blkt = new Blockette54(bpr, lm, blktNum);
                    if (++count != 45) break;
                    System.out.println("dfdsfsdf" + count);
                    break;
                }
                case 55: {
                    blkt = new Blockette55(bpr, lm, blktNum);
                    break;
                }
                case 57: {
                    blkt = new Blockette57(bpr, lm, blktNum);
                    break;
                }
                case 58: {
                    blkt = new Blockette58(bpr, lm, blktNum);
                    break;
                }
                case 59: {
                    blkt = new Blockette59(bpr, lm, blktNum);
                    break;
                }
                case 61: {
                    blkt = new Blockette61(bpr, lm, blktNum);
                    break;
                }
                case 70: {
                    blkt = new Blockette70(bpr, lm, blktNum);
                    break;
                }
                case 71: {
                    blkt = new Blockette71(bpr, lm, blktNum);
                    break;
                }
                case 72: {
                    blkt = new Blockette72(bpr, lm, blktNum);
                    break;
                }
                case 73: {
                    blkt = new Blockette73(bpr, lm, blktNum);
                    break;
                }
                case 74: {
                    blkt = new Blockette74(bpr, lm, blktNum);
                }
            }
            bpr.mark(4);
            System.out.println(blkt.toString());
            vec.add(blkt);
        }
        return vec;
    }

    public boolean parseResp(BufferedReader rd) throws ParseStageException {
        return this.parseResp(-1, rd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parseResp(int blktNum, BufferedReader rd) throws ParseStageException {
        Format fmt3_3d = new Format("%3.3d");
        String blktPref = null;
        ArrayList<String> paramPrefixVals = null;
        ArrayList<String> listParamPrefixVals = null;
        char[] buf = new char[1];
        boolean bFirst = true;
        int totPrefLength = 10;
        char[] prefixRead = new char[totPrefLength];
        try {
            int testVal;
            rd.mark(2);
            while ((testVal = rd.read(buf, 0, 1)) != -1 && (buf[0] == 'B' || buf[0] == '#')) {
                SeedBlockette blkt;
                String lineVal;
                int mapType;
                String mapName;
                String line;
                if (buf[0] == '#') {
                    line = rd.readLine();
                    rd.mark(2);
                    continue;
                }
                rd.reset();
                rd.mark(totPrefLength);
                if (rd.read(prefixRead, 0, totPrefLength) != totPrefLength) {
                    rd.reset();
                    throw new ParseStageException("Unexpected end of prefix while parsing '" + new String(buf) + "'");
                }
                String prefVal = new String(prefixRead).trim();
                if (bFirst) {
                    String tmpStr;
                    Object keyVal;
                    blktPref = prefVal.substring(0, 4);
                    paramPrefixVals = new ArrayList<String>();
                    Set keys = this.paramLookup.keySet();
                    Iterator keyIterator = keys.iterator();
                    while (keyIterator.hasNext()) {
                        keyVal = keyIterator.next();
                        tmpStr = String.valueOf(blktPref) + "F" + (String)keyVal;
                        paramPrefixVals.add(tmpStr);
                    }
                    listParamPrefixVals = new ArrayList<String>();
                    keys = this.listParamLookup.keySet();
                    keyIterator = keys.iterator();
                    while (keyIterator.hasNext()) {
                        keyVal = keyIterator.next();
                        tmpStr = String.valueOf(blktPref) + "F" + (String)keyVal;
                        listParamPrefixVals.add(tmpStr);
                    }
                }
                if (!prefVal.startsWith(blktPref)) {
                    rd.reset();
                    break;
                }
                if (prefVal.startsWith(String.valueOf(blktPref) + "F03") && !bFirst) {
                    rd.reset();
                    break;
                }
                if (bFirst) {
                    bFirst = false;
                }
                line = String.valueOf(prefVal) + rd.readLine();
                String fldLookupVal = prefVal.substring(5);
                if (this.paramLookup.containsKey(fldLookupVal)) {
                    mapName = (String)this.paramLookup.get(fldLookupVal);
                    mapType = (Integer)this.paramInputType.get(mapName);
                    lineVal = this.getStringVal(line, ":");
                    if (lineVal == null && (mapType == 0 || mapType == 7)) {
                        lineVal = "";
                    } else if (lineVal == null) {
                        throw new ParseStageException("Error while parsing '" + line + "'");
                    }
                    switch (mapType) {
                        case 4: {
                            blkt = new Blockette30(rd, 30);
                            if (this.debugOutput) {
                                System.out.println(blkt);
                                System.out.println(blkt.objToCompString());
                            }
                            SeedBlockette cblkt = new Blockette30();
                            cblkt.compStringToObj(blkt.objToCompString(), this.lookupMap);
                            if (this.debugOutput) {
                                System.out.println(cblkt);
                            }
                            this.lookupMap.getLookup(4, cblkt);
                            this.put(mapName, blkt);
                            break;
                        }
                        case 6: {
                            blkt = new Blockette31(rd, this.lookupMap, 31);
                            if (this.debugOutput) {
                                System.out.println(blkt);
                                System.out.println(blkt.objToCompString());
                            }
                            SeedBlockette cblkt = new Blockette31();
                            cblkt.compStringToObj(blkt.objToCompString(), this.lookupMap);
                            if (this.debugOutput) {
                                System.out.println(cblkt);
                            }
                            int testIdx = this.lookupMap.getLookup(6, cblkt);
                            if (this.debugOutput) {
                                System.out.println(cblkt + " added at index #" + testIdx);
                            }
                            this.put(mapName, blkt);
                            break;
                        }
                        case 5: {
                            blkt = new Blockette32(rd, this.lookupMap, 32);
                            if (this.debugOutput) {
                                System.out.println(blkt);
                                System.out.println(blkt.objToCompString());
                            }
                            SeedBlockette cblkt = new Blockette32();
                            cblkt.compStringToObj(blkt.objToCompString(), this.lookupMap);
                            if (this.debugOutput) {
                                System.out.println(cblkt);
                            }
                            int testIdx = this.lookupMap.getLookup(5, cblkt);
                            if (this.debugOutput) {
                                System.out.println(cblkt + " added at index #" + testIdx);
                            }
                            this.put(mapName, blkt);
                            break;
                        }
                        case 7: {
                            blkt = new Blockette33();
                            blkt.compStringToObj(lineVal, this.lookupMap);
                            if (this.debugOutput) {
                                System.out.println(blkt.objToCompString());
                            }
                            SeedBlockette cblkt = new Blockette33();
                            cblkt.compStringToObj(blkt.objToCompString(), this.lookupMap);
                            if (this.debugOutput) {
                                System.out.println(cblkt);
                            }
                            this.lookupMap.getLookup(7, cblkt);
                            this.put(mapName, blkt);
                            break;
                        }
                        case 8: {
                            if (lineVal == null || lineVal.length() == 0) {
                                this.put(mapName, null);
                                break;
                            }
                            blkt = new Blockette34();
                            blkt.compStringToObj(lineVal, this.lookupMap);
                            if (this.debugOutput) {
                                System.out.println(blkt.objToCompString());
                            }
                            SeedBlockette cblkt = new Blockette34();
                            cblkt.compStringToObj(blkt.objToCompString(), this.lookupMap);
                            if (this.debugOutput) {
                                System.out.println(cblkt);
                            }
                            int testIdx = this.lookupMap.getLookup(8, cblkt);
                            if (this.debugOutput) {
                                System.out.println(cblkt + " added at index #" + testIdx);
                            }
                            this.put(mapName, blkt);
                            break;
                        }
                        case 0: {
                            this.put(mapName, new String(lineVal));
                            break;
                        }
                        case 3: {
                            if (lineVal.length() == 0) {
                                if (mapName.startsWith("Start")) {
                                    this.put(mapName, TimeStamp.buildTimestamp("0.0"));
                                    break;
                                }
                                if (mapName.startsWith("End")) {
                                    this.put(mapName, TimeStamp.buildTimestamp(MAXEPOCHSTR));
                                }
                                break;
                            } else {
                                TimeStamp ts = TimeStamp.buildTimestamp(lineVal);
                                if (ts == null) {
                                    this.put(mapName, TimeStamp.buildTimestamp(MAXEPOCHSTR));
                                    break;
                                }
                                this.put(mapName, ts);
                                break;
                            }
                        }
                        case 1: {
                            this.put(mapName, new Integer(Format.atoi(lineVal)));
                            break;
                        }
                        case 2: {
                            this.put(mapName, new Double(Format.atof(lineVal)));
                            break;
                        }
                    }
                } else if (this.multiParamLookup.containsKey(fldLookupVal)) {
                    mapName = (String)this.multiParamLookup.get(fldLookupVal);
                    mapType = (Integer)this.multiParamInputType.get(mapName);
                    lineVal = this.getStringVal(line, ":");
                    if (lineVal == null) {
                        throw new ParseStageException("Error while parsing '" + line + "'");
                    }
                    switch (mapType) {
                        case 4: {
                            blkt = new Blockette30(rd, 30);
                            this.lookupMap.getLookup(4, blkt);
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: {
                            blkt = new Blockette33();
                            blkt.compStringToObj(lineVal, this.lookupMap);
                            this.lookupMap.getLookup(7, blkt);
                            break;
                        }
                        case 8: {
                            blkt = new Blockette34();
                            blkt.compStringToObj(lineVal, this.lookupMap);
                            this.lookupMap.getLookup(8, blkt);
                            break;
                        }
                        case 0: {
                            ((ArrayList)this.get(mapName)).add(new String(lineVal));
                            break;
                        }
                        case 1: {
                            ((ArrayList)this.get(mapName)).add(new Integer(Format.atoi(lineVal)));
                            break;
                        }
                        case 2: {
                            ((ArrayList)this.get(mapName)).add(new Double(Format.atof(lineVal)));
                            break;
                        }
                        case 3: {
                            ((ArrayList)this.get(mapName)).add(TimeStamp.buildTimestamp(lineVal));
                            break;
                        }
                    }
                } else if (this.listParamLookup.containsKey(fldLookupVal)) {
                    mapName = (String)this.listParamLookup.get(fldLookupVal);
                    ArrayList mapListType = (ArrayList)this.listParamInputTypes.get(mapName);
                    int lastFldNo = 0;
                    int firstFldNo = 0;
                    int dashPos = fldLookupVal.indexOf("-");
                    if (dashPos >= 0) {
                        int lastIdx = dashPos + 1;
                        firstFldNo = new Integer(fldLookupVal.substring(0, lastIdx - 1));
                        lastFldNo = new Integer(fldLookupVal.substring(lastIdx));
                    } else {
                        lastFldNo = firstFldNo = new Integer(fldLookupVal).intValue();
                    }
                    int nflds = lastFldNo - firstFldNo + 1;
                    if (nflds < 1) {
                        throw new ParseStageException("Error while parsing user supplied lookup value '" + prefVal + "'");
                    }
                    ArrayList lineVals = this.getListOfVals(line, 1, nflds, mapListType);
                    ((ArrayList)this.get(mapName)).add(lineVals);
                }
                rd.mark(2);
            }
            if (testVal != -1 && buf[0] != 'B' && buf[0] != '#') {
                rd.reset();
                String lastLine = rd.readLine();
                throw new ParseStageException("line '" + lastLine + "' has an illegal prefix (only 'B' " + "and '#' are legal)");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.setType(blktNum);
        return true;
    }

    public boolean equals(Object objVal) {
        SeedBlockette val = (SeedBlockette)objVal;
        String description = this.objToCompString();
        String valDescription = val.objToCompString();
        if (description == null && valDescription == null) {
            return true;
        }
        if (description == null || valDescription == null) {
            return false;
        }
        return description.compareTo(valDescription) == 0;
    }

    public void setLookupMap(SeedLookupMap lm) {
        this.lookupMap = lm;
    }

    public SeedLookupMap getLookupMap() {
        return this.lookupMap;
    }
}

