/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.seedutils.PodWriter;
import edu.iris.seedutils.SeedDataRecord;
import edu.iris.seedutils.SeedFormatException;
import edu.iris.seedutils.SeedPod;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class SeedBlocketteReader
implements SeedPod {
    private String headerDir = "HAR000";
    private int logicalRecLen;
    private byte[] buffer;
    private int offset = 0;
    private boolean fullSEED = true;
    PodWriter pw = null;

    public SeedBlocketteReader() {
    }

    public SeedBlocketteReader(String headDir) {
        this.headerDir = headDir;
    }

    public RandomAccessFile openMiniSeedFile(String fname) {
        RandomAccessFile file_in = null;
        try {
            file_in = new RandomAccessFile(fname, "r");
        }
        catch (IOException e) {
            System.out.println("SeedBlocketteReader: " + e.getMessage());
            return null;
        }
        this.setFullSEED(false);
        return file_in;
    }

    public RandomAccessFile openSeedVolume(String fname) throws SeedFormatException {
        RandomAccessFile file_in = null;
        String vol_id = "000001V";
        try {
            file_in = new RandomAccessFile(fname, "r");
            byte[] lcl_buffer = new byte[21];
            int num_bytes_read = file_in.read(lcl_buffer, 0, 21);
            String wrkstr = null;
            if (num_bytes_read != 21) {
                this.setFullSEED(false);
                throw new SeedFormatException("cannot read volume ID from input file '" + fname + "'");
            }
            wrkstr = new String(lcl_buffer, 0, 7);
            if (wrkstr.compareTo(vol_id) != 0) {
                this.setFullSEED(false);
                throw new SeedFormatException("first 7 bytes from input file '" + fname + "' don't look like a volume ID");
            }
            this.logicalRecLen = 1 << new Integer(new String(lcl_buffer, 19, 2));
            this.buffer = new byte[this.logicalRecLen];
            file_in.seek(0L);
        }
        catch (IOException e) {
            System.out.println("SeedBlocketteReader.openSeedVolume(): " + e.getMessage());
            return null;
        }
        this.setFullSEED(true);
        return file_in;
    }

    public int getLogRecSize() {
        return this.logicalRecLen;
    }

    public char readLogicalRecord(RandomAccessFile file_in) {
        try {
            int i = 0;
            while (i < this.buffer.length) {
                this.buffer[i] = 32;
                ++i;
            }
            int num_bytes_read = file_in.read(this.buffer, 0, this.logicalRecLen);
        }
        catch (IOException e) {
            System.out.println("SeedBlocketteReader.readLogicalRecord(): " + e.getMessage());
        }
        this.offset = 8;
        return (char)this.buffer[6];
    }

    public String getSeedBlkt(RandomAccessFile file_in) {
        String block;
        char header_type = '\u0000';
        try {
            if (file_in.getFilePointer() >= file_in.length() && (this.offset == 0 || this.offset > this.logicalRecLen - 7)) {
                return new String();
            }
        }
        catch (IOException e) {
            System.out.println("SeedBlocketteReader.getSeedBlkt(): " + e.getMessage());
            return new String();
        }
        if (this.offset == 0 || this.offset > this.logicalRecLen - 7) {
            header_type = this.readLogicalRecord(file_in);
        }
        if (header_type == 'D' || header_type == 'Q' || header_type == 'R') {
            try {
                file_in.seek(file_in.getFilePointer() - (long)this.logicalRecLen);
            }
            catch (IOException e) {
                System.out.println("SeedBlocketteReader.getSeedBlkt(): " + e.getMessage());
            }
            return new String();
        }
        String blk_length = new String(this.buffer, this.offset + 3, 4).trim();
        if (blk_length.length() <= 0) {
            header_type = this.readLogicalRecord(file_in);
            blk_length = new String(this.buffer, this.offset + 3, 4).trim();
        }
        if (header_type == 'D' || header_type == 'Q' || header_type == 'R') {
            try {
                file_in.seek(file_in.getFilePointer() - (long)this.logicalRecLen);
            }
            catch (IOException e) {
                System.out.println("SeedBlocketteReader.getSeedBlkt(): " + e.getMessage());
            }
            return new String();
        }
        if (blk_length.length() <= 0) {
            return new String();
        }
        Integer len = new Integer(blk_length.trim());
        if (len + this.offset < this.logicalRecLen) {
            block = new String(this.buffer, this.offset, (int)len);
            this.offset += len.intValue();
        } else {
            char[] now_blockette = new char[len.intValue()];
            int i = this.offset;
            int ptr = 0;
            while (ptr < len) {
                now_blockette[ptr] = (char)this.buffer[i];
                if (++i >= this.logicalRecLen) {
                    this.readLogicalRecord(file_in);
                    i = this.offset;
                }
                ++ptr;
            }
            this.offset = i;
            block = new String(now_blockette);
        }
        return block;
    }

    public boolean putSeedBlkt(RandomAccessFile file_out, String buffer) {
        return false;
    }

    public void closeSeedVolume(RandomAccessFile file_in) {
        try {
            file_in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getPodBlkt(RandomAccessFile file_in) {
        return null;
    }

    public ArrayList getNextLogicalRecDRList(RandomAccessFile f) throws SeedFormatException, IOException {
        ArrayList<SeedDataRecord> dataRecordList = new ArrayList<SeedDataRecord>();
        byte[] bytes = null;
        byte[] thisRecBytes = null;
        byte[] nextRecBytes = null;
        if (this.isFullSEED()) {
            int dataRecLen;
            bytes = new byte[this.getLogRecSize()];
            int num_bytes_read = 0;
            try {
                do {
                    num_bytes_read = f.read(bytes, 0, bytes.length);
                } while (bytes[6] != 68 && bytes[6] != 81 && bytes[6] != 82 && num_bytes_read > 0);
            }
            catch (IOException e) {
                System.out.println("SeedBlocketteReader.getNextLogicalRecDRList():" + e.getMessage());
            }
            if (bytes[6] != 68 && bytes[6] != 81 && bytes[6] != 82 || num_bytes_read == 0) {
                return null;
            }
            int dataBlktBytesRead = 0;
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            do {
                byte[] dataRecBytes;
                if (dataBlktBytesRead == 0) {
                    dataRecBytes = new byte[bytes.length];
                    System.arraycopy(bytes, 0, dataRecBytes, 0, bytes.length);
                } else {
                    dataRecBytes = new byte[bytes.length - dataBlktBytesRead];
                    System.arraycopy(bytes, dataBlktBytesRead, dataRecBytes, 0, bytes.length - dataBlktBytesRead);
                }
                dataRecLen = SeedDataRecord.findRecordLength(dataRecBytes);
                byte[] dataRec = new byte[dataRecLen];
                if (bis.read(dataRec, 0, dataRecLen) < dataRecLen) {
                    System.out.println("SeedBlocketteReader.getNextLogicalRecDRList():  error reading ByteArrayInputStream while scanning for\nnext record (unexpected end of buffer)");
                    System.exit(-1);
                }
                dataRecordList.add(new SeedDataRecord(dataRec));
            } while ((dataBlktBytesRead += dataRecLen) < bytes.length);
            return dataRecordList;
        }
        bytes = new byte[this.getNextDataRecSize(f)];
        return dataRecordList;
    }

    private int getNextDataRecSize(RandomAccessFile f) {
        byte[] fsdhBuff = new byte[48];
        try {
            long currPos = f.getFilePointer();
            int i = 0;
            while (i < fsdhBuff.length) {
                fsdhBuff[i] = 32;
                ++i;
            }
            int num_bytes_read = f.read(fsdhBuff, 0, fsdhBuff.length);
            f.seek(currPos);
        }
        catch (IOException e) {
            System.out.println("SeedBlocketteReader.getNextDataRecSize(): " + e.getMessage());
            System.exit(-1);
        }
        return 4096;
    }

    public boolean putPodBlkt(String buffer) {
        if (this.pw == null) {
            this.pw = new PodWriter(this.headerDir);
        }
        if (this.pw == null) {
            return false;
        }
        if (buffer.substring(0, 3).compareTo("050") == 0) {
            this.pw.newStation(buffer.substring(7, 12).trim(), buffer.substring(buffer.length() - 2, buffer.length()).trim());
        }
        this.pw.write(buffer);
        return true;
    }

    public boolean putPodBlkt(byte[] buff) {
        if (this.pw == null) {
            this.pw = new PodWriter("data_files");
        }
        this.pw.write(buff);
        return true;
    }

    public void podSetPath(String path) {
        if (this.pw == null) {
            this.pw = new PodWriter(path);
        } else {
            this.pw.set_CWD(path);
        }
    }

    public void closePodFile() {
        this.pw.close();
    }

    public boolean isFullSEED() {
        return this.fullSEED;
    }

    public void setFullSEED(boolean v) {
        this.fullSEED = v;
    }

    public static void main(String[] args) {
        RandomAccessFile file_in;
        SeedBlocketteReader reader;
        block9: {
            reader = new SeedBlocketteReader();
            boolean logicalRecLen = false;
            boolean nextBuffSize = false;
            try {
                file_in = reader.openSeedVolume(args[0]);
                if (file_in == null) {
                    System.out.println("File " + args[0] + " cannot be opened\nExiting.. .");
                    reader.closeSeedVolume(file_in);
                    System.exit(-1);
                }
            }
            catch (SeedFormatException e) {
                file_in = reader.openMiniSeedFile(args[0]);
                if (file_in != null) break block9;
                System.out.println("File " + args[0] + " is not a full SEED or miniSEED volume\n" + "Exiting.. .");
                reader.closeSeedVolume(file_in);
                System.exit(-1);
            }
        }
        boolean isFullSEED = reader.isFullSEED();
        String blk = null;
        while (isFullSEED && (blk = reader.getSeedBlkt(file_in)).length() > 0) {
            System.err.println(blk);
            reader.putPodBlkt(blk);
            blk = null;
        }
        reader.podSetPath("data_files");
        try {
            ArrayList dataRecordList;
            while ((dataRecordList = reader.getNextLogicalRecDRList(file_in)) != null) {
                int numRecs = dataRecordList.size();
                int i = 0;
                while (i < numRecs) {
                    System.err.println((SeedDataRecord)dataRecordList.get(i));
                    byte[] buff = ((SeedDataRecord)dataRecordList.get(i)).getBytes();
                    reader.putPodBlkt(buff);
                    ++i;
                }
            }
        }
        catch (SeedFormatException seedFormatException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        reader.closePodFile();
        reader.closeSeedVolume(file_in);
        System.exit(0);
    }
}

