/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.Blockette100;
import edu.iris.seedutils.Blockette1000;
import edu.iris.seedutils.Converter;
import edu.iris.seedutils.DataBlockette;
import edu.iris.seedutils.DataBlocketteHeader;
import edu.iris.seedutils.SeedFormatException;
import edu.iris.timeutils.TimeStamp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class SeedDataRecord {
    private byte[] fsdh;
    private ArrayList dataBlocketteList;
    private byte[] dataRecord;
    private boolean byteSwap;
    private Format fmt2_2d = new Format("%2.2d");
    private Format fmt3_3d = new Format("%3.3d");
    private Format fmt4_4d = new Format("%4.4d");
    private Format fmt5s = new Format("%5s");
    private Format fmt3s = new Format("%3s");
    private Format fmt2s = new Format("%2s");
    private Converter converter = new Converter();
    private static final int FSDH_SIZE = 48;
    private static final int DBH_SIZE = 4;
    private static final int BLKT100_SIZE = 12;
    private static final int BLKT1000_SIZE = 8;
    private static final int MSB_FIRST = 1985229328;
    private static final int MSB_LAST = 271733878;

    public SeedDataRecord(byte[] rec) throws SeedFormatException, IOException {
        this.dataRecord = rec;
        this.fsdh = new byte[48];
        ByteArrayInputStream bis = new ByteArrayInputStream(rec);
        int nbytesRead = 0;
        nbytesRead = bis.read(this.fsdh, 0, 48);
        if (nbytesRead != 48) {
            throw new IOException("SeedDataRecord():  invalid data record (can't built a complete FSDH)");
        }
        this.setByteSwapNeeded();
        this.dataBlocketteList = new ArrayList();
        int blocketteOffset = this.firstBlocketteOffset();
        while (blocketteOffset > 0) {
            if (blocketteOffset < 48) {
                throw new SeedFormatException("SeedDataRecord():  invalid data record (offset < size of FSDH found)");
            }
            bis.reset();
            bis.skip(blocketteOffset);
            byte[] dbh_bytes = new byte[4];
            nbytesRead = bis.read(dbh_bytes, 0, 4);
            if (nbytesRead != 4) {
                throw new IOException("SeedDataRecord():  invalid data record (incomplete data blockette found)");
            }
            DataBlocketteHeader dbh = new DataBlocketteHeader(dbh_bytes, this.byteSwap);
            switch (dbh.getType()) {
                case 100: {
                    byte[] bytes = new byte[8];
                    nbytesRead = bis.read(bytes, 0, bytes.length);
                    if (nbytesRead != bytes.length) {
                        throw new IOException("SeedDataRecord():  invalid data record (incomplete blkt_100 found)");
                    }
                    byte[] blktBytes = new byte[dbh.getBytes().length + bytes.length];
                    System.arraycopy(dbh.getBytes(), 0, blktBytes, 0, dbh.getBytes().length);
                    System.arraycopy(bytes, 0, blktBytes, dbh.getBytes().length, bytes.length);
                    Blockette100 blkt100 = new Blockette100(dbh, blktBytes);
                    this.dataBlocketteList.add(blkt100);
                    break;
                }
                case 1000: {
                    byte[] bytes = new byte[4];
                    nbytesRead = bis.read(bytes, 0, bytes.length);
                    if (nbytesRead != bytes.length) {
                        throw new IOException("SeedDataRecord():  invalid data record (incomplete blkt_1000 found)");
                    }
                    byte[] blktBytes = new byte[dbh.getBytes().length + bytes.length];
                    System.arraycopy(dbh.getBytes(), 0, blktBytes, 0, dbh.getBytes().length);
                    System.arraycopy(bytes, 0, blktBytes, dbh.getBytes().length, bytes.length);
                    Blockette1000 blkt1000 = new Blockette1000(dbh, blktBytes);
                    this.dataBlocketteList.add(blkt1000);
                }
            }
            blocketteOffset = dbh.nextDataBlocketteOffset();
        }
    }

    private void setByteSwapNeeded() {
        short year = this.converter.makeShort(this.fsdh[20], this.fsdh[21]);
        this.byteSwap = year >= 2080 || year <= 1950;
    }

    private boolean byteSwapNeeded() {
        return this.byteSwap;
    }

    public String station() {
        return new String(this.fsdh, 8, 5).trim();
    }

    public String locationID() {
        return new String(this.fsdh, 13, 2);
    }

    public String channel() {
        return new String(this.fsdh, 15, 3).trim();
    }

    public String network() {
        return new String(this.fsdh, 18, 2).trim();
    }

    public TimeStamp recordStartTime() {
        short year = this.converter.makeShort(this.fsdh[20], this.fsdh[21]);
        short day = this.converter.makeShort(this.fsdh[22], this.fsdh[23]);
        byte hr = this.fsdh[24];
        byte mn = this.fsdh[25];
        byte sec = this.fsdh[26];
        short frac = this.converter.makeShort(this.fsdh[28], this.fsdh[29]);
        if (this.byteSwapNeeded()) {
            year = this.converter.swapShort(year);
            day = this.converter.swapShort(day);
            frac = this.converter.swapShort(frac);
        }
        return TimeStamp.buildTimestamp(String.valueOf(this.fmt4_4d.format(year)) + "," + this.fmt3_3d.format(day) + "," + this.fmt2_2d.format(hr) + ":" + this.fmt2_2d.format(mn) + ":" + this.fmt2_2d.format(sec) + "." + this.fmt4_4d.format(frac));
    }

    public int numSamples() {
        short nsamp = this.converter.makeShort(this.fsdh[30], this.fsdh[31]);
        if (this.byteSwapNeeded()) {
            nsamp = this.converter.swapShort(nsamp);
        }
        return nsamp;
    }

    public static int findRecordLength(byte[] bytes) {
        try {
            SeedDataRecord dr = new SeedDataRecord(bytes);
            int numDataBlkts = dr.dataBlocketteList.size();
            int i = 0;
            while (i < numDataBlkts) {
                DataBlockette blkt = (DataBlockette)dr.dataBlocketteList.get(i);
                if (blkt.getType() == 1000) {
                    short recLenExp = ((Blockette1000)blkt).getRecordLength();
                    return (int)Math.pow(2.0, recLenExp);
                }
                ++i;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        }
        catch (SeedFormatException seedFormatException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 4096;
    }

    public short sampleRateFactor() {
        short srf = this.converter.makeShort(this.fsdh[32], this.fsdh[33]);
        if (this.byteSwapNeeded()) {
            srf = this.converter.swapShort(srf);
        }
        return srf;
    }

    public short sampleRateMultiplier() {
        short srm = this.converter.makeShort(this.fsdh[34], this.fsdh[35]);
        if (this.byteSwapNeeded()) {
            srm = this.converter.swapShort(srm);
        }
        return srm;
    }

    public float nominalSampleRate() {
        short srf = this.sampleRateFactor();
        short srm = this.sampleRateMultiplier();
        float nomSampRate = 0.0f;
        if (srf > 0 && srm > 0) {
            nomSampRate = srf * srm;
        } else if (srf > 0 && srm < 0) {
            nomSampRate = (float)(-1.0 * (double)srf / (double)srm);
        } else if (srf < 0 && srm > 0) {
            nomSampRate = (float)(-1.0 * (double)srm / (double)srf);
        } else if (srf < 0 && srm < 0) {
            nomSampRate = (float)(1.0 / (double)(srf * srm));
        }
        return nomSampRate;
    }

    public float sampleRate() {
        int numDataBlkts = this.dataBlocketteList.size();
        int i = 0;
        while (i < numDataBlkts) {
            DataBlockette blkt = (DataBlockette)this.dataBlocketteList.get(i);
            if (blkt.getType() == 100) {
                return ((Blockette100)blkt).getSampleRate();
            }
            ++i;
        }
        return this.nominalSampleRate();
    }

    public byte activityFlags() {
        return this.fsdh[36];
    }

    public byte ioAndClockFlags() {
        return this.fsdh[37];
    }

    public byte dataQualityFlags() {
        return this.fsdh[38];
    }

    public int numDataBlockettes() {
        return this.fsdh[39];
    }

    public int timeCorrection() {
        int timeCorrection = this.converter.makeInt(this.fsdh[40], this.fsdh[41], this.fsdh[42], this.fsdh[43]);
        if (this.byteSwapNeeded()) {
            timeCorrection = this.converter.swapInt(timeCorrection);
        }
        return timeCorrection;
    }

    public int offsetToData() {
        short offset = this.converter.makeShort(this.fsdh[44], this.fsdh[45]);
        if (this.byteSwapNeeded()) {
            offset = this.converter.swapShort(offset);
        }
        return offset;
    }

    public int firstBlocketteOffset() {
        short offset = this.converter.makeShort(this.fsdh[46], this.fsdh[47]);
        if (this.byteSwapNeeded()) {
            offset = this.converter.swapShort(offset);
        }
        return offset;
    }

    public byte[] getBytes() {
        return this.dataRecord;
    }

    static String buildFlagString(byte flags) {
        String flagStr = Integer.toBinaryString(flags);
        int strLength = flagStr.length();
        if (strLength < 8) {
            int padLength = 8 - strLength;
            String formatStr = "%" + padLength + "." + padLength + "d";
            Format fmts = new Format(formatStr);
            flagStr = String.valueOf(fmts.format(0)) + flagStr;
        }
        return flagStr;
    }

    public String toString() {
        String sepStr = "      ";
        String header = String.valueOf(this.fmt2s.format(this.network())) + sepStr + this.fmt5s.format(this.station()) + sepStr + this.fmt2s.format(this.locationID()) + sepStr + this.fmt3s.format(this.channel()) + sepStr + this.recordStartTime();
        header = this.byteSwapNeeded() ? String.valueOf(header) + sepStr + "[BYTE SWAP MODE]" : String.valueOf(header) + sepStr + "  [NO SWAP MODE]";
        String nsampStr = "         # samples in record: " + this.numSamples();
        String srateFactStr = "                 sample_rate: " + this.sampleRateFactor();
        String srateMultStr = "                  multiplier: " + this.sampleRateMultiplier();
        String activityFlagsStr = "              activity flags: " + SeedDataRecord.buildFlagString(this.activityFlags());
        String ioClockFlagsStr = "         I/O and clock flags: " + SeedDataRecord.buildFlagString(this.ioAndClockFlags());
        String dataQualFlagsStr = "          data quality flags: " + SeedDataRecord.buildFlagString(this.dataQualityFlags());
        String numBlktsStr = "             # of blockettes: " + this.numDataBlockettes();
        String timeCorrStr = "             time correction: " + this.timeCorrection();
        String dataOffsetStr = "           begin data offset: " + this.offsetToData();
        String beginBlktStr = "        begin blkette offset: " + this.firstBlocketteOffset();
        String val = String.valueOf(header) + "\n" + nsampStr + "\n" + srateFactStr + "\n" + srateMultStr + "\n" + activityFlagsStr + "\n" + ioClockFlagsStr + "\n" + dataQualFlagsStr + "\n" + numBlktsStr + "\n" + timeCorrStr + "\n" + dataOffsetStr + "\n" + beginBlktStr;
        int numDataBlockettes = this.dataBlocketteList.size();
        int i = 0;
        while (i < numDataBlockettes) {
            DataBlockette blkt = (DataBlockette)this.dataBlocketteList.get(i);
            if (blkt.getType() == 100) {
                val = String.valueOf(val) + "\n" + ((Blockette100)blkt).toString();
            } else if (blkt.getType() == 1000) {
                val = String.valueOf(val) + "\n" + ((Blockette1000)blkt).toString();
            }
            ++i;
        }
        return val;
    }
}

