/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.seedutils.AlphaComparator;
import edu.iris.seedutils.SeedLookupMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class StandaloneLookupMap
extends SeedLookupMap {
    private static final long serialVersionUID = 1L;
    private boolean debugOutput = false;

    public int getLookup(int mapType, Object val) {
        HashMap map;
        boolean firstVal = true;
        int saveVal = -1;
        String mapName = this.getMapName(mapType);
        if (!this.containsKey(mapName)) {
            map = new HashMap();
            this.put(mapName, map);
        } else {
            map = (HashMap)this.get(mapName);
        }
        if (!map.containsValue(val)) {
            int i = 0;
            while (i < map.size()) {
                if (!map.containsKey(new Integer(i + 1))) break;
                ++i;
            }
            if (this.debugOutput) {
                System.out.println("+++ add value of " + val + " at index " + (i + 1));
            }
            saveVal = i + 1;
            map.put(new Integer(saveVal), val);
        } else {
            AlphaComparator comparator = new AlphaComparator();
            Set keys = map.keySet();
            Object[] keyVals = keys.toArray();
            Arrays.sort(keyVals, comparator);
            int i = 0;
            while (i < keyVals.length) {
                if (map.get(keyVals[i]).equals(val)) {
                    if (!this.debugOutput) break;
                    System.out.println("+++" + map.get(keyVals[i]) + " == " + val + ", return " + (Integer)keyVals[i]);
                    break;
                }
                if (this.debugOutput) {
                    System.out.println("+++" + map.get(keyVals[i]) + " != " + val);
                }
                ++i;
            }
            saveVal = (Integer)keyVals[i];
        }
        return saveVal;
    }

    public int findLookup(int mapType, Object val) {
        HashMap map;
        int saveVal = -1;
        String mapName = this.getMapName(mapType);
        if (!this.containsKey(mapName)) {
            map = new HashMap();
            this.put(mapName, map);
        } else {
            map = (HashMap)this.get(mapName);
        }
        if (!map.containsValue(val)) {
            return -1;
        }
        AlphaComparator comparator = new AlphaComparator();
        Set keys = map.keySet();
        Object[] keyVals = keys.toArray();
        Arrays.sort(keyVals, comparator);
        int i = 0;
        while (i < keyVals.length) {
            if (map.get(keyVals[i]).equals(val)) {
                if (!this.debugOutput) break;
                System.out.println("+++" + map.get(keyVals[i]) + " == " + val + ", return " + (Integer)keyVals[i]);
                break;
            }
            if (this.debugOutput) {
                System.out.println("+++" + map.get(keyVals[i]) + " != " + val);
            }
            ++i;
        }
        saveVal = (Integer)keyVals[i];
        return saveVal;
    }

    public HashMap getHashMap(int mapType) {
        HashMap map;
        String mapName = this.getMapName(mapType);
        if (!this.containsKey(mapName)) {
            map = new HashMap();
            this.put(mapName, map);
        } else {
            map = (HashMap)this.get(mapName);
        }
        return map;
    }

    public Object setLookup(int mapType, Object lookup, Object val) {
        HashMap map;
        String mapName = this.getMapName(mapType);
        if (!this.containsKey(mapName)) {
            map = new HashMap();
            this.put(mapName, map);
        } else {
            map = (HashMap)this.get(mapName);
        }
        return map.put(lookup, val);
    }

    public Object getMatch(int mapType, Object lookup) {
        String mapName = this.getMapName(mapType);
        if (!this.containsKey(mapName)) {
            return null;
        }
        HashMap map = (HashMap)this.get(mapName);
        if (!map.containsKey(lookup)) {
            return null;
        }
        return map.get(lookup);
    }

    private String getMapName(int mapType) {
        switch (mapType) {
            case 4: {
                return "DataFormatMap";
            }
            case 5: {
                return "CitedSourceMap";
            }
            case 6: {
                return "CommentMap";
            }
            case 7: {
                return "GenericLookupMap";
            }
            case 8: {
                return "UnitsMap";
            }
        }
        return "";
    }
}

