/*
 * Decompiled with CFR 0.152.
 */
package net.spy.ant;

import java.io.IOException;
import java.lang.reflect.Constructor;
import net.spy.util.InterfaceImplementor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceImplementorTask
extends Task {
    private String superClass = null;
    private String interfaceName = null;
    private String outClass = null;
    private String outDir = null;

    public void setSuperClass(String to) {
        this.superClass = to;
    }

    public void setInterfaceName(String to) {
        this.interfaceName = to;
    }

    public void setOutClass(String to) {
        this.outClass = to;
    }

    public void setOutDir(String to) {
        this.outDir = to;
    }

    private void validateArg(String val, String name) throws BuildException {
        if (val == null) {
            throw new BuildException("Missing argument:  " + name);
        }
    }

    private void validateArgs() throws BuildException {
        this.validateArg(this.interfaceName, "interfaceName");
        this.validateArg(this.outClass, "outClass");
        this.validateArg(this.outDir, "outDir");
    }

    protected void generateWith(Class<? extends InterfaceImplementor> c) throws BuildException {
        Class<?> theInterface = null;
        try {
            theInterface = Class.forName(this.interfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Could not load interface " + this.interfaceName, (Throwable)e);
        }
        InterfaceImplementor ii = null;
        try {
            Class[] params = new Class[]{Class.class};
            Constructor<? extends InterfaceImplementor> cons = c.getConstructor(params);
            Object[] args = new Object[]{theInterface};
            ii = cons.newInstance(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("Could not instantiate " + c + " with " + theInterface, (Throwable)e);
        }
        try {
            if (this.superClass != null) {
                ii.setSuperClass(Class.forName(this.superClass));
            }
            ii.setOutputClass(this.outClass);
            ii.writeSourceToFile(this.outDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException("Couldn't generate class", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new BuildException("Couldn't generate class", (Throwable)e);
        }
    }

    public void execute() throws BuildException {
        this.validateArgs();
        this.generateWith(InterfaceImplementor.class);
    }
}

